/*******************************************************************************
	[MainBoard.h]

	Copyright (C) 2004 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
*******************************************************************************/
#ifndef MAIN_BOARD_H
#define MAIN_BOARD_H

#include <stdio.h>
#include "TypeDefs.h"
#include "CPU.h"
#include "VDC.h"
#include "APU.h"
#include "PSG.h"
#include "IntCtrl.h"
#include "Timer.h"
#include "Cartridge.h"
#include "JoyPad.h"
#include "Mouse.h"
#include "MB128.h"
#include "CDROM.h"
#include "ADPCM.h"

//KitaoǉBXe[gZ[ũo[WBÂ̂ʂēǂݍ߂悤ɂ邽߂ɕKvB
//v0.501Bv0.512ɁBv0.573ɁBv0.584ɁBv0.605ɁBv0.616ɁB
//v0.627ɁBv0.648ɁBv0.659ɁBv0.7210ɁBv0.7411ɁBv0.7812ɁB
//v0.7913ɁBv0.8014ɁBv0.8215ɁBv0.8716ɁBv0.8917ɁBv0.9118ɁB
//v0.9219ɁBv0.9420ɁBv0.9521ɁBv1.0022ɁBv1.0223ɁBv1.0324ɁB
//v1.0825ɁBv1.1126ɁBv1.1527ɁBv1.3028ɁBv1.3129ɁBv1.3830ɁB
//v1.4031ɁBv1.4332ɁB(33,34v1.61beta)Bv1.6135ɁBv1.6336ɁB
//v1.6537ɁBv2.0040ɁBv2.0841ɁBv2.2742ɁBv2.2843ɁBv2.47beta44ɁB
//v2.4745ɁBv2.79beta46ɁBv2.7947ɁBv2.8148ɁBv2.8749ɁBv2.95beta50ɁB
//v2.9551ɁBv3.0252ɁBv3.0553ɁB
#define SAVE_STATE_VERSION	53


enum RamType
{
	MAINBOARD_MAINRAM = 0,
	MAINBOARD_BUFFERRAM,
	MAINBOARD_ARCADERAM
};


BOOL
MAINBOARD_Init(
	const char*		pGameName);

void
MAINBOARD_Deinit();

void
MAINBOARD_Pause(
	BOOL	bPause);

//Kitaoǉ
void
MAINBOARD_Pause2(
	BOOL	bPause);

//Kitaoǉ
void
MAINBOARD_PauseNoMessage(
	BOOL	bPause);

BOOL
MAINBOARD_SaveBRAM(
	const char*		pathName);

BOOL
MAINBOARD_LoadBRAM(
	const char*		pathName);

void
MAINBOARD_Reset();

//Kitaoǉ
Uint8
MAINBOARD_GetBuffer();

void
MAINBOARD_AdvanceFrame();

void
MAINBOARD_AdvanceFrameSim();

Sint32
MAINBOARD_AdvanceInstruction();


//Kitaoǉ
void
MAINBOARD_ResetFastForwardingCount();


BOOL
MAINBOARD_ChangeScreenMode(
	Sint32		screenWidth,
	Sint32		screenHeight,
	Sint32		magnification,
	BOOL		bFullScreen);


BOOL
MAINBOARD_ChangeSoundMode(
	Uint32		bufferSize,
	Uint32		sampleRate,
	Uint32		masterVolume);

BOOL
MAINBOARD_SaveState(
	FILE*		p);

BOOL
MAINBOARD_LoadState(
	FILE*		p);

void
MAINBOARD_ChangeMemoryValue(
	Sint32		ramType,
	Uint32		addr,
	Uint8		data);

//Kitaoǉ
void
MAINBOARD_ScreenUpdate(
	BOOL	bVsync,
	BOOL	bFullScreenRefresh);

//Kitaoǉ
void
MAINBOARD_ScreenEncord();

//Kitaoǉ
void
MAINBOARD_ScreenUpdateFast();

//KitaoǉBv2.77
void
MAINBOARD_ScreenUpdateClear();

//Kitaoǉ
void
MAINBOARD_DrawScreenshot();

//Kitaoǉ
void
MAINBOARD_ScreenClear();

//Kitaoǉ
BOOL
MAINBOARD_GetPause();

//Kitaoǉ
void
MAINBOARD_SetBigSoundBuffer(
	Sint32 n);

//Kitaoǉ
Sint32
MAINBOARD_GetMagnification();

//Kitaoǉ
Sint32
MAINBOARD_GetScanline();

//Kitaoǉ
void
MAINBOARD_SetSuperGrafx(
	Sint32	superGrafx);

//Kitaoǉ
Sint32
MAINBOARD_GetSuperGrafx();

//Kitaoǉ
void
MAINBOARD_SetArcadeCard(
	BOOL	arcadeCard);

//Kitaoǉ
BOOL
MAINBOARD_GetArcadeCard();

//Kitaoǉ
void
MAINBOARD_SetBackupFull(
	BOOL	backupFull);

//Kitaoǉ
BOOL
MAINBOARD_GetBackupFull();

//Kitaoǉ
void
MAINBOARD_SetStretched(
	BOOL	bStretched,
	BOOL	bVStretched);

//KitaoǉBv3.01
BOOL
MAINBOARD_GetStretched();

//Kitaoǉ
Uint32
MAINBOARD_GetStateVersion();

//Kitaoǉ
BOOL
MAINBOARD_LoadScreenBuf(
	Sint32	num,
	FILE*	p);

//Kitaoǉ
void
MAINBOARD_RestoreScreenBuf();

//Kitaoǉ
void
MAINBOARD_ResetFastForwardingCount();

//Kitaoǉ
void
MAINBOARD_SetFastForwarding(
	Sint32	fastForwarding,
	BOOL	bSoundAjust,
	BOOL	bReset);

//Kitaoǉ
Sint32
MAINBOARD_GetFastForwarding();

//Kitaoǉ
Sint32
MAINBOARD_GetFastForwardingR();

//Kitaoǉ
BOOL
MAINBOARD_GetSystemInit();

//Kitaoǉ
void
MAINBOARD_TG16BitConvert(
	char*	pGameName,
	BOOL	bCDGame);

//Kitaoǉ
void
MAINBOARD_OverDumpedConvert();

//Kitaoǉ
void
MAINBOARD_IncSysTime();

//Kitaoǉ
void
MAINBOARD_SetGradiusII();

//Kitaoǉ
Sint32
MAINBOARD_GetProcessingDelay();

//Kitaoǉ
Sint32
MAINBOARD_GetDisplayedFrames();

//Kitaoǉ
void
MAINBOARD_ResetPrevTvW();

//Kitaoǉ
BOOL
MAINBOARD_GetResolutionChange();

//Kitaoǉ
void
MAINBOARD_SetResolutionChange(
	BOOL	bResolutionChange);

//Kitaoǉ
Sint32
MAINBOARD_GetShowOverscanTop();

//Kitaoǉ
Sint32
MAINBOARD_GetShowOverscanBottom();

//Kitaoǉ
Sint32
MAINBOARD_GetShowOverscanLeft();

//Kitaoǉ
Sint32
MAINBOARD_GetShowOverscanRight();

//Kitaoǉ
BOOL
MAINBOARD_GetShowOverscan();

//Kitaoǉ
void
MAINBOARD_SetShowOverscanTop(
	Sint32	showOverscanTop);

//Kitaoǉ
void
MAINBOARD_SetShowOverscanBottom(
	Sint32	showOverscanBottom);

//Kitaoǉ
void
MAINBOARD_SetShowOverscanLeft(
	Sint32	showOverscanLeft);

//Kitaoǉ
void
MAINBOARD_SetShowOverscanRight(
	Sint32	showOverscanRight);

//Kitaoǉ
BOOL
MAINBOARD_GetFourSplitScreen();

//Kitaoǉ
BOOL
MAINBOARD_GetMonoColor();

//Kitaoǉ
Sint32
MAINBOARD_GetForceMonoColor();

//Kitaoǉ
void
MAINBOARD_SetForceMonoColor(
	Sint32	forceMonoColor);

//Kitaoǉ
Uint8*
MAINBOARD_GetpMainRam();

//Kitaoǉ
void
MAINBOARD_WriteROM(
	Uint32		mpr,
	Uint32		addr,
	Uint8		data);

//Kitaoǉ
void
MAINBOARD_SetContinuousWriteValue(
	BOOL		bContinuous,
	Uint32		mpr,
	Uint32		addr,
	Uint8		data);

//Kitaoǉ
BOOL
MAINBOARD_GetSystemCard();

//KitaoǉBv2.63
Uint32
MAINBOARD_GetSysTime();

//KitaoǉBv2.63
void
MAINBOARD_ResetSysTime();

//KitaoǉBv3.05
BOOL
MAINBOARD_GetSalamander();

//KitaoǉBv3.05
BOOL
MAINBOARD_GetNecros();

//KitaoǉBv2.70
BOOL
MAINBOARD_GetWorldStadium91();

//KitaoǉBv2.70
BOOL
MAINBOARD_GetWorldStadium();

//KitaoǉBv2.70
BOOL
MAINBOARD_GetPowerLeague34593();

//KitaoǉBv2.70
BOOL
MAINBOARD_GetPowerLeague2();

//KitaoǉBv2.70
BOOL
MAINBOARD_GetNaxatStadium();

//KitaoǉBv2.70
BOOL
MAINBOARD_GetKoregaPro();

//KitaoǉBv3.04
BOOL
MAINBOARD_GetTatsujin();

//KitaoǉBv2.77
BOOL
MAINBOARD_GetUpdateFullScreen();

//KitaoǉBv2.84
void
MAINBOARD_SetCDAccess(
	BOOL	bCDAccess);

//KitaoǉBv2.84
void
MAINBOARD_ResetCDAccess();

//KitaoǉBv2.94
void
MAINBOARD_SetVSyncHz(
	Sint32	fullVSyncHz);

//KitaoǉBv2.94
Sint32
MAINBOARD_GetVSyncHz();


#endif /* MAIN_BOARD_H */
