/******************************************************************************
Ootake
EDirect3Dł̕`ɂΉBVistaΉB
EWindow\ɂDirectDrawg悤ɂB
E񂵋@\tB

Copyright(C)2006-2025 Kitao Nakamura.
	ŁEpłJȂƂ͕K\[XR[hYtĂB
	̍ۂɎł܂܂̂ŁAЂƂƂm点ƍKłB
	Iȗp͋ւ܂B
	Ƃ́uGNU General Public License(ʌOp_)vɏ܂B

*******************************************************************************
	[Screen.c]

	Implement ScreenInterface.

	Copyright (C) 2004 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
******************************************************************************/
#include <stdio.h>
#include <math.h> //pow()֐ŕKv
#include "Screen.h"
#include "ScreenDD.h"
#include "ScreenD3D.h"
//#include "GDIScreen.h"
#include "TIMER.h"
#include "VDC.h"
#include "CDROM.h"
#include "APU.h"
#include "App.h"
#include "MainBoard.h"
#include "WinMain.h"
#include "Printf.h"

//KitaoǉB\pK}e[u
Uint32 _GammaTBL[0xFFFFFF+1];    //24bit̐FR[h(PCE9bit24(32)bit)̐Fe[uBBGRBv2.99
Uint32 _GammaTBLs80[0xFFFFFF+1]; //XLC80%p
Uint32 _GammaTBLs90[0xFFFFFF+1]; //XLC90%p
Uint32 _MonoTBL[0xFFFFFF+1];    //mNϊpe[uBBGRBO[fBXvC[h̎̓O[mNɂȂBv2.99
Uint32 _MonoTBLs80[0xFFFFFF+1]; //XLC80%p
Uint32 _MonoTBLs90[0xFFFFFF+1]; //XLC90%p

static Sint32	_Width;
static Sint32	_Height;
static Sint32	_Magnification;	//(Screen.cpp)ł_Magnification̓XN[Vbgp\̂Ƃ́AƈvȂƂ̂ŒӁBv2.28L
static Uint32	_Flags;

//KitaoǉBv2.70
static Uint32	_SBSwapBuf[40*16]; //40(hbg)*16(chbg)*sizeof(Uint32)
static Uint32	_SBWorldStadium91[]   = {0x00030303,0x00070707,0x00000000,0x00000000,0x00070700,0x00070700};
static Uint32	_SBWorldStadium[]     = {0x00000006,0x00000002,0x00000002,0x00000002,0x00070700,0x00070700};
static Uint32	_SBWorldStadium2[]    = {0x00000006,0x00000002,0x00000002,0x00000500,0x00000500,0x00000500};
static Uint32	_SBPowerLeague34593[] = {0x00070701,0x00070701,0x00000000,0x00000000,0x00000000,0x00070701};
static Uint32	_SBPowerLeague2[]     = {0x00070701,0x00070701,0x00000000,0x00000000,0x00000000,0x00070701};
static Uint32	_SBPowerLeague[]      = {0x00010101,0x00060605,0x00060605,0x00060605,0x00060605,0x00010101};
static Uint32	_SBEikanKimi1[]       = {0x00070707,0x00000301,0x00000301,0x00000301,0x00070707};
static Uint32	_SBEikanKimi2[]       = {0x00060606,0x00000200,0x00000200,0x00000200,0x00060606};
static Uint32	_SBEikanKimi3[]       = {0x00050505,0x00000100,0x00000100,0x00000100,0x00050505};
static Uint32	_SBEikanKimi4[]       = {0x00040404,0x00000000,0x00000000,0x00000000,0x00040404};
static Uint32	_SBEikanKimi5[]       = {0x00030303,0x00000000,0x00000000,0x00000000,0x00030303};
static Uint32	_SBEikanKimi6[]       = {0x00020202,0x00000000,0x00000000,0x00000000,0x00020202};
static Uint32	_SBEikanKimi7[]       = {0x00010101,0x00000000,0x00000000,0x00000000,0x00010101};
static Uint32	_SBEikanKimi8[]       = {0x00000000,0x00010101,0x00010101,0x00000000,0x00000000};
static Uint32	_SBNaxatStadium[]     = {0x00050507,0x00050507,0x00050507,0x00050507,0x00050507,0x00000000};
static Uint32	_SBRomRomStadium[]    = {0x00000000,0x00000000,0x00070707,0x00070707,0x00070707,0x00000000};
static Uint32	_SBBaseballer1[]      = {0x00070707,0x00040507,0x00000202,0x00000202,0x00000202,0x00070707};
static Uint32	_SBBaseballer2[]      = {0x00040404,0x00020304,0x00000101,0x00000101,0x00000101,0x00040404};
static Uint32	_SBBaseballer3[]      = {0x00030303,0x00020303,0x00000101,0x00000101,0x00000101,0x00030303};
static Uint32	_SBKoregaPro1[]       = {0x00010204,0x00000000,0x00000000,0x00000000,0x00000000};
static Uint32	_SBKoregaPro2[]       = {0x00010203,0x00000000,0x00000000,0x00000000,0x00000000};
static Uint32	_SBKoregaPro3[]       = {0x00010202,0x00000000,0x00000000,0x00000000,0x00000000};
static Uint32	_SBKoregaPro4[]       = {0x00010101,0x00000000,0x00000000,0x00000000,0x00000000};
static Uint32	_SBKoregaPro5[]       = {0x00000103,0x00060606,0x00060606,0x00060606,0x00060606};
static Uint32	_SBKoregaPro6[]       = {0x00000002,0x00050505,0x00050505,0x00050505,0x00050505};
static Uint32	_SBKoregaPro7[]       = {0x00000001,0x00040404,0x00040404,0x00040404,0x00040404};
static Uint32	_SBKoregaPro8[]       = {0x00000000,0x00030303,0x00030303,0x00030303,0x00030303};
static Uint32	_SBKoregaPro9[]       = {0x00000000,0x00020202,0x00020202,0x00020202,0x00020202};
static Uint32	_SBKoregaProA[]       = {0x00000000,0x00010101,0x00010101,0x00010101,0x00010101};
static Uint32	_SBTheProYakyuu1[]    = {0x00000000,0x00070707,0x00070707,0x00070707,0x00070707};
static Uint32	_SBTheProYakyuu2[]    = {0x00000000,0x00060606,0x00060606,0x00060606,0x00060606};
static Uint32	_SBTheProYakyuu3[]    = {0x00000000,0x00050505,0x00050505,0x00050505,0x00050505};
static Uint32	_SBTheProYakyuu4[]    = {0x00000000,0x00040404,0x00040404,0x00040404,0x00040404};
static Uint32	_SBTheProYakyuu11[]   = {0x00000000,0x00070707,0x00070707,0x00000000,0x00070707};
static Uint32	_SBTheProYakyuu12[]   = {0x00000000,0x00060606,0x00060606,0x00000000,0x00060606};
static Uint32	_SBTheProYakyuu13[]   = {0x00000000,0x00050505,0x00050505,0x00000000,0x00050505};
static Uint32	_SBTheProYakyuu14[]   = {0x00000000,0x00040404,0x00040404,0x00000000,0x00040404};
static Uint32	_SBTheProYakyuu15[]   = {0x00000000,0x00030303,0x00030303,0x00000000,0x00030303};
static Uint32	_SBTheProYakyuu16[]   = {0x00000000,0x00020202,0x00020202,0x00000000,0x00020202};
static Uint32	_SBTheProYakyuu17[]   = {0x00000000,0x00010101,0x00010101,0x00000000,0x00010101};
static Uint32	_SBTheProYakyuu21[]   = {0x00000000,0x00000000,0x00070707,0x00070707,0x00000000};
static Uint32	_SBTheProYakyuu22[]   = {0x00000000,0x00000000,0x00060606,0x00060606,0x00000000};
static Uint32	_SBTheProYakyuu23[]   = {0x00000000,0x00000000,0x00050505,0x00050505,0x00000000};
static Uint32	_SBTheProYakyuu24[]   = {0x00000000,0x00000000,0x00040404,0x00040404,0x00000000};
static Uint32	_SBTheProYakyuu25[]   = {0x00000000,0x00000000,0x00030303,0x00030303,0x00000000};
static Uint32	_SBTheProYakyuu26[]   = {0x00000000,0x00000000,0x00020202,0x00020202,0x00000000};
static Uint32	_SBTheProYakyuu27[]   = {0x00000000,0x00000000,0x00010101,0x00010101,0x00000000};
static Uint32	_SBTatsujin[]		  = {0x00050506,0x00070707,0x00060607,0x00060607,0x00050506};
static Uint32	_SBNecros[]			  = {0x00000000,0x00070707,0x00000000,0x00000000,0x00070707}; //v3.05

//KitaoǉBAṽEBhȄԂۑĂ߂̕ϐBv2.24
static HWND				_OtherAppWindowHWnd[512];
static WINDOWPLACEMENT	_OtherAppWindowPlacement[512];
static Sint32			_OtherAppWindowN;


//KitaoǉBEBhEʒuۑ̂߂̃R[obNBv2.24
static BOOL
CALLBACK EnumWindowsSaveProc(HWND hWnd, LPARAM lParam)
{
	if ((IsWindowVisible(hWnd))&&(hWnd != WINMAIN_GetHwnd()))
	{
		if (_OtherAppWindowN < 512)
		{
			_OtherAppWindowHWnd[_OtherAppWindowN] = hWnd;
			_OtherAppWindowPlacement[_OtherAppWindowN].length = sizeof(WINDOWPLACEMENT);
			GetWindowPlacement(hWnd, &_OtherAppWindowPlacement[_OtherAppWindowN]);
			_OtherAppWindowN++;
		}
	}
	return TRUE;
}

//KitaoǉBEBhEʒuۑBv2.24
void
SCREEN_SaveWindowPosition()
{
	_OtherAppWindowN = 0;
	EnumWindows(EnumWindowsSaveProc, NULL);
	//PRINTF("WindowN %d",_OtherAppWindowN); //test
}

//KitaoǉBEBhEʒu߂߂̃R[obNBv2.24
static BOOL
CALLBACK EnumWindowsLoadProc(HWND hWnd, LPARAM lParam)
{
	int		i;	

	for (i=0; i<_OtherAppWindowN; i++)
		if (_OtherAppWindowHWnd[i] == hWnd)
		{
			SetWindowPlacement(hWnd, &_OtherAppWindowPlacement[i]);
			break;
		}
	return TRUE;
}

//KitaoǉBEBhEʒu߂Bv2.24
void
SCREEN_LoadWindowPosition()
{
	EnumWindows(EnumWindowsLoadProc, NULL);
}


/*-----------------------------------------------------------------------------
	[Init]
		XN[[h(ύX)܂B KitaoXVBv2.28
-----------------------------------------------------------------------------*/
BOOL
SCREEN_Init(
	Sint32		width,
	Sint32		height,
	Sint32		magnification, //Kitaoǉ
	Uint32		flags)
{
	BOOL	ret;

	_Width = width;
	_Height = height;
	_Magnification = magnification; //Kitaoǉ
	_Flags = flags;

	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			SCREEND3D_Deinit();
			ret = SCREEND3D_Init(_Width, _Height, _Magnification, _Flags);
			break;
		case 2: //DirectDraw
			SCREENDD_Deinit();
			ret = SCREENDD_Init(_Width, _Height, _Magnification, _Flags);
			break;
		default:
			ret = FALSE;
			break;
	}

	return ret;
}


/*-----------------------------------------------------------------------------
	[Deinit]
		XN[̏IsȂ܂B
-----------------------------------------------------------------------------*/
void
SCREEN_Deinit()
{
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			SCREEND3D_Deinit();
			break;
		case 2: //DirectDraw
			SCREENDD_Deinit();
			break;
	}
}


//I[fBIOt\p̃obt@NABv2.92ǉ
void
SCREEN_InitAudioGraph()
{
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			SCREEND3D_InitAudioGraph();
			break;
	}
}


/*-----------------------------------------------------------------------------
	[ToggleFullScreen]
		XN[EChE^tXN[ɐ؂ւ܂D
-----------------------------------------------------------------------------*/
BOOL
SCREEN_ToggleFullScreen()
{
	if (_Flags & SCREEN_FFULLSCREEN)
		_Flags &= ~SCREEN_FFULLSCREEN;
	else
		_Flags |= SCREEN_FFULLSCREEN;
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			SCREEND3D_Deinit();
			return SCREEND3D_Init(_Width, _Height, _Magnification, _Flags);
		case 2: //DirectDraw
			SCREENDD_Deinit();
			return SCREENDD_Init(_Width, _Height, _Magnification, _Flags);
		default:
			return FALSE;
	}
}


/*-----------------------------------------------------------------------------
	[WaitVBlank]
		AԂ҂܂B 
-----------------------------------------------------------------------------*/
//KitaoXV
BOOL
SCREEN_WaitVBlank(
	BOOL	bDraw) //bDrawTRUEɂČĂԂƕ`sBFALSȄꍇVSync҂̂݁BDirect3DppBKitaoǉB
{
	BOOL	ret;

	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			ret = SCREEND3D_WaitVBlank(bDraw);
			break;
		case 2: //DirectDraw
			ret = SCREENDD_WaitVBlank(FALSE); //DirectDraŵƂ͏ɕ`͍sȂB
			break;
		default:
			return FALSE;
	}
	
	return ret;
}


void*
SCREEN_GetBuffer()
{
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			return SCREEND3D_GetBuffer();
		case 2: //DirectDraw
			return SCREENDD_GetBuffer();
		default:
			return NULL;
	}
}


const Sint32
SCREEN_GetBufferPitch()
{
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			return SCREEND3D_GetBufferPitch();
		case 2: //DirectDraw
			return SCREENDD_GetBufferPitch();
		default:
			return 0;
	}
}


//KitaoǉBXN[ŜNABQ[ʂ͈̔͊O̕܂߂āAfBXvCŜNA܂Bv1.43
void
SCREEN_Clear(
	byte	r,
	byte	g,
	byte	b) //v2.73XVBCӂ̐FŃNAł悤ɂB16rbg[ĥƂ̓mNȊOƐF̂Ō݂̓mNŒr̃f[^̂ݎgpB
{
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			SCREEND3D_Clear(r,g,b);
			break;
		case 2: //DirectDraw
			SCREENDD_Clear(r,g,b);
			break;
	}
}


//KitaoǉBQ[ʂwFŃNABVSync҂sBv2.77
void
SCREEN_Fill(
	Uint32	color)
{
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			//120Hzȏ̏ꍇKvԂVBlank҂sBv2.98
			if (MAINBOARD_GetVSyncHz() >= 120)
				SCREEN_WaitVBlank(FALSE); //AԂ҂B`͍sȂB
			if (MAINBOARD_GetVSyncHz() >= 180)
				SCREEN_WaitVBlank(FALSE); //AԂ҂B`͍sȂB180Hz̏ꍇŌv2҂ƂɂȂB
			if (MAINBOARD_GetVSyncHz() >= 240)
				SCREEN_WaitVBlank(FALSE); //AԂ҂B`͍sȂB240Hz̏ꍇŌv3҂ƂɂȂB
			SCREEND3D_Fill(color);
			break;
		case 2: //DirectDraw
			//120Hzȏ̏ꍇKvԂVBlank҂sBv2.98
			if (MAINBOARD_GetVSyncHz() >= 120)
				SCREEN_WaitVBlank(FALSE); //AԂ҂B`͍sȂB
			if (MAINBOARD_GetVSyncHz() >= 180)
				SCREEN_WaitVBlank(FALSE); //AԂ҂B`͍sȂB180Hz̏ꍇŌv2҂ƂɂȂB
			if (MAINBOARD_GetVSyncHz() >= 240)
				SCREEN_WaitVBlank(FALSE); //AԂ҂B`͍sȂB240Hz̏ꍇŌv3҂ƂɂȂB
			SCREENDD_Fill(color, TRUE);
			break;
	}
}


/*-----------------------------------------------------------------------------
	[Blt]
		pSrc obNobt@։摜݂܂Bg^kA
	ĂԑO SCREEN_Lock() ܂傤B
-----------------------------------------------------------------------------*/
//KitaoXVBCƂɉ𑜓xςĂQ[(Ղ̌C120%Ȃ)ɑΉB
void
SCREEN_Blt(
	Uint32*		pSrc,
	Sint32		srcX,
	Sint32		srcY,
	Uint16*		pSrcW,	//KitaoXVB]̉sNZBsrcHC̐Ԃ
	Sint32		srcH,	//KitaoXVBdstWdstH ̓JbgB(ŌŒ肹AlXȑ傫ł̃y[XgɑΉ邽)
	Sint32		executeCode)  //KitaoǉBsR[hB0cGR[hsB1cvC}ʂ֓]sB
							  //					   3cEɍ(I[o[XL)zuĂ̓](Ƃ1Ɠ)
							  //					   5cẼI[o[XLJbgĂ̓](Ƃ1Ɠ)
							  //					   6cg莞pfps\≹Ot\͍sȂ(Ƃ1Ɠ)
{
	Sint32		a,i;
	Sint32		ov;

	//KitaoǉBlNX̗vǂ̃tbVoNQȂxɌyBv3.05
	if ((MAINBOARD_GetNecros()) && (APP_GetFlashGuardNecros()))//lNX̗vǂ̏ꍇ
	{
		//퓬V[ǂo
		ov = 3 + (MAINBOARD_GetShowOverscanLeft() / 4 * 3); //[̃I[o[XLGA\邽߂ɊmۂĂhbgBftHg(\)0E\ꍇ5ɁA3hbgԂ񑫂Bv2.92XV(щ4hbg)Bv2.98獕щ3hbgɁB
		if ((srcY <= 16+127) && (srcY+srcH >= 16+127+15))
		{
			if (memcmp(_SBNecros, pSrc+(16+127)*512+ov+17, 4*5) == 0) //퓬V[ʂ̃bZ[Wg\Ă
				VDC_SetNecrosBattle(TRUE);
			else
				VDC_SetNecrosBattle(FALSE);
		}
		//ۂ̌y(pbgύXɖ邳41ɂ)VDC.cppōs

		//	Uint32* pT = pSrc+(16+127)*512+ov+17; PRINTF("Color = %08X %08X %08X %08X %08X %08X", *pT,*(pT+1),*(pT+2),*(pT+3),*(pT+4),*(pT+5)); //Testp
	}

	//KitaoǉB싅Q[ŃJEg\̕яɕ\
	if (APP_GetStrikeBallSwap())
	{
		ov = 3 + (MAINBOARD_GetShowOverscanLeft() / 4 * 3); //[̃I[o[XLGA\邽߂ɊmۂĂhbgBftHg(\)0E\ꍇ5ɁA3hbgԂ񑫂Bv2.92XV(щ4hbg)Bv2.98獕щ3hbgɁB

		//[hX^WA'91ŃXgCNƃ{[̕\XbvBv2.70Bv2.92XVBv2.98牡256[hɂ͍ɍ3hbg悤ɂ̂ł̍W3hbgvXB
		if (MAINBOARD_GetWorldStadium91())
			if ((srcY <= 16+136)&&(srcY+srcH >= 16+144+7))
				if (memcmp(_SBWorldStadium91, pSrc+(16+136)*512+ov+14, 4*6) == 0) //XgCN\Ă
				{
					for (i = 0; i < 8; i++)
						memcpy(_SBSwapBuf+i*40, pSrc+(16+136+i)*512+ov+16, 4*32);
					for (i = 0; i < 8; i++)
						memcpy(pSrc+(16+136+i)*512+ov+16, pSrc+(16+144+i)*512+ov+16, 4*32);
					for (i = 0; i < 8; i++)
						memcpy(pSrc+(16+144+i)*512+ov+16, _SBSwapBuf+i*40, 4*32);
				}
		//[hX^WA()ŃXgCNƃ{[̕\XbvBv2.70Bv2.92XV
		if (MAINBOARD_GetWorldStadium())
			if ((srcY <= 16+136)&&(srcY+srcH >= 16+144+7))
				if (memcmp(_SBWorldStadium, pSrc+(16+136)*512+ov+14, 4*6) == 0) //XgCN\Ă
				{
					for (i = 0; i < 8; i++)
						memcpy(_SBSwapBuf+i*40, pSrc+(16+136+i)*512+ov+16, 4*32);
					for (i = 0; i < 8; i++)
						memcpy(pSrc+(16+136+i)*512+ov+16, pSrc+(16+144+i)*512+ov+16, 4*32);
					for (i = 0; i < 8; i++)
						memcpy(pSrc+(16+144+i)*512+ov+16, _SBSwapBuf+i*40, 4*32);
				}
				//else if (memcmp(_SBWorldStadium2, pSrc+(16+144)*512+ov+14, 4*6) == 0) //{[JEg\ĂꍇBłcQl̂Ƃ̃^CɕKvB
				//{
				//	for (i = 0; i < 8; i++)
				//		memcpy(pSrc+(16+144+i)*512+ov+16, pSrc+(16+176+i)*512+ov+16, 4*32); //{[JEg\B͏ȂقRȂ̂Ń{cB
				//}
		//p[[OR,S,T,'93ŃXgCNƃ{[̕\XbvBv2.70Bv2.92XV
		if (MAINBOARD_GetPowerLeague34593())
			if ((srcY <= 16+136)&&(srcY+srcH >= 16+146+7))
				if (memcmp(_SBPowerLeague34593, pSrc+(16+137)*512+ov+210, 4*6) == 0) //XgCN\Ă
				{
					for (i = 0; i < 8; i++)
						memcpy(_SBSwapBuf+i*40, pSrc+(16+136+i)*512+ov+210, 4*8);
					for (i = 0; i < 8; i++)
						memcpy(_SBSwapBuf+(8+i)*40, pSrc+(16+146+i)*512+ov+210, 4*8);
					for (i = 0; i < 8; i++)
						memcpy(pSrc+(16+136+i)*512+ov+210, pSrc+(16+136+i)*512+ov+222, 4*8);
					for (i = 0; i < 8; i++)
						memcpy(pSrc+(16+146+i)*512+ov+210, pSrc+(16+146+i)*512+ov+222, 4*8);
					for (i = 0; i < 8; i++)
						memcpy(pSrc+(16+136+i)*512+ov+222, _SBSwapBuf+i*40, 4*8);
					for (i = 0; i < 8; i++)
						memcpy(pSrc+(16+146+i)*512+ov+222, _SBSwapBuf+(8+i)*40, 4*8);
				}
		//p[[OQŃXgCNƃ{[̕\XbvBv2.70Bv2.92XV
		if (MAINBOARD_GetPowerLeague2())
			if ((srcY <= 16+136)&&(srcY+srcH >= 16+144+7))
				if (memcmp(_SBPowerLeague2, pSrc+(16+137)*512+ov+216, 4*6) == 0) //XgCN\Ă
				{
					for (i = 0; i < 8; i++)
						memcpy(_SBSwapBuf+i*40, pSrc+(16+136+i)*512+ov+216, 4*32);
					for (i = 0; i < 8; i++)
						memcpy(pSrc+(16+136+i)*512+ov+216, pSrc+(16+144+i)*512+ov+216, 4*32);
					for (i = 0; i < 8; i++)
						memcpy(pSrc+(16+144+i)*512+ov+216, _SBSwapBuf+i*40, 4*32);
				}
		//p[[ÕXRA{[hʂŁAŃXgCNƃ{[̕\XbvB̃JEg̓XvCgȂ̂VDC.cppɂĂȂBv2.70Bv2.92XV
		if (VDC_GetPowerLeague())
			if ((srcY <= 16+121)&&(srcY+srcH >= 16+129+7))
				if (memcmp(_SBPowerLeague, pSrc+(16+121)*512+ov+145, 4*6) == 0) //XgCN\Ă
				{
					for (i = 0; i < 8; i++)
						memcpy(_SBSwapBuf+i*40, pSrc+(16+121+i)*512+ov+144, 4*32);
					for (i = 0; i < 8; i++)
						memcpy(pSrc+(16+121+i)*512+ov+144, pSrc+(16+129+i)*512+ov+144, 4*32);
					for (i = 0; i < 8; i++)
						memcpy(pSrc+(16+129+i)*512+ov+144, _SBSwapBuf+i*40, 4*32);
				}
		//h͌Nɂ̃XRA{[hʂŁAXgCNƃ{[̕\XbvB̃JEg̓XvCgȂ̂VDP.cppɂĂȂBv2.70
		if (VDC_GetEikanKimi())
		{
			if ((srcY <= 16+9)&&(srcY+srcH >= 16+17+8)&&
				(memcmp(_SBEikanKimi1, pSrc+(16+10)*512+287, 4*5) == 0)) //XgCN\ĂB`[ΐ̃XRA{[h\B350[hȂ̂ov0B
			{
				for (i = 0; i < 8; i++)
					memcpy(_SBSwapBuf+i*40, pSrc+(16+9+i)*512+286, 4*32);
				for (i = 0; i < 8; i++)
					memcpy(pSrc+(16+9+i)*512+286, pSrc+(16+17+i)*512+286, 4*32);
				for (i = 0; i < 8; i++)
					memcpy(pSrc+(16+17+i)*512+286, _SBSwapBuf+i*40, 4*32);
			}
			else if ((srcY <= 16+9)&&(srcY+srcH >= 16+17+7)&&
					 ((memcmp(_SBEikanKimi8, pSrc+(16+21)*512+313, 4*5) == 0)||
					  (memcmp(_SBEikanKimi2, pSrc+(16+10)*512+287, 4*5) == 0)||
					  (memcmp(_SBEikanKimi3, pSrc+(16+10)*512+287, 4*5) == 0)||
					  (memcmp(_SBEikanKimi4, pSrc+(16+10)*512+287, 4*5) == 0)||
					  (memcmp(_SBEikanKimi5, pSrc+(16+10)*512+287, 4*5) == 0)||
					  (memcmp(_SBEikanKimi6, pSrc+(16+10)*512+287, 4*5) == 0)||
					  (memcmp(_SBEikanKimi7, pSrc+(16+10)*512+287, 4*5) == 0))) //XgCN\ĂBI
			{
				for (i = 0; i < 8; i++)
					memcpy(_SBSwapBuf+i*40, pSrc+(16+9+i)*512+286, 4*32);
				for (i = 0; i < 8; i++)
					memcpy(pSrc+(16+9+i)*512+286, pSrc+(16+17+i)*512+286, 4*32);
				for (i = 0; i < 8; i++)
					memcpy(pSrc+(16+17+i)*512+286, _SBSwapBuf+i*40, 4*32);
			}
			else if ((srcY <= 16+7)&&(srcY+srcH >= 16+15+7)&&
					 ((memcmp(_SBEikanKimi8, pSrc+(16+19)*512+313, 4*5) == 0)||
					  (memcmp(_SBEikanKimi2, pSrc+(16+ 8)*512+287, 4*5) == 0)||
					  (memcmp(_SBEikanKimi3, pSrc+(16+ 8)*512+287, 4*5) == 0)||
					  (memcmp(_SBEikanKimi4, pSrc+(16+ 8)*512+287, 4*5) == 0)||
					  (memcmp(_SBEikanKimi5, pSrc+(16+ 8)*512+287, 4*5) == 0)||
					  (memcmp(_SBEikanKimi6, pSrc+(16+ 8)*512+287, 4*5) == 0)||
					  (memcmp(_SBEikanKimi7, pSrc+(16+ 8)*512+287, 4*5) == 0))) //XgCN\ĂB`[m̑ΐ펞
			{
				for (i = 0; i < 8; i++)
					memcpy(_SBSwapBuf+i*40, pSrc+(16+7+i)*512+286, 4*32);
				for (i = 0; i < 8; i++)
					memcpy(pSrc+(16+7+i)*512+286, pSrc+(16+15+i)*512+286, 4*32);
				for (i = 0; i < 8; i++)
					memcpy(pSrc+(16+15+i)*512+286, _SBSwapBuf+i*40, 4*32);
			}
		}
		//iOUbgX^WABv2.92XV
		if (MAINBOARD_GetNaxatStadium())
		{
			if ((srcY <= 16+168)&&(srcY+srcH >= 16+176+7)&&
				(memcmp(_SBNaxatStadium, pSrc+(16+182)*512+ov+17, 4*6) == 0)) //AEgJEg\Ă
			{
				for (i = 0; i < 8; i++)
					memcpy(_SBSwapBuf+i*40, pSrc+(16+168+i)*512+ov+16, 4*32);
				for (i = 0; i < 8; i++)
					memcpy(pSrc+(16+168+i)*512+ov+16, pSrc+(16+176+i)*512+ov+16, 4*32);
				for (i = 0; i < 8; i++)
					memcpy(pSrc+(16+176+i)*512+ov+16, _SBSwapBuf+i*40, 4*32);
			}
		}
		//ROMROMX^WABv2.92XV
		if (CDROM_GetRomRomStadium())
		{
			if ((srcY <= 16+185)&&(srcY+srcH >= 16+193+7)&&
				(memcmp(_SBRomRomStadium, pSrc+(16+185)*512+ov+16, 4*6) == 0)) //XgCN\Ă
			{
				if (*(pSrc+(16+185)*512+ov+25) == 0x00000000) //ŃEBhE\
					a = 40;
				else
					a = 8;
				for (i = 0; i < 8; i++)
					memcpy(_SBSwapBuf+i*40, pSrc+(16+185+i)*512+ov+16, 4*a);
				for (i = 0; i < 8; i++)
					memcpy(pSrc+(16+185+i)*512+ov+16, pSrc+(16+193+i)*512+ov+16, 4*a);
				for (i = 0; i < 8; i++)
					memcpy(pSrc+(16+193+i)*512+ov+16, _SBSwapBuf+i*40, 4*a);
			}
		}
		//MWFhx[X{[[Bv2.92XV
		if (CDROM_GetBaseballer())
		{
			if ((srcY <= 16+64)&&(srcY+srcH >= 16+72+7)&&
				((memcmp(_SBBaseballer1, pSrc+(16+65)*512+ov+17, 4*6) == 0)||
				 (memcmp(_SBBaseballer2, pSrc+(16+65)*512+ov+17, 4*6) == 0)||
				 (memcmp(_SBBaseballer3, pSrc+(16+65)*512+ov+17, 4*6) == 0))) //XgCN\Ă
			{
				for (i = 0; i < 8; i++)
					memcpy(_SBSwapBuf+i*40, pSrc+(16+64+i)*512+ov+16, 4*32);
				for (i = 0; i < 8; i++)
					memcpy(pSrc+(16+64+i)*512+ov+16, pSrc+(16+72+i)*512+ov+16, 4*32);
				for (i = 0; i < 8; i++)
					memcpy(pSrc+(16+72+i)*512+ov+16, _SBSwapBuf+i*40, 4*32);
			}
		}
		//ꂪv싅'89ꂪv싅'90Bv2.92XV
		if (MAINBOARD_GetKoregaPro())
		{
			if ((srcY <= 16+144)&&(srcY+srcH >= 16+152+7)&&
				((memcmp(_SBKoregaPro1, pSrc+(16+153)*512+ov+224, 4*5) == 0)|| //{[̂Rڂ̃JEg\Ă
				 (memcmp(_SBKoregaPro2, pSrc+(16+153)*512+ov+224, 4*5) == 0)||
				 (memcmp(_SBKoregaPro3, pSrc+(16+153)*512+ov+224, 4*5) == 0)||
				 (memcmp(_SBKoregaPro4, pSrc+(16+153)*512+ov+224, 4*5) == 0)||
				 (memcmp(_SBKoregaPro5, pSrc+(16+145)*512+ov+192, 4*5) == 0)|| //XgCN\Ă
				 (memcmp(_SBKoregaPro6, pSrc+(16+145)*512+ov+192, 4*5) == 0)||
				 (memcmp(_SBKoregaPro7, pSrc+(16+145)*512+ov+192, 4*5) == 0)||
				 (memcmp(_SBKoregaPro8, pSrc+(16+145)*512+ov+192, 4*5) == 0)||
				 (memcmp(_SBKoregaPro9, pSrc+(16+145)*512+ov+192, 4*5) == 0)||
				 (memcmp(_SBKoregaProA, pSrc+(16+145)*512+ov+192, 4*5) == 0)))
			{
				for (i = 0; i < 8; i++)
					memcpy(_SBSwapBuf+i*40, pSrc+(16+144+i)*512+ov+192, 4*40);
				for (i = 0; i < 8; i++)
					memcpy(pSrc+(16+144+i)*512+ov+192, pSrc+(16+152+i)*512+ov+192, 4*40);
				for (i = 0; i < 8; i++)
					memcpy(pSrc+(16+152+i)*512+ov+192, _SBSwapBuf+i*40, 4*40);
			}
		}
		//CebNCD싅RiUEv싅CUEv싅SUPERCUEv싅SUPER'94jBv2.92XV
		if (VDC_GetTheProYakyuu())
		{
			if ((srcY <= 16+113)&&(srcY+srcH >= 16+128)&&
				((memcmp(_SBTheProYakyuu1, pSrc+(16+113)*512+ov+212, 4*5) == 0)||
				 (memcmp(_SBTheProYakyuu2, pSrc+(16+113)*512+ov+212, 4*5) == 0)||
				 (memcmp(_SBTheProYakyuu3, pSrc+(16+113)*512+ov+212, 4*5) == 0)||
				 (memcmp(_SBTheProYakyuu4, pSrc+(16+113)*512+ov+212, 4*5) == 0))) //ŐȉʂŃ{[JEg\Ă
			{
				if (*(pSrc+(16+120)*512+ov+213) != 0x00000000) //܂C̏ꍇ
				{
					memcpy(pSrc+(16+128)*512+ov+212, pSrc+(16+120)*512+ov+212, 4*2); //O(AEg)̍wiC
					*(pSrc+(16+120)*512+ov+213) = 0x00000000; //B({[)̍wiC
				}
			}
			if ((srcY <= 16+165)&&(srcY+srcH >= 16+169)&&
				((memcmp(_SBTheProYakyuu11, pSrc+(16+169)*512+ov+38, 4*5) == 0)||
				 (memcmp(_SBTheProYakyuu12, pSrc+(16+169)*512+ov+38, 4*5) == 0)||
				 (memcmp(_SBTheProYakyuu13, pSrc+(16+169)*512+ov+38, 4*5) == 0)||
				 (memcmp(_SBTheProYakyuu14, pSrc+(16+169)*512+ov+38, 4*5) == 0)||
				 (memcmp(_SBTheProYakyuu15, pSrc+(16+169)*512+ov+38, 4*5) == 0)||
				 (memcmp(_SBTheProYakyuu16, pSrc+(16+169)*512+ov+38, 4*5) == 0)||
				 (memcmp(_SBTheProYakyuu17, pSrc+(16+169)*512+ov+38, 4*5) == 0))) //tB[hʂŃ{[JEg\Ă
			{
				if ((*(pSrc+(16+166)*512+ov+62) != 0x00070003)&&
					((*(pSrc+(16+166)*512+ov+62) != 0x00000000)||(*(pSrc+(16+169)*512+ov+39) != 0x00070707))) //sNF()̃i[fBXeBl[VłȂortF[hAEg
						*(pSrc+(16+166)*512+ov+62) = *(pSrc+(16+169)*512+ov+39); //VDC.cppŏłȂiۊԔjŏ
			}
			if ((srcY <= 16+174)&&(srcY+srcH >= 16+175)&&
				((memcmp(_SBTheProYakyuu21, pSrc+(16+175)*512+ov+40, 4*5) == 0)||
				 (memcmp(_SBTheProYakyuu22, pSrc+(16+175)*512+ov+40, 4*5) == 0)||
				 (memcmp(_SBTheProYakyuu23, pSrc+(16+175)*512+ov+40, 4*5) == 0)||
				 (memcmp(_SBTheProYakyuu24, pSrc+(16+175)*512+ov+40, 4*5) == 0)||
				 (memcmp(_SBTheProYakyuu25, pSrc+(16+175)*512+ov+40, 4*5) == 0)||
				 (memcmp(_SBTheProYakyuu26, pSrc+(16+175)*512+ov+40, 4*5) == 0)||
				 (memcmp(_SBTheProYakyuu27, pSrc+(16+175)*512+ov+40, 4*5) == 0))) //tB[hʂŃXgCN\Ă
			{
				memcpy(pSrc+(16+175)*512+ov+47, pSrc+(16+174)*512+ov+47, 4*3); //VDC.cppŏłȂiX^PʂŃLFĂjŏ
				memcpy(pSrc+(16+175)*512+ov+53, pSrc+(16+174)*512+ov+53, 4*3); //
			}
		}
	}
	//Uint32* pT = pSrc+(16+136)*512+24; PRINTF("Color = %08X %08X %08X %08X %08X %08X", *pT,*(pT+1),*(pT+2),*(pT+3),*(pT+4),*(pT+5)); //Testp

	//TATSUJINŏ㉺̃I[o[XL̈\ꍇɁAX^[gorꂽɉʏ㉺[ɕ\S~\ɂBv3.04
	if (MAINBOARD_GetTatsujin())
	{
		if (!VDC_GetPerformSpriteLimit()) //XvCgČȂ̂݁BČݒɂĂꍇ́A@lɃS~\B
		{
			if (VDC_GetTvWidth() == 350)
				ov = MAINBOARD_GetShowOverscanLeft()/8 * 9; //[̃I[o[XLGA\邽߂ɊmۂĂhbg
			else //(VDC_GetTvWidth() == 260)
				ov = 3 + (MAINBOARD_GetShowOverscanLeft()/8 * 6); //[̃I[o[XLGA\邽߂ɊmۂĂhbg
			if ((srcY <= 16 + 3) && (srcY + srcH >= 16 + 3 + 15))
			{
				if (MAINBOARD_GetShowOverscanTop() > 0)
				{
					if (VDC_GetTvWidth() == 350)
					{//𑜓x350[h̏ꍇiZSLIMIĂꍇj
						//ォ3CځA271hbgڂ5hbgŁAX^[g̖\Ă邩ǂ`FbN
						if (memcmp(_SBTatsujin, pSrc + (16 + 3) * 512 + ov + 271, 4 * 5) == 0) //\ĂiX^[gorăX^[gj
						{
							for (i = 0; i < 15; i++) //I[o[XL̈̏ォ15CNA
								memset(pSrc + i * 512 + ov, 0, 4 * 350); //350hbgԂ0ŃNA
						}
					}
					else
					{//ʏ(VDC_GetTvWidth()==260B256[h)
						//ォ3CځA224hbgڂ5hbgŁAX^[g̖\Ă邩ǂ`FbN
						if (memcmp(_SBTatsujin, pSrc + (16 + 3) * 512 + ov + 224, 4 * 5) == 0) //\ĂiX^[gorăX^[gj
						{
							for (i = 0; i < 15; i++) //I[o[XL̈̏ォ15CNA
								memset(pSrc + i * 512 + ov, 0, 4 * 256); //256hbgԂ0ŃNA
						}
					}
				}
			}
			if (srcY + srcH >= 240)
			{
				if ((MAINBOARD_GetShowOverscanBottom() > 0) || (MAINBOARD_GetShowOverscanTop() > 0)) //㑤I[o[XL̈\̐ݒ̏ꍇAX^[g1Ĉ߂ɉNAB
				{
					if (VDC_GetTvWidth() == 350)
					{//𑜓x350[h̏ꍇiZSLIMIĂꍇj
						//ォ3CځA271hbgڂ5hbgŁAX^[g̖\Ă邩ǂ`FbN
						if (memcmp(_SBTatsujin, pSrc + (16 + 3) * 512 + ov + 271, 4 * 5) == 0) //\ĂiX^[gorăX^[gj
						{
							for (i = 239; i < 248; i++) //I[o[XL̈̉9CNA
								memset(pSrc + i * 512 + ov, 0, 4 * 350); //350hbgԂ0ŃNA
						}
					}
					else
					{//ʏ(VDC_GetTvWidth()==260B256[h)
						//ォ3CځA224hbgڂ5hbgŁAX^[g̖\Ă邩ǂ`FbN
						if (memcmp(_SBTatsujin, pSrc + (16 + 3) * 512 + ov + 224, 4 * 5) == 0) //\ĂiX^[gorăX^[gj
						{
							for (i = 239; i < 248; i++) //I[o[XL̈̉9CNA
								memset(pSrc + i * 512 + ov, 0, 4 * 256); //256hbgԂ0ŃNA
						}
					}
				}
			}
			//Uint32* pT = pSrc + (16 + 3) * 512 + ov + 224; PRINTF("Color = %08X %08X %08X %08X %08X %08X", *pT, *(pT + 1), *(pT + 2), *(pT + 3), *(pT + 4), *(pT + 5)); //Testp
			//Uint32* pT = pSrc + (16 + 3) * 512 + ov + 271; PRINTF("Color = %08X %08X %08X %08X %08X %08X", *pT, *(pT + 1), *(pT + 2), *(pT + 3), *(pT + 4), *(pT + 5)); //Testp
		}
	}

	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			SCREEND3D_Blt(pSrc, srcX, srcY, pSrcW, srcH, executeCode);
			break;
		case 2: //DirectDraw
			SCREENDD_Blt(pSrc, srcX, srcY, pSrcW, srcH, executeCode);
			break;
	}
}


//KitaoǉBVSync(A҂)sǂݒB݂̃fBXvC\VSyncs邩ǂ̃`FbNsB
void
SCREEN_SetVSyncScreen(
	BOOL	bVSyncScreen)
{
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			SCREEND3D_SetVSyncScreen(bVSyncScreen); //_bVSync120Hzݒ肳Bv2.79ǉ
			break;
		case 2: //DirectDraw
			SCREENDD_SetVSyncScreen(bVSyncScreen); //_bVSync120Hzݒ肳Bv2.79ǉ
			break;
	}
}

//KitaoǉBVSync(A҂)sĂ邩ǂ𓾂ĩ݂fBXvC\VSyncs邩ǂ̃`FbN𔽉fljB
BOOL
SCREEN_GetVSyncScreen()
{
	BOOL	bVSyncScreen;

	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			bVSyncScreen = SCREEND3D_GetVSyncScreen();
			break;
		case 2: //DirectDraw
			bVSyncScreen = SCREENDD_GetVSyncScreen();
			break;
	}

	return bVSyncScreen;
}


//KitaoǉBeLXgbZ[Wݒ
void
SCREEN_SetMessageText(
	char*	pText)
{
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			SCREEND3D_SetMessageText(pText);
			break;
		case 2: //DirectDraw
			SCREENDD_SetMessageText(pText);
			break;
	}
}


//KitaoǉBK}i邳jvZς݂̃e[upӁBv2.28XVBDirect3DDirectDrawŋpɂB
void
SCREEN_SetGamma(
	Sint32	scanlineType,
	Sint32	scanlineDensity) //XLC̔Zx(%)
{
	Sint32	magnification;
	int 	a,i;
	double	d = APP_GetGammaValue(); //cXLC̊{K}l
	Sint32	b = APP_GetBrightValue(); //uCglX
	Uint32	t;
	Uint32	gamma[8];
	Uint32	gammaS80[8];
	Uint32	gammaS90[8];
	Uint32	m,n;
	Uint32	monoR[256], monoRs80[256], monoRs90[256];
	Uint32	monoG[256], monoGs80[256], monoGs90[256];;
	Uint32	monoB[256], monoBs80[256], monoBs90[256];;

	//{ݒł͂ȂAݎۂɕ\ĂMagnification擾Bv2.28
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			magnification = SCREEND3D_GetMagnification();
			break;
		case 2: //DirectDraw
			magnification = SCREENDD_GetMagnification();
			break;
		default:
			magnification = 2;
			break;
	}

	//XLC̏ꍇAXLCňÂȂԂAK}𖾂߂ɂBmXLC̏ꍇAK}Â߂ɂB
	if (magnification >= 2)
	{
		switch (scanlineType)
		{
			case 1: //cXLCiftHgj
				break;
			case  2: //XLC
			case  3: //XLCt@[Xg
			case  4: //TVXLC
			case  5: //XLCV[v
			case  6: //XLCAV[v
			case 11: //TVXLCڂ₯
				d = (1-15/800)*d; // (1-15/800)*1.305 cƔׂĖ邢Ԃ
				if (APP_GetOptimizeGamma())
					d = d * (1+(80-(double)scanlineDensity)*0.005); // _E邳グBv2.35XV
				break;
			default: //mXLC(0,7,8,9,10)
				d = (1-95/800)*d; // (1-95/800)*1.305 cƔׂĖ邢Ԃ
				break;
		}
	}
	else //mXLCx1̏ꍇ
		d = (1-95/800)*d; // (1-95/800)*1.305 cƔׂĖ邢Ԃ

	if (((scanlineType >= 2)&&(scanlineType <= 6))||(scanlineType == 11)) //XLC̏ꍇBv2.92XV
	{
		for (i=0; i<=7 ; i++)
		{
			if (i == 0)
				a = 0; //͐^
			else
				a = (i << 5) + b; //+1B͈͂ŏ߂ɂقڂɂȂB
			gamma[i] = (Uint32)((pow((double)a / 256.0, 1.0/d) * 256.0) +0.5);
			gammaS80[i] = (Uint32)((pow((double)a*((double)scanlineDensity / 100) / 256.0, 1.0/d) * 256.0) +0.5); //XLC{p
			gammaS90[i] = (Uint32)((pow((double)a*((double)(scanlineDensity+(100-scanlineDensity)/2) / 100) / 256.0, 1.0/d) * 256.0) +0.5); //XLCƃhbg̋Ep
		}
	}
	else //XLCȊȌꍇBXLC80%ƂBv2.35XV
	{
		for (i=0; i<=7 ; i++)
		{
			a = i*32 + (Sint32)((double)b * ((double)i/7) + 0.5); //͐^ɁB͔͈͂ŏ߂ɂقڂɂȂBv2.35XV
			gamma[i] = (Uint32)((pow((double)a / 256.0, 1.0/d) * 256.0) +0.5);
			gammaS80[i] = (Uint32)((pow((double)a*0.80 / 256.0, 1.0/d) * 256.0) +0.5); //XLC80%piXLC{j
			gammaS90[i] = (Uint32)((pow((double)a*0.90 / 256.0, 1.0/d) * 256.0) +0.5); //XLC90%piXLCƃhbg̋Epj
		}
	}

	//mNϊpe[u쐬Bv2.28ǉBv2.99XV
	for (i = 0; i<= 0xFF; i++)
	{
		//R,G,B̋Px𕽋ωămN
		monoR[i] = (Uint32)((pow(((double)i * 0.298912) / 256.0, 1.0 / 1.0752080) * 256.0)); //ʂ̈Â}邽߃K}グB
		monoG[i] = (Uint32)((pow(((double)i * 0.586611) / 256.0, 1.0 / 1.0752080) * 256.0)); //RGBƂɒlI[o[Ȃ߂ɏ_ȉ͐؂̂āB
		monoB[i] = (Uint32)((pow(((double)i * 0.114478) / 256.0, 1.0 / 1.0752080) * 256.0)); //
		monoRs80[i] = (Uint32)((pow(((double)i * 0.298912) * 0.80 / 256.0, 1.0 / 1.0752080) * 256.0)); //XLC80%piXLC{j
		monoGs80[i] = (Uint32)((pow(((double)i * 0.586611) * 0.80 / 256.0, 1.0 / 1.0752080) * 256.0));
		monoBs80[i] = (Uint32)((pow(((double)i * 0.114478) * 0.80 / 256.0, 1.0 / 1.0752080) * 256.0));
		monoRs90[i] = (Uint32)((pow(((double)i * 0.298912) * 0.90 / 256.0, 1.0 / 1.0752080) * 256.0)); //XLC90%piXLCƃhbg̋Epj
		monoGs90[i] = (Uint32)((pow(((double)i * 0.586611) * 0.90 / 256.0, 1.0 / 1.0752080) * 256.0));
		monoBs90[i] = (Uint32)((pow(((double)i * 0.114478) * 0.90 / 256.0, 1.0 / 1.0752080) * 256.0));
	}

	//9bitRGBl̐Fe[učBv2.99
	for (t = 0; t <= 0xFFFFFF; t++)
	{
		_GammaTBL[t] = (gamma[(t >> 16) & 7] << 16) | (gamma[(t >> 8) & 7] << 8) | gamma[t & 7]; //RGB->BGR
		_GammaTBLs80[t] = (gammaS80[(t >> 16) & 7] << 16) | (gammaS80[(t >> 8) & 7] << 8) | gammaS80[t & 7];
		_GammaTBLs90[t] = (gammaS90[(t >> 16) & 7] << 16) | (gammaS90[(t >> 8) & 7] << 8) | gammaS90[t & 7];
		m = monoR[gamma[(t >> 16) & 7]] + monoG[gamma[(t >> 8) & 7]] + monoB[gamma[t & 7]]; //R,G,B̋Px𕽋ω
		if (MAINBOARD_GetForceMonoColor() == 2) //O[fBXvC[h̏ꍇB Xe[g[h(orW[)ňꎞIɔ[hɂ邱ƂɑΉ̂ŁAAPP_GetMonoColorMode()ł͂ȂMAINBOARD_GetForceMonoColor()gB
		{
			n = m + (m >> 3) + (m >> 4);
			if (n > 0xFF) n = 0xFF;
			m = m >> 2;
		}
		else
			n = m;
		_MonoTBL[t] = (m << 16) | (n << 8) | m;
		m = monoRs80[gamma[(t >> 16) & 7]] + monoGs80[gamma[(t >> 8) & 7]] + monoBs80[gamma[t & 7]]; //R,G,B̋Px𕽋ω
		if (MAINBOARD_GetForceMonoColor() == 2) //O[fBXvC[h̏ꍇB Xe[g[h(orW[)ňꎞIɔ[hɂ邱ƂɑΉ̂ŁAAPP_GetMonoColorMode()ł͂ȂMAINBOARD_GetForceMonoColor()gB
		{
			n = m + (m >> 3) + (m >> 4);
			if (n > 0xFF) n = 0xFF;
			m = m >> 2;
		}
		else
			n = m;
		_MonoTBLs80[t] = (m << 16) | (n << 8) | m;
		m = monoRs90[gamma[(t >> 16) & 7]] + monoGs90[gamma[(t >> 8) & 7]] + monoBs90[gamma[t & 7]]; //R,G,B̋Px𕽋ω
		if (MAINBOARD_GetForceMonoColor() == 2) //O[fBXvC[h̏ꍇB Xe[g[h(orW[)ňꎞIɔ[hɂ邱ƂɑΉ̂ŁAAPP_GetMonoColorMode()ł͂ȂMAINBOARD_GetForceMonoColor()gB
		{
			n = m + (m >> 3) + (m >> 4);
			if (n > 0xFF) n = 0xFF;
			m = m >> 2;
		}
		else
			n = m;
		_MonoTBLs90[t] = (m << 16) | (n << 8) | m;
	}
}


//KitaoǉBOVBlank҂IԂB
Sint64
SCREEN_GetLastTimeSyncTime()
{
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			return SCREEND3D_GetLastTimeSyncTime();
		case 2: //DirectDraw
			return SCREENDD_GetLastTimeSyncTime();
		default:
			return 0;
	}
}


//KitaoǉBXN[VbgBitmapށBv2.12
void
SCREEN_WriteScreenshot(
	FILE*	fp)
{
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			SCREEND3D_WriteScreenshot(fp);
			break;
		case 2: //DirectDraw
			SCREENDD_WriteScreenshot(fp);
			break;
	}
}


//KitaoǉB`{ݒ肷Bv2.36
void
SCREEN_SetMagnification(
	Sint32	magnification)
{
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			SCREEND3D_SetMagnification(magnification);
			break;
		case 2: //DirectDraw
			SCREENDD_SetMagnification(magnification);
			break;
	}
}


//KitaoǉBۂɁu`揈ŎgpĂv`{𓾂Bv2.36
Sint32
SCREEN_GetMagnification()
{
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			return SCREEND3D_GetMagnification();
		case 2: //DirectDraw
			return SCREENDD_GetMagnification();
	}
	return 0;
}


//KitaoǉB`掞̃hbgg嗦ݒ肷B
void
SCREEN_SetPixelMagnification(
	Sint32*		wMag,
	Sint32*		hMag)
{
	Sint32		magnification;
	Sint32		scanlineType;

	//{ݒł͂ȂAݎۂɕ\ĂMagnification擾Bv2.28
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			magnification = SCREEND3D_GetMagnification();
			break;
		case 2: //DirectDraw
			magnification = SCREENDD_GetMagnification();
			break;
		default:
			magnification = 2;
			break;
	}

	if (magnification >= 2) //x2ȏ̏ꍇ
	{
		scanlineType = APP_GetScanlineType();
		if ((scanlineType >= 1)&&(scanlineType <= 6)) //XLC(c܂)
		{
			if ((scanlineType == 3)||(scanlineType == 4))
				*wMag = 1;
			else
				*wMag = 2; //x2ȏ͂Q{hbgŒBixAbv{g傳ꂽƂɃoCjAtB^ɂj
			*hMag = magnification; //c͔{Ԃ̃\[Xpӂē]B
		}
		else //mXLC
		{
			*wMag = 2;
			if (magnification == 2)
				*hMag = magnification; //c͔{Ԃ̃\[Xpӂē]B
			else
				*hMag = magnification-1; //3x,4x̂Ƃ́Aꂼ2x,3xɊgBiWM[yxAbvj
		}
	}
	else //x1̏ꍇ
		*wMag = *hMag = 1;
}


//KitaoǉBQ[ʐ^񒆂ɃbZ[W\Bv2.77
void
SCREEN_SetCenterText(
	char*	pText)
{
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			SCREEND3D_SetCenterText(pText);
			break;
		case 2: //DirectDraw
			SCREENDD_SetCenterText(pText);
			break;
	}
}


//KitaoǉBfBXvC̐g𑪒肵ĕԂBv2.43
Sint32
SCREEN_GetVerticalScanFrequency()
{
	Sint32	vsf = 0;
	Sint32	a;
	Sint64	t, t2;
	MSG		msg;

	MAINBOARD_ScreenClear();
	SCREEN_SetCenterText(" Checking Now... Please wait for 30 seconds. ");
	MAINBOARD_ScreenUpdateClear(); //Q[ʂ̓NABbZ[Ŵݕ\BQ[JnOłg֐B
	//return 0; //Testp

	Sleep(1000);//̏h߁AWindows̃EBhE̍XVȂǂI܂łPb҂Bv2.94

	SCREEN_WaitVBlank(FALSE); //"OVBlankI"XV邽߂ɕKvB
	t = APP_QPCtimeGetTime();
	t2 = t + 30000;
	while (t2 < t) //I\莞̃^C}[JE^I[o[t[ĂꍇAJn\莞̃^C}[JE^0ɖ߂܂ő҂B
	{
		SCREEN_WaitVBlank(FALSE); //"OVBlankI"XV邽߂ɕKvB
		t = APP_QPCtimeGetTime();
		t2 = t + 30000;
	}
	
	while (APP_QPCtimeGetTime() <= t2)
	{
		vsf++;
		SetCursor(LoadCursor(NULL, IDC_WAIT)); //J[\vɁB

		//ۂ̕`揈V~[VBv2.79
		MAINBOARD_AdvanceFrameSim();

		if (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	vsf = (vsf * 20) / 6; //v3.0530bɂ20{(600b)ČvZ

	//̈ʂ05Ɋۂ߂BY̍ہAxɂ͖ڗɂƖڗ̂ŁAۂ߂ۂ͒xق(g)Ɋۂ߂Bv2.94
	a = vsf % 10; //̈ʂޔ
	vsf /= 10; //̈ʂJbg
	if (a <= 4) //0`4̏ꍇ؂̂
		vsf *= 10;
	else //5`9̏ꍇ5Ɋۂ߂
		vsf = vsf * 10 + 5;

	SetCursor(LoadCursor(NULL, IDC_ARROW)); //J[\ɖ߂
	SCREEN_SetCenterText("");
	MAINBOARD_ScreenUpdateClear();

	return vsf;
}
