/******************************************************************************
	[PSG.c]
		orf܂B

	Implements the PSG.

	Copyright (C) 2004 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
******************************************************************************/
#include <stdio.h>
#include <malloc.h>
#include <math.h>
#include "PSG.h"
#include "ApuQueue.h"

#include "CPU.h"


/*-----------------------------------------------------------------------------
	[DEV NOTE]

	MAL			--- 0 - 15 (15  -0[dB], P邲Ƃ -3.0 [dB])
	AL			--- 0 - 31 (31  -0[dB], P邲Ƃ -1.5 [dB])
	LAL/RAL		--- 0 - 15 (15  -0[dB], P邲Ƃ -3.0 [dB])

	̂悤ɉ߂ȂB

	MAL*2		--- 0 - 30 (30  -0[dB], P邲Ƃ -1.5 [dB])
	AL			--- 0 - 31 (31  -0[dB], P邲Ƃ -1.5 [dB])
	LAL/RAL*2	--- 0 - 30 (30  -0[dB], P邲Ƃ -1.5 [dB])


	dB = 20 * log10(OUT/IN)

	dB / 20 = log10(OUT/IN)

	OUT/IN = 10^(dB/20)

	IN(őo)  1.0 ƂƁA

	OUT = 10^(dB/20)

					-91 <= -(MAL*2 + AL + LAL(RAL)*2) <= 0

	Ał́A

		-91 * 1.5 [dB] = -136.5 [dB] = 10^(-136.5/20) ~= 1.496236e-7 [{]

	ƂȂB

	  1e-7 I[_[̒ĺAŒ菬_ŕ\悤ƂƁA
	24 rbgȏKvŁAȂPUrbg̉߂ɂ +16rbg
	 24+16 = 40rbgȏKvɂȂBāA32 rbg̏n
	obd̉Œ菬_ŕ\̂͂炢BŁAg`̌vZ
	float ōsȂƂɂB

	  float o͌`ɕϊ̂͂`ot̎dƂB

	[2004.4.28] ς Sint32 Ŏ邱Ƃɂ(Ȓl͖)B

	  botƂorf͓hbɃpbP[WĂ̂A
	ۂɂ͂orf͂bot̂P^Q̃NbNœ삷ƍlėǂ悤B
	āAorf̓g Fpsg ́A

		Fpsg = 21.47727 [MHz] / 3 / 2 = 3.579545 [MHz]

	ƂȂB

	Ƃ΂RQTvPƂg`ĐƂA
	̎g̎ŃTvPEoƁA

		M = 3579545 / 32 = 111860.78125 [Hz]

	Ƃ}WbNio[it@~RƓjB
	AĐgŒł͋Ȃ̉tłȂ̂ŁA
	FRQ Ȃgp[^pčĐgωB
	FRQ ͂orf̃WX^ɏ܂PQrbg̃p[^ŁA
	œꂽ}WbNio[́u鐔vɂȂĂB

	̂RQTvPƂg`ĐƂA
	̔g`̎g F ́AFRQ pāA
	
		F = M / FRQ [Hz]  (FRQ != 0)
	
	ƂȂB

	  ob̍ĐTvOg Fpc [Hz] ƂƁA
	PRQTv̔g`̍Đg F2   F2 = Fpc / 32 [Hz]B
	āAob̂PTvɑ΂āAobd̂PTvEo
	JE^̐iݕ I 

		I = F / F2 = 32 * F / Fpc = Fpsg / FRQ / Fpc [PʂȂ]

	ƂȂB

	[NOISE CHANNEL]

	  [mCY̐ɂ͂ln(maximum length sequence)pB
	lñrbg͖ɂsB
	ł͉ɂPTrbgƂĎsȂB
	o͂͂PrbgŁAD0 [̂Ƃ͕̒lAP̂Ƃ͐̒lƂB

	ob̂PTvɑ΂āAobd̂PTvEo
	JE^̐iݕ I ́A

		I = Fpsg / 64 / FRQ / Fpc  (FRQ != 0)

	ƂȂB

	[ĐNIeBɂ] 2004.6.22

	  G~[^ł́Aorf̃WX^Ƀf[^܂܂ŁA
	ɔׂ킩ȂBWX^Ƀf[^܂ꂽƂɁA
	TEhobt@XV̂ǁAɂ݂̎ł́A
	TEhobt@̍XV͕ʃXbhōsȂĂāA
	G~[VXbhCӂ̎ԂɍXV邱ƂłȂB

	  ܂ł̍Đł́ATEhobt@̍XṼWX^ݒ݂̂
	LAꂾƗႦ΃TEhobt@XV̍ԂɈu
	o͂ꂽȂǂĂ܂B͓ɂcc`[hmCY
	Yp[gƂĎgpŖɂȂB

	  WX^ɏ܂ꂽlƉo͂ɔfɂ́A
	ߋɏ܂ꂽWX^̒l(Aǂ̃WX^ɁA܂ꂽ)
	ۑĂāATEhobt@XVɂQƂ@
	lBǂ̂炢ߋ܂ŃWX^̒lۑẮA
	TEhobt@̒ɂƎv邪AƂ肠͎s
	߂邱ƂɂB

	  orfWX^ւ̏ݓ̓G~[VXbh
	sȂATEhobt@XV͂̐pXbhōsȂB
	ꂾƁAG~[VXbhWX^̃L[ɏ݂
	sȂĂŒɁATEhobt@XVXbhL[
	ǂݏosȂĂ܂AANZXՓ˂B̖ɂ́A

		PDTEhobt@̍XVʃXbhōsȂȂ
		QDL[̃ANZXrɂ

	̂QƂ肪lBƂ肠Q̕@Ƃ邱ƂɂB
---------------------------------------------------------------------------*/

#define N_CHANNEL			6

#define OVERSAMPLE_RATE		8


typedef struct
{
	Uint32		frq;
	BOOL		bOn;
	BOOL		bDDA;
	Uint32		volume;
	Uint32		volumeL;
	Uint32		volumeR;
	Sint32		outVolumeL;
	Sint32		outVolumeR;
	Sint32		wave[32];
	Uint32		waveIndex;
	Sint32		ddaSample;
	Uint32		phase;
	Uint32		deltaPhase;
	BOOL		bNoiseOn;
	Uint32		noiseFrq;
	Uint32		deltaNoisePhase;
} PSG;


static PSG			_Psg[8];				// 6, 7 is unused
static Uint32		_Channel;				// 0 - 5;
static Uint32		_MainVolumeL;			// 0 - 15
static Uint32		_MainVolumeR;			// 0 - 15
static Uint32		_LfoFrq;
static BOOL			_bLfoOn;
static Uint32		_LfoCtrl;
static Uint32		_LfoShift;

static Uint8		_Port[15];				// for debug purpose 

static Uint32		_LastCpuClock;

static Sint32		_VolumeTable[92];

static Sint32		_SampleRate;
static double		_CpuClockPerSample;


static BOOL			_bPsgInit;

static BOOL			_bFirstWrite = TRUE;


static
Sint32
_NoiseTable[32768];


static
void
create_volume_table()
{
	int			i;

	for (i = 0; i <= 91; i++)
	{
		double v = (double)(91 - i);
		_VolumeTable[i] = (Sint32)(32768.0 * pow(10.0, v * (-1.5) / 20.0));
	}
}


static
void
create_noise_table()
{
	Sint32	i;
	Uint32	bit0;
	Uint32	bit1;
	Uint32	bit14;
	Uint32	reg = 0x100;	// eLgE 

	for (i = 0; i < 32768; i++)
	{
		bit0 = reg & 1;
		bit1 = (reg & 2) >> 1;
		bit14 = (bit0 ^ bit1);
		reg >>= 1;
		reg |= (bit14 << 14);
		_NoiseTable[i] = (bit0) ? 15 : -16;
	}
}


static
void
update_frequency(PSG* p)
{
	Uint32 frq = (p->frq - 1) & 0xfff;

	if (frq)
		p->deltaPhase = (Uint32)(65536.0 * 256.0 * 8.0 * PSG_FRQ / (double)frq / _SampleRate / OVERSAMPLE_RATE);
	else
		p->deltaPhase = 0;
}


/*-----------------------------------------------------------------------------
	[write_reg]
		orf|[g݂̏ɑ΂铮Lq܂B
-----------------------------------------------------------------------------*/
static
void
write_reg(
	Uint8		reg,
	Uint8		data)
{
	Uint32		i;

	_Port[reg & 15] = data;

	switch (reg & 15)
	{
		case 0:	// register select
			_Channel = data & 7;
			break;

		case 1:	// main volume
			_MainVolumeL = data >> 4;
			_MainVolumeR = data & 0x0f;

			/* LMAL, RMAL ͑S`l̉ʂɉe */
			for (i = 0; i < N_CHANNEL; ++i)
			{
				_Psg[i].outVolumeL = _VolumeTable[_Psg[i].volume + (_MainVolumeL + _Psg[i].volumeL) * 2];
				_Psg[i].outVolumeR = _VolumeTable[_Psg[i].volume + (_MainVolumeR + _Psg[i].volumeR) * 2];
			}
			break;

		case 2:	// frequency low
			_Psg[_Channel].frq &= ~0xff;
			_Psg[_Channel].frq |= data;
			update_frequency(&_Psg[_Channel]);
			break;

		case 3:	// frequency high
			_Psg[_Channel].frq &= ~0xf00;
			_Psg[_Channel].frq |= (data & 0xf) << 8;
			update_frequency(&_Psg[_Channel]);
			break;

		case 4:	// ON, DDA, AL
			_Psg[_Channel].bOn  = (data & 0x80) != 0;

			if (_Psg[_Channel].bDDA && !(data & 0x40))
				_Psg[_Channel].waveIndex = 0;
			_Psg[_Channel].bDDA = (data & 0x40) != 0;

			_Psg[_Channel].volume = data & 0x1f;
			_Psg[_Channel].outVolumeL = _VolumeTable[_Psg[_Channel].volume + (_MainVolumeL + _Psg[_Channel].volumeL) * 2];
			_Psg[_Channel].outVolumeR = _VolumeTable[_Psg[_Channel].volume + (_MainVolumeR + _Psg[_Channel].volumeR) * 2];
			break;

		case 5:	// LAL, RAL
			_Psg[_Channel].volumeL = data >> 4;
			_Psg[_Channel].volumeR = data & 0xf;
			_Psg[_Channel].outVolumeL = _VolumeTable[_Psg[_Channel].volume + (_MainVolumeL + _Psg[_Channel].volumeL) * 2];
			_Psg[_Channel].outVolumeR = _VolumeTable[_Psg[_Channel].volume + (_MainVolumeR + _Psg[_Channel].volumeR) * 2];
			break;

		case 6:	// wave data
			if (_Psg[_Channel].bDDA)
			{
				//_Psg[_Channel].wave[0] = (Sint32)(data & 0x1f) - 16;
				_Psg[_Channel].ddaSample = (Sint32)(data & 0x1f) - 16;
			}
			else
			{
				_Psg[_Channel].wave[_Psg[_Channel].waveIndex++] = (Sint32)(data & 0x1f) - 16;
				_Psg[_Channel].waveIndex &= 0x1f;
			}
			break;

		case 7:	// noise on, noise frq
			if (_Channel >= 4)
			{
				_Psg[_Channel].bNoiseOn = (data & 0x80) != 0;
				_Psg[_Channel].noiseFrq = 0x1f - (data & 0x1f);
				if (_Psg[_Channel].noiseFrq == 0) _Psg[_Channel].noiseFrq = 1;
				_Psg[_Channel].deltaNoisePhase = (Uint32)(131072.0 * PSG_FRQ / 64.0 / (double)_Psg[_Channel].noiseFrq / _SampleRate / OVERSAMPLE_RATE);
			}
			break;

		case 8:	// LFO frequency
			_LfoFrq = data;
			break;

		case 9:	// LFO on, LFO control
			if (_bLfoOn != ((data & 0x80) != 0))
			{
				_Psg[1].phase = 0;
			}

			_bLfoOn = (data & 0x80) != 0;
			_LfoCtrl = data & 3;

			if (_LfoCtrl <= 1)
				_LfoShift = 0;
			else
				_LfoShift = 1 << _LfoCtrl;

			if (_bLfoOn)
			{
				if (_Psg[1].frq && _LfoFrq)
					_Psg[1].deltaPhase = (Uint32)(65536.0 * 256.0 * 8.0 * PSG_FRQ / (double)(_Psg[1].frq) / (double)_LfoFrq / _SampleRate);
				else
				{
					_Psg[1].deltaPhase = 0;
					_bLfoOn = FALSE;
				}
			}
			else
			{
				if (_Psg[1].frq)
					_Psg[1].deltaPhase = (Uint32)(65536.0 * 256.0 * 8.0 * PSG_FRQ / (double)(_Psg[1].frq) / _SampleRate / OVERSAMPLE_RATE);
				else
					_Psg[1].deltaPhase = 0;
			}
			break;

		default:	// invalid write
			break;
	}

	return;
}


/*-----------------------------------------------------------------------------
	L[QƂorfWX^XV܂B
	܂L[̑҂Ԃ݂čĐx܂B
-----------------------------------------------------------------------------*/
static
void
update_psg_registers()
{
	Sint32		clockAdvanced;
	double		clock;
	Uint8		reg;
	Uint8		data;

	APUQUEUE_Lock();

	clockAdvanced = APUQUEUE_GetTotalClockAdvanced();

	/* QUEUE ɓĂf[^̑NbN݂čĐ""𒲐B
		Pt[xōĐ悤ɂ */
	if (clockAdvanced > 3*CPU_CLOCKS_PER_SEC/60 + CPU_CLOCKS_PER_SEC/60)
	{
		clock = _CpuClockPerSample + 5.;
	}
	else if (clockAdvanced < CPU_CLOCKS_PER_SEC/60)
	{
		clock = _CpuClockPerSample - 5.;
	}
	else if (clockAdvanced > CPU_CLOCKS_PER_SEC/60 + CPU_CLOCKS_PER_SEC/60)
	{
		clock = _CpuClockPerSample + 1.;
	}
	else
	{
		clock = _CpuClockPerSample - 1.;
	}

	if (!APUQUEUE_AdvanceCounter(clock))
	{
		while (APUQUEUE_ForceRead(&reg, &data))	write_reg(reg, data);
		APUQUEUE_Reset();
		_LastCpuClock = CPU_GetClockCount();
	}
	else
	{
		while (APUQUEUE_Get(&reg, &data))
		{
			write_reg(reg, data);
		}
	}

	APUQUEUE_Unlock();
}



/*-----------------------------------------------------------------------------
	[Mix]
		orf̏o͂~bNX܂B
-----------------------------------------------------------------------------*/
void
PSG_Mix(
	Sint32*			pDst,				// o͐obt@ 
	Sint32			nSample)			// oTv 
{
	Sint32		i;
	Sint32		j;
	Uint32		phase;					// must be 32-bit
	Uint32		dp;						// delta phase
	Sint32		volumeL;
	Sint32		volumeR;
	Sint32		sampleL;
	Sint32		sampleR;
	Sint32*		p;
	Sint32*		wave;
	Sint32		lfo;

	if (!_bPsgInit)
		return;

	p = pDst;

	for (j = 0; j < nSample; j++)
	{
		for (i = 0; i < N_CHANNEL; i++)
		{
			if (!_Psg[i].bOn)
				continue;

			if (i == 1 && _bLfoOn)
				continue;

			volumeL = _Psg[i].outVolumeL;
			volumeR = _Psg[i].outVolumeR;

			if (_Psg[i].bDDA)
			{
				*p     += _Psg[i].ddaSample * volumeL;
				*(p+1) += _Psg[i].ddaSample * volumeR;
			}
			else if (_Psg[i].bNoiseOn)
			{
				dp = _Psg[i].deltaNoisePhase;

				phase = _Psg[i].phase;

				sampleL  = _NoiseTable[phase>>17];	phase += dp;
				sampleL += _NoiseTable[phase>>17];	phase += dp;
				sampleL += _NoiseTable[phase>>17];	phase += dp;
				sampleL += _NoiseTable[phase>>17];	phase += dp;
				sampleL += _NoiseTable[phase>>17];	phase += dp;
				sampleL += _NoiseTable[phase>>17];	phase += dp;
				sampleL += _NoiseTable[phase>>17];	phase += dp;
				sampleL += _NoiseTable[phase>>17];	phase += dp;

				sampleL /= OVERSAMPLE_RATE;
				sampleR = sampleL;

				*p     += sampleL * volumeL;
				*(p+1) += sampleR * volumeR;

				_Psg[i].phase = phase;
			}
			else if (i == 0 && _bLfoOn && _LfoCtrl > 0)
			{
				lfo = _Psg[1].wave[_Psg[1].phase>>27] << _LfoShift; _Psg[1].phase += _Psg[1].deltaPhase;
				dp = (Uint32)(65536.0 * 256.0 * 8.0 * PSG_FRQ / (double)(_Psg[_Channel].frq+lfo) / _SampleRate / OVERSAMPLE_RATE);
				phase = _Psg[0].phase;
				wave = &_Psg[0].wave[0];

				sampleL  = wave[phase>>27];	phase += dp;
				sampleL += wave[phase>>27];	phase += dp;
				sampleL += wave[phase>>27];	phase += dp;
				sampleL += wave[phase>>27];	phase += dp;
				sampleL += wave[phase>>27];	phase += dp;
				sampleL += wave[phase>>27];	phase += dp;
				sampleL += wave[phase>>27];	phase += dp;
				sampleL += wave[phase>>27];	phase += dp;

				sampleL /= OVERSAMPLE_RATE;
				sampleR = sampleL;

				*p     += sampleL * volumeL;
				*(p+1) += sampleR * volumeR;

				_Psg[0].phase = phase;
			}
			else if (_Psg[i].deltaPhase)
			{
				dp = _Psg[i].deltaPhase;
				phase = _Psg[i].phase;
				wave = &_Psg[i].wave[0];

				sampleL  = wave[phase>>27];	phase += dp;
				sampleL += wave[phase>>27];	phase += dp;
				sampleL += wave[phase>>27];	phase += dp;
				sampleL += wave[phase>>27];	phase += dp;
				sampleL += wave[phase>>27];	phase += dp;
				sampleL += wave[phase>>27];	phase += dp;
				sampleL += wave[phase>>27];	phase += dp;
				sampleL += wave[phase>>27];	phase += dp;

				sampleL /= OVERSAMPLE_RATE;
				sampleR = sampleL;

				*p     += sampleL * volumeL;
				*(p+1) += sampleR * volumeR;

				_Psg[i].phase = phase;
			}
		}
		p += 2;

		update_psg_registers();
	}
}


/*-----------------------------------------------------------------------------
	[Init]
		orf܂B
-----------------------------------------------------------------------------*/
Sint32
PSG_Init(
	Sint32		sampleRate)
{
	if (!APUQUEUE_Init())
		puts("APUQUEUE_Init() failed.");

	PSG_Reset();

	create_volume_table();
	create_noise_table();

	PSG_SetSampleRate(sampleRate);

	_bFirstWrite = TRUE;
	_bPsgInit = TRUE;

	return 0;
}


/*-----------------------------------------------------------------------------
	[SetSampleRate]
-----------------------------------------------------------------------------*/
void
PSG_SetSampleRate(
	Uint32			sampleRate)
{
	_SampleRate = sampleRate;
	_CpuClockPerSample = 7159090. / (double)sampleRate;
}


/*-----------------------------------------------------------------------------
	[Deinit]
		orfj܂B
-----------------------------------------------------------------------------*/
void
PSG_Deinit()
{
	memset(_Psg, 0, sizeof(_Psg[0])*8);
	_MainVolumeL = 0;
	_MainVolumeR = 0;
	_LfoFrq = 0;
	_bLfoOn = FALSE;
	_LfoCtrl = 0;
	_bPsgInit = FALSE;

	APUQUEUE_Deinit();
}


/*-----------------------------------------------------------------------------
	[Reset]
-----------------------------------------------------------------------------*/
void
PSG_Reset()
{
	memset(_Psg, 0, sizeof(_Psg[0])*8);
	_MainVolumeL = 0;
	_MainVolumeR = 0;
	_LfoFrq = 0;
	_bLfoOn = FALSE;
	_LfoCtrl = 0;
	_bFirstWrite = TRUE;

	_LastCpuClock = CPU_GetClockCount();

	APUQUEUE_Reset();
}


/*-----------------------------------------------------------------------------
	[Read]
		orf|[g̓ǂݏoɑ΂铮Lq܂B
-----------------------------------------------------------------------------*/
Uint8
PSG_Read(
	Uint32	regNum)
{
	if (regNum == 0)
	{
		return _Channel;
	}

	return _Port[regNum & 15];
}


/*-----------------------------------------------------------------------------
	[Write]
		orf|[g݂̏ɑ΂铮Lq܂B
-----------------------------------------------------------------------------*/
void
PSG_Write(
	Uint32		regNum,
	Uint8		data)
{
	Uint32		cpuClock = CPU_GetClockCount();

	if (!APUQUEUE_Add(cpuClock-_LastCpuClock, regNum&15, data))
	{
		Uint8	reg;
		APUQUEUE_Lock();
		while (APUQUEUE_ForceRead(&reg, &data))	write_reg(reg, data);
		APUQUEUE_Reset();
		APUQUEUE_Unlock();
		puts("PSG_Write: queue overflow.");
	}

	_LastCpuClock = cpuClock;
}


Sint32
PSG_AdvanceClock(
	Sint32		clock)
{
	return 0;
}


// save variable
#define SAVE_V(V)	if (fwrite(&V, sizeof(V), 1, p) != 1)	return FALSE
#define LOAD_V(V)	if (fread(&V, sizeof(V), 1, p) != 1)	return FALSE
// save array
#define SAVE_A(A)	if (fwrite(A, sizeof(A), 1, p) != 1)	return FALSE
#define LOAD_A(A)	if (fread(A, sizeof(A), 1, p) != 1)		return FALSE
/*-----------------------------------------------------------------------------
	[SaveState]
		Ԃt@Cɕۑ܂B 
-----------------------------------------------------------------------------*/
BOOL
PSG_SaveState(
	FILE*		p)
{
	if (p == NULL)
		return FALSE;

	SAVE_A(_Psg);

	SAVE_V(_Channel);
	SAVE_V(_MainVolumeL);
	SAVE_V(_MainVolumeR);
	SAVE_V(_LfoFrq);
	SAVE_V(_bLfoOn);
	SAVE_V(_LfoCtrl);

	SAVE_V(_LastCpuClock);
	SAVE_V(_bFirstWrite);

	return APUQUEUE_SaveState(p);
}


/*-----------------------------------------------------------------------------
	[LoadState]
		Ԃt@Cǂݍ݂܂B 
-----------------------------------------------------------------------------*/
BOOL
PSG_LoadState(
	FILE*		p)
{
	if (p == NULL)
		return FALSE;

	LOAD_A(_Psg);

	LOAD_V(_Channel);
	LOAD_V(_MainVolumeL);
	LOAD_V(_MainVolumeR);
	LOAD_V(_LfoFrq);
	LOAD_V(_bLfoOn);
	LOAD_V(_LfoCtrl);

	LOAD_V(_LastCpuClock);
	LOAD_V(_bFirstWrite);

	return APUQUEUE_LoadState(p);
}

#undef SAVE_V
#undef SAVE_A
#undef LOAD_V
#undef LOAD_A
