/******************************************************************************
	[Screen.c]

	Implement ScreenInterface.

	Copyright (C) 2004 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
******************************************************************************/
#include "ScreenInterface.h"
#include "GDIScreen.h"
#include "DDScreen.h"

static Sint32	_Width;
static Sint32	_Height;
static Sint32	_BitsPerPixel;
static Uint32	_Flags;


/*-----------------------------------------------------------------------------
	[Init]
		XN[܂B 
-----------------------------------------------------------------------------*/
BOOL
SCREEN_Init(
	Sint32		width,
	Sint32		height,
	Sint32		bitsPerPixel,
	Uint32		flags)
{
	_Width = width;
	_Height = height;
	_BitsPerPixel = bitsPerPixel;
	_Flags = flags;

	if (_Flags & SCREEN_FFULLSCREEN)
	{
		return DDSCREEN_Init(width, height, bitsPerPixel, flags);
	}

	return GDISCREEN_Init(width, height, bitsPerPixel, flags);
}


/*-----------------------------------------------------------------------------
	[GetWidth]
	  XN[̉Ԃ܂B
-----------------------------------------------------------------------------*/
Sint32
SCREEN_GetWidth()
{
	if (_Flags & SCREEN_FFULLSCREEN)
		return DDSCREEN_GetWidth();

	return GDISCREEN_GetWidth();
}


/*-----------------------------------------------------------------------------
	[GetHeight]
	  XN[̍Ԃ܂B
-----------------------------------------------------------------------------*/
Sint32
SCREEN_GetHeight()
{
	if (_Flags & SCREEN_FFULLSCREEN)
		return DDSCREEN_GetHeight();

	return GDISCREEN_GetHeight();
}


/*-----------------------------------------------------------------------------
	[GetRshift]
	  ꂽOtBbN[hŁCԐFɉrbgVtg邩
	Ԃ܂D(Ⴆ16bppł11C15bppł10)
**---------------------------------------------------------------------------*/
Sint32
SCREEN_GetRshift()
{
	if (_Flags & SCREEN_FFULLSCREEN)
		return DDSCREEN_GetRshift();

	return GDISCREEN_GetRshift();
}


/*-----------------------------------------------------------------------------
	[GetGshift]
	  ꂽOtBbN[hŁCΐFɉrbgVtg邩
	Ԃ܂D(Ⴆ16bppł5C15bppł5)
**---------------------------------------------------------------------------*/
Sint32
SCREEN_GetGshift()
{
	if (_Flags & SCREEN_FFULLSCREEN)
		return DDSCREEN_GetGshift();

	return GDISCREEN_GetGshift();
}


/*-----------------------------------------------------------------------------
	[GetBshift]
	  ꂽOtBbN[hŁCFɉrbgVtg邩
	Ԃ܂D(Ⴆ16bppł0C15bppł0)
**---------------------------------------------------------------------------*/
Sint32
SCREEN_GetBshift()
{
	if (_Flags & SCREEN_FFULLSCREEN)
		return DDSCREEN_GetBshift();

	return GDISCREEN_GetBshift();
}


/*-----------------------------------------------------------------------------
	[GetRmask]
	  ꂽOtBbN[hŁCԐF}XNrbgԂ܂D
	Ԃ܂D(Ⴆ16bppł0xf800, 15bppł 0x7c00)
**---------------------------------------------------------------------------*/
Uint32
SCREEN_GetRmask()
{
	if (_Flags & SCREEN_FFULLSCREEN)
		return DDSCREEN_GetRmask();

	return GDISCREEN_GetRmask();
}


/*-----------------------------------------------------------------------------
	[GetGmask]
	  ꂽOtBbN[hŁCΐF}XNrbgԂ܂D
	Ԃ܂D(Ⴆ16bppł0x07e0, 15bppł 0x03e0)
**---------------------------------------------------------------------------*/
Uint32
SCREEN_GetGmask()
{
	if (_Flags & SCREEN_FFULLSCREEN)
		return DDSCREEN_GetGmask();

	return GDISCREEN_GetGmask();
}


/*-----------------------------------------------------------------------------
	[GetBmask]
	  ꂽOtBbN[hŁCF}XNrbgԂ܂D
	Ԃ܂D(Ⴆ16bppł0x001f, 15bppł 0x001f)
**---------------------------------------------------------------------------*/
Uint32
SCREEN_GetBmask()
{
	if (_Flags & SCREEN_FFULLSCREEN)
		return DDSCREEN_GetBmask();

	return GDISCREEN_GetBmask();
}


/*-----------------------------------------------------------------------------
	[GetBytesPerPixel]
	  PsNZɎgpoCgԂ܂D
**---------------------------------------------------------------------------*/
Uint32
SCREEN_GetBytesPerPixel()
{
	if (_Flags & SCREEN_FFULLSCREEN)
		return DDSCREEN_GetBytesPerPixel();

	return GDISCREEN_GetBytesPerPixel();
}


/*-----------------------------------------------------------------------------
	[PutPixel]
	  PsNZ`܂D16bpp p
**---------------------------------------------------------------------------*/
void
SCREEN_PutPixel(
	Sint32		x,
	Sint32		y,
	Uint32		pixel)
{
	if (_Flags & SCREEN_FFULLSCREEN)
		DDSCREEN_PutPixel(x, y, pixel);
	else
		GDISCREEN_PutPixel(x, y, pixel);
}


/*-----------------------------------------------------------------------------
	[IsFullScreen]
		XN[tXN[Ȃ TRUE, EChEȂ FALSE Ԃ܂B
-----------------------------------------------------------------------------*/
BOOL
SCREEN_IsFullScreen()
{
	return (_Flags & SCREEN_FFULLSCREEN) != 0;
}


/*-----------------------------------------------------------------------------
	[ToggleFullScreen]
		XN[EChE^tXN[ɐ؂ւ܂D
-----------------------------------------------------------------------------*/
BOOL
SCREEN_ToggleFullScreen()
{
	if (_Flags & SCREEN_FFULLSCREEN)
	{
		DDSCREEN_Deinit();
		_Flags &= ~SCREEN_FFULLSCREEN;
		return GDISCREEN_Init(_Width, _Height, _BitsPerPixel, _Flags);
	}

	GDISCREEN_Deinit();
	_Flags |= SCREEN_FFULLSCREEN;
	return DDSCREEN_Init(_Width, _Height, _BitsPerPixel, _Flags);
}


/*-----------------------------------------------------------------------------
	[ChangeMode]
		XN[[hύX܂B 
-----------------------------------------------------------------------------*/
BOOL
SCREEN_ChangeMode(
	Sint32		width,
	Sint32		height,
	Sint32		bpp,
	Uint32		flags)
{
	if (_Flags & SCREEN_FFULLSCREEN)
		DDSCREEN_Deinit();
	else
		GDISCREEN_Deinit();

	_Width = width;
	_Height = height;
	_BitsPerPixel = bpp;
	_Flags = flags;

	if (_Flags & SCREEN_FFULLSCREEN)
		return DDSCREEN_Init(width, height, bpp, flags);

	return GDISCREEN_Init(width, height, bpp, flags);
}


/*-----------------------------------------------------------------------------
	[SetFPS]
		Frames Per Second ύX܂B 
-----------------------------------------------------------------------------*/
void
SCREEN_SetFPS(
	float		fps)
{
	if (_Flags & SCREEN_FFULLSCREEN)
		DDSCREEN_SetFPS(fps);
	else
		GDISCREEN_SetFPS(fps);
}


/*-----------------------------------------------------------------------------
	[WaitVBlank]
		AԂ҂܂B 
-----------------------------------------------------------------------------*/
BOOL
SCREEN_WaitVBlank(
	BOOL		bForceWait)
{
	if (_Flags & SCREEN_FFULLSCREEN)
		return DDSCREEN_WaitVBlank(bForceWait);

	return GDISCREEN_WaitVBlank(bForceWait);
}


/*-----------------------------------------------------------------------------
	[ShouldDraw]
		`sȂׂAsȂȂׂԂ܂B 
-----------------------------------------------------------------------------*/
BOOL
SCREEN_ShouldDraw()
{
	if (_Flags & SCREEN_FFULLSCREEN)
		return DDSCREEN_ShouldDraw();

	return GDISCREEN_ShouldDraw();
}


/*-----------------------------------------------------------------------------
	[Lock]
		XN[bNKv΃bN܂B
-----------------------------------------------------------------------------*/
BOOL
SCREEN_Lock()
{
	if (_Flags & SCREEN_FFULLSCREEN)
		return DDSCREEN_Lock();

	return GDISCREEN_Lock();
}


void*
SCREEN_GetBuffer()
{
	if (_Flags & SCREEN_FFULLSCREEN)
		return DDSCREEN_GetBuffer();

	return GDISCREEN_GetBuffer();
}


const
Sint32
SCREEN_GetBufferPitch()
{
	if (_Flags & SCREEN_FFULLSCREEN)
		return DDSCREEN_GetBufferPitch();

	return GDISCREEN_GetBufferPitch();
}


/*-----------------------------------------------------------------------------
	[Unlock]
		XN[̃bN܂B
-----------------------------------------------------------------------------*/
void
SCREEN_Unlock()
{
	if (_Flags & SCREEN_FFULLSCREEN)
		DDSCREEN_Unlock();
	else
		GDISCREEN_Unlock();
}


/*-----------------------------------------------------------------------------
	[DrawText]
		obNobt@ɕ݂܂B 
	ĂԑO SCREEN_Lock() ܂傤B
-----------------------------------------------------------------------------*/
void
SCREEN_DrawText(
	const Sint32	x,
	const Sint32	y,
	const Uint32	fgColor,
	const Uint32	bgColor,
	const BOOL		bOpaque,
	const char*		pText)
{
	if (_Flags & SCREEN_FFULLSCREEN)
		DDSCREEN_DrawText(x, y, fgColor, bgColor, bOpaque, pText);
	else
		GDISCREEN_DrawText(x, y, fgColor, bgColor, bOpaque, pText);
}


/*-----------------------------------------------------------------------------
	[FillRect]
		obNobt@Ɏw̐F̋``܂B
	ĂԑO SCREEN_Lock() ܂傤B
-----------------------------------------------------------------------------*/
void
SCREEN_FillRect(
	Sint32		x,
	Sint32		y,
	Sint32		width,
	Sint32		height,
	Uint32		color)
{
	if (_Flags & SCREEN_FFULLSCREEN)
		DDSCREEN_FillRect(x, y, width, height, color);
	else
		GDISCREEN_FillRect(x, y, width, height, color);
}


/*-----------------------------------------------------------------------------
	[Blt]
		pSrc obNobt@։摜݂܂Bg^kA
	At@uh󂯕t܂(8bpp ȊO)B 
	ĂԑO SCREEN_Lock() ܂傤B
-----------------------------------------------------------------------------*/
void
SCREEN_Blt(
	const void*		pSrc,
	Sint32			srcX,
	Sint32			srcY,
	Sint32			dstX,
	Sint32			dstY,
	Sint32			srcW,
	Sint32			srcH,
	Sint32			dstW,
	Sint32			dstH,
	Sint32			srcPitch,
	Uint32			alpha)
{
	if (_Flags & SCREEN_FFULLSCREEN)
		DDSCREEN_Blt(pSrc, srcX, srcY, dstX, dstY, srcW, srcH, dstW, dstH, srcPitch, alpha);
	else
		GDISCREEN_Blt(pSrc, srcX, srcY, dstX, dstY, srcW, srcH, dstW, dstH, srcPitch, alpha);
}


/*-----------------------------------------------------------------------------
	[Update]
		obNobt@̓eʂɕ\܂B
	x, y, width, height Să[ɂƁAʂ̑S͈͂XV܂B
-----------------------------------------------------------------------------*/
void
SCREEN_Update(
	Sint32		x,
	Sint32		y,
	Sint32		width,
	Sint32		height)
{
	if (_Flags & SCREEN_FFULLSCREEN)
		DDSCREEN_Update(x, y, width, height);
	else
		GDISCREEN_Update(x, y, width, height);
}


/*-----------------------------------------------------------------------------
	[Deinit]
		XN[̏IsȂ܂B
-----------------------------------------------------------------------------*/
void
SCREEN_Deinit()
{
	if (_Flags & SCREEN_FFULLSCREEN)
		DDSCREEN_Deinit();
	else
		GDISCREEN_Deinit();

	_Width = 0;
	_Height = 0;
	_BitsPerPixel = 0;
	_Flags = 0;
}


