/******************************************************************************
	[AudioOut.c]
		I[fBIC^tFCX DirectSound 𗘗pĎ܂B

		Implement audio interface using DirectSound.

	Copyright (C) 2004 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
******************************************************************************/
#include <stdio.h> // debug
#include <dsound.h>

#include "AudioInterface.h"
#include "WinMain.h"
#include "Printf.h"

#define		SAFE_RELEASE(p)		{ if (p) {(p)->lpVtbl->Release(p); (p) = NULL;} }


static		LPDIRECTSOUND		_pDS		= NULL;
static		LPDIRECTSOUNDBUFFER	_pDSB		= NULL;

static		DSBPOSITIONNOTIFY	_PosNotify[3];
static		HANDLE				_hEvent[3];

static		DWORD				_dwBufSize;
static		WAVEFORMATEX		_WaveFormat;
static		HANDLE				_hThread;
static		DWORD				_dwThreadID;

static		CRITICAL_SECTION	_CriticalSection;

static volatile BOOL			_bPlay;

static		Sint16*				_pAudioBuf = NULL;
static 		void				(*_pCallBack)(Sint16* pBuf, Sint32 nSamples) = NULL;

static		BOOL				_bAudioInit = FALSE;


/*-----------------------------------------------------------------------------
	[write_streaming_buffer]
		DirectSoundBuffer ɏo͂鉹f[^݂܂B
-----------------------------------------------------------------------------*/
static
BOOL
write_streaming_buffer(
	DWORD		dwOffset,
	LPBYTE		pData,
	DWORD		dwBufSize)
{
	LPVOID		lpvPtr1;
	DWORD		dwBytes1; 
	LPVOID		lpvPtr2;
	DWORD		dwBytes2;
	HRESULT		hr;

	if (!_bAudioInit)	return FALSE;

	/*
	** ݐ̃|C^𓾂B DSERR_BUFFERLOST Ԃꂽꍇ 
	** Restore ēx Lock ݂B 
	*/
	hr = _pDSB->lpVtbl->Lock(_pDSB, dwOffset, dwBufSize, &lpvPtr1, &dwBytes1, &lpvPtr2, &dwBytes2, 0);
	if (hr ==DSERR_BUFFERLOST)
	{
		_pDSB->lpVtbl->Restore(_pDSB);
		hr = _pDSB->lpVtbl->Lock(_pDSB, dwOffset, dwBufSize, &lpvPtr1, &dwBytes1, &lpvPtr2, &dwBytes2, 0);
	}

	if (hr == S_OK)
	{
		// Lock ɐ擾|C^ɏ݂sȂAUnlock B 
		CopyMemory(lpvPtr1, pData, dwBytes1);

		if (lpvPtr2 != NULL)
		{
			CopyMemory(lpvPtr2, pData+dwBytes1, dwBytes2);
		}

		hr = _pDSB->lpVtbl->Unlock(_pDSB, lpvPtr1, dwBytes1, lpvPtr2, dwBytes2);

		if (hr == S_OK)
			return TRUE;	// ݂ɐ 
	}

	return FALSE;	// Lock, Unlock, ܂ Restore Ɏs 
}


/*-----------------------------------------------------------------------------
	[playback_thread]
		TEhobt@̍XVsȂXbhłB 
-----------------------------------------------------------------------------*/
static
DWORD
WINAPI
playback_thread(
	LPVOID	param)
{
	DWORD	n;

	if (!_bAudioInit)
		return 0;

	while (TRUE)
	{
		// notification ҂ 
		n = WaitForMultipleObjects(3, _hEvent, FALSE, INFINITE);

		if (n == WAIT_OBJECT_0 + 2)
		{
			// I notification 󂯎XbhI 
			ExitThread(TRUE);
		}

		// ȉ̓obt@̐擪͒ԓ_ʒmCxgꍇ̏ 
		if (_bPlay)
			_pCallBack(_pAudioBuf, _dwBufSize/2/2);
		else
			ZeroMemory(_pAudioBuf, _dwBufSize);

		if (n == WAIT_OBJECT_0 + 0)
			write_streaming_buffer(_dwBufSize, (LPBYTE)_pAudioBuf, _dwBufSize);
		else
			write_streaming_buffer(0, (LPBYTE)_pAudioBuf, _dwBufSize);

		ResetEvent(_hEvent[n]);
	}

	return 0;
}


/*-----------------------------------------------------------------------------
	Deinit DirectSound

-----------------------------------------------------------------------------*/
static
BOOL
d_deinit()
{
	if (!_bAudioInit)
		return FALSE;

	_bPlay = FALSE;

	if (_pDSB != NULL)
	{
		_pDSB->lpVtbl->Stop(_pDSB);

		// Xbh̏I҂ 
		WaitForSingleObject(_hThread, INFINITE);
	}

	CloseHandle(_hThread);

	DeleteCriticalSection(&_CriticalSection);

	if (_hEvent[0])	CloseHandle(_hEvent[0]);
	if (_hEvent[1])	CloseHandle(_hEvent[1]);
	if (_hEvent[2])	CloseHandle(_hEvent[2]);

	_hEvent[0] = _hEvent[1] = _hEvent[2] = NULL;

	SAFE_RELEASE(_pDSB);
	SAFE_RELEASE(_pDS);

	GlobalFree(_pAudioBuf);
	_pAudioBuf = NULL;
	_dwBufSize = 0;

	CoUninitialize();

	return TRUE;
}


/*-----------------------------------------------------------------------------
	Initialize DirectSound

-----------------------------------------------------------------------------*/
static
BOOL
d_init(
	HWND	hWnd,
	WORD	nChannels,
	WORD	nSamplesPerSec,
	WORD	wBitsPerSample,
	DWORD	dwBufSize)			// in bytes
{
	DSBUFFERDESC			dsbd;
	LPDIRECTSOUNDNOTIFY		lpDSN;

	// Initialize COM
	if (CoInitialize(NULL))	return FALSE;

	// Create IDirectSound 
	if (FAILED(DirectSoundCreate(NULL, &_pDS, NULL)))	return FALSE;

	/*
	** Set coop level to DSSCL_PRIORITY
	**
	** vC}obt@̃tH[}bgݒł悤AvC}x
	** ݒ肷BftHg̃tH[}bgɕύXȂꍇA͂
	** tH[}bgɂȂAo͂ 8 rbgA22 kHz tH[}bgɂȂB
	** IDirectSoundBuffer::SetFormat ̌ĂяosĂ͂Ȃ_
	** ӂBDirectSound ͒PɁApł钆ōł߂tH[}bg
	** ݒ肷B
	*/
	if (FAILED(_pDS->lpVtbl->SetCooperativeLevel(_pDS, hWnd, DSSCL_PRIORITY)))
	{
		PRINTF("DIRECTSOUND::SetCooperativeLevel() failed.");
		return FALSE;
	}

	/*
	** Get the primary buffer.
	**
	** vC}obt@̃tH[}bgݒ肷ɂ́Aŏ
	** DSBUFFERDESC \̂ł̃tH[}bgLqAɂ̋Lq
	** IDirectSound::CreateSoundBuffer \bhɓnB 
	*/
	ZeroMemory(&dsbd, sizeof(DSBUFFERDESC));
	dsbd.dwSize			= sizeof(DSBUFFERDESC);
	dsbd.dwFlags		= DSBCAPS_PRIMARYBUFFER;
	dsbd.dwBufferBytes	= 0;
	dsbd.lpwfxFormat	= NULL;

	if (FAILED(_pDS->lpVtbl->CreateSoundBuffer(_pDS, &dsbd, &_pDSB, NULL)))
	{
		PRINTF("DIRECTSOUND::CreateSoundBuffer() failed.");
		return FALSE;
	}

	/*
	** Set primary buffer to desired format.
	**
	** vC}obt@IuWFNg擾ŁA]̃EF[u
	** tH[}bgLqA̋Lq IDirectSoundBuffer::SetFormat
	** \bhɓnB
	*/
	ZeroMemory(&_WaveFormat, sizeof(WAVEFORMATEX));
	_WaveFormat.wFormatTag			= WAVE_FORMAT_PCM;
	_WaveFormat.nChannels			= nChannels; 
	_WaveFormat.wBitsPerSample		= wBitsPerSample;
	_WaveFormat.nBlockAlign		= _WaveFormat.nChannels * _WaveFormat.wBitsPerSample / 8;
	_WaveFormat.nSamplesPerSec		= nSamplesPerSec;
	_WaveFormat.nAvgBytesPerSec	= _WaveFormat.nSamplesPerSec * _WaveFormat.nBlockAlign;

	if (FAILED(_pDSB->lpVtbl->SetFormat(_pDSB, &_WaveFormat)))
	{
		PRINTF("DIRECTSOUNDBUFFER::SetFormat() failed.");
//		return FALSE;
	}

	// ݒ肪IvC}obt@͉A
	// ZJ_obt@쐬B 
	SAFE_RELEASE(_pDSB);

	// DSBUFFERDESC \̂ݒ肷B
	ZeroMemory(&dsbd, sizeof(DSBUFFERDESC));
	dsbd.dwSize	= sizeof(DSBUFFERDESC);
	dsbd.dwFlags	= DSBCAPS_CTRLPOSITIONNOTIFY | DSBCAPS_STICKYFOCUS;
	dsbd.dwBufferBytes	= dwBufSize * 2;
	dsbd.lpwfxFormat	= &_WaveFormat;

	// ZJ_obt@쐬 
	if (FAILED(_pDS->lpVtbl->CreateSoundBuffer(_pDS, &dsbd, &_pDSB, NULL)))	
	{
		PRINTF("AudioOut: Failed creating secondary buffer");
		return FALSE;
	}

	_hEvent[0] = CreateEvent(NULL, TRUE, FALSE, NULL);	// start position 
	_hEvent[1] = CreateEvent(NULL, TRUE, FALSE, NULL);	// half position 
	_hEvent[2] = CreateEvent(NULL, TRUE, FALSE, NULL);	// stop notification 

	// DIRECTSOUNDNOTIFY ̃C^tFCX𓾂 
	if (FAILED(_pDSB->lpVtbl->QueryInterface(_pDSB, &IID_IDirectSoundNotify, (void**)&lpDSN)))	return FALSE;

	// obt@̐擪ʒmp 
	_PosNotify[0].dwOffset = 0;
	_PosNotify[0].hEventNotify = _hEvent[0];

	// obt@̒ʒmp
	_PosNotify[1].dwOffset = dwBufSize;
	_PosNotify[1].hEventNotify = _hEvent[1];

	// Đ~ꂽƂ notification p 
	_PosNotify[2].dwOffset = DSBPN_OFFSETSTOP;
	_PosNotify[2].hEventNotify = _hEvent[2];

	// notification ݒ肷 
	if (FAILED(lpDSN->lpVtbl->SetNotificationPositions(lpDSN, 3, _PosNotify)))	return FALSE;

	// ケ̍\͕̂sv 
	SAFE_RELEASE(lpDSN);

	// NeBJZNVIuWFNg 
	InitializeCriticalSection(&_CriticalSection);

	// I[fBIobt@mۂ 
	_pAudioBuf = GlobalAlloc(GMEM_FIXED, dwBufSize);
	if (_pAudioBuf == NULL)
	{
		d_deinit();
		return FALSE;
	}

	_dwBufSize = dwBufSize;
	_bPlay = FALSE;

	// XbhJnOɃI[fBItOĂB
	// [2004.04.28] fixed
	_bAudioInit = TRUE;

	// DirectSoundBuffer ɖ 
	ZeroMemory(_pAudioBuf, _dwBufSize);
	write_streaming_buffer(0, (LPBYTE)_pAudioBuf, _dwBufSize);
	write_streaming_buffer(_dwBufSize, (LPBYTE)_pAudioBuf, _dwBufSize);

	// Xbh쐬s 
	_hThread = CreateThread(NULL, 0, playback_thread, NULL, 0, &_dwThreadID);
	if (_hThread == NULL)
	{
		d_deinit();
		_bAudioInit = FALSE;
		return FALSE;
	}

	// Xg[~Oobt@𖳉ōĐJn 
	_pDSB->lpVtbl->Play(_pDSB, 0, 0, DSBPLAY_LOOPING);

	return TRUE;
}


/*-----------------------------------------------------------------------------
	[Init]
		
-----------------------------------------------------------------------------*/
BOOL
AOUT_Init(
	Uint32		bufSize,			// in samples 
	Uint32		sampleRate,
	BOOL		bStereo,
	void		(*pCallBack)(Sint16* pBuf, Sint32 nSamples))
{
	if (d_init(WINMAIN_GetHwnd(), 2, (WORD)sampleRate, 16, (DWORD)bufSize*2*2))
	{
		_pCallBack = pCallBack;
		return TRUE;
	}

	return FALSE;
}


/*-----------------------------------------------------------------------------
	[Lock]
		
-----------------------------------------------------------------------------*/
BOOL
AOUT_Lock()
{
	if (!_bAudioInit)
		return FALSE;

	EnterCriticalSection(&_CriticalSection);
	return TRUE;
}


/*-----------------------------------------------------------------------------
	[Unlock]
		
-----------------------------------------------------------------------------*/
void
AOUT_Unlock()
{
	if (!_bAudioInit)
		return;

	LeaveCriticalSection(&_CriticalSection);
}


/*-----------------------------------------------------------------------------
	[Play]
		
-----------------------------------------------------------------------------*/
void
AOUT_Play(
	BOOL		bPlay)
{
	if (!_bAudioInit)
		return;

	_bPlay = bPlay;
}


/*-----------------------------------------------------------------------------
	[Deinit]
		
-----------------------------------------------------------------------------*/
void
AOUT_Deinit()
{
	if (!_bAudioInit)
		return;

	d_deinit();

	_bAudioInit = FALSE;
}

