/*-----------------------------------------------------------------------------
	[CdFader.h]

		Define things needed for CD fader.

	Copyright (C) 2004 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
**---------------------------------------------------------------------------*/
#ifndef CDFADER_H_INCLUDED
#define CDFADER_H_INCLUDED


#include "TypeDefs.h"


/*-----------------------------------------------------------------------------
** ֐̃vg^Cv錾sȂ܂D
**---------------------------------------------------------------------------*/
BOOL
CDFADER_Init(
	Uint32				volumeMaster,
	Uint32				volumeWave,
	Uint32				volumeCd);

void
CDFADER_Synchronize(
	Uint32				mixerHandle,
	Uint32				controlID);

void
CDFADER_SetMasterVolume(
	Uint32		volume);		/* 0 - 65535 */

void
CDFADER_SetCdVolume(
	Uint32		volume);		/* 0 - 65535 */

void
CDFADER_SetWaveVolume(
	Uint32		volume);		/* 0 - 65535 */

Uint32
CDFADER_GetMasterVolume();

Uint32
CDFADER_GetCdVolume();

Uint32
CDFADER_GetWaveVolume();


void
CDFADER_Deinit();

void
CDFADER_FadeOut(
	Sint32		speed);

void
CDFADER_FadeIn(
	Sint32		speed);

void
CDFADER_AdvanceClock(
	Sint32		cycle);


#endif		/* CDFADER_H_INCLUDED */

