/******************************************************************************
	[ScreenGDI.h]

		Define GDI screen interface.

	Copyright (C) 2004 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
******************************************************************************/
#ifndef GDISCREEN_H_INCLUDED
#define GDISCREEN_H_INCLUDED


#include "TypeDefs.h"


BOOL
GDISCREEN_IsFullScreen();

BOOL
GDISCREEN_ToggleFullScreen();

BOOL
GDISCREEN_Init(
	Sint32		width,
	Sint32		height,
	Sint32		bpp,
	Uint32		flags);

Sint32
GDISCREEN_GetWidth();

Sint32
GDISCREEN_GetHeight();

Sint32
GDISCREEN_GetRshift();
Sint32
GDISCREEN_GetGshift();
Sint32
GDISCREEN_GetBshift();

Uint32
GDISCREEN_GetRmask();
Uint32
GDISCREEN_GetGmask();
Uint32
GDISCREEN_GetBmask();

Uint32
GDISCREEN_GetBytesPerPixel();

BOOL
GDISCREEN_ChangeMode(
	Sint32		width,
	Sint32		height,
	Sint32		bpp,
	Uint32		flags);

void
GDISCREEN_SetFPS(
	float		fps);

BOOL
GDISCREEN_WaitVBlank(
	BOOL		bForceWait);

BOOL
GDISCREEN_ShouldDraw();

void
GDISCREEN_DrawText(
	const Sint32	x,
	const Sint32	y,
	const Uint32	fgColor,
	const Uint32	bgColor,
	const BOOL		bOpaque,
	const char*		pText);

BOOL
GDISCREEN_Lock();

void*
GDISCREEN_GetBuffer();

const
Sint32
GDISCREEN_GetBufferPitch();

void
GDISCREEN_Unlock();

void
GDISCREEN_PutPixel(
	Sint32		x,
	Sint32		y,
	Uint32		pixel);

void
GDISCREEN_FillRect(
	Sint32		x,
	Sint32		y,
	Sint32		width,
	Sint32		height,
	Uint32		color);

void
GDISCREEN_Update(
	Sint32		x,
	Sint32		y,
	Sint32		width,
	Sint32		height);

void
GDISCREEN_Blt(
	const void*		pSrc,
	Sint32		srcX,
	Sint32		srcY,
	Sint32		dstX,
	Sint32		dstY,
	Sint32		srcW,
	Sint32		srcH,
	Sint32		dstW,
	Sint32		dstH,
	Sint32		srcPitch,
	Uint32		alpha);

void
GDISCREEN_Deinit();


#endif // GDISCREEN_H_INCLUDED

