/*-----------------------------------------------------------------------------
	[MmxImpl.h]
		Define routines optimized by using MMX instructions.

	Copyright (C) 2004 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
**---------------------------------------------------------------------------*/
#ifndef MMX_IMPL_H_INCLUDED
#define MMX_IMPL_H_INCLUDED

#include "TypeDefs.h"


void
MMX_ScaleLine2x(
	Uint16*		pDst,
	Uint16*		pSrc,
	Sint32		srcW);

void
MMX_Scale2x(
	Uint16*		pDst,
	Uint16*		pSrc,
	Sint32		srcW,
	Sint32		srcH,
	Sint32		dstPitch,
	Sint32		srcPitch);

void
MMX_BilinearInterpolationRGB555(
	Uint16*		pDst,			// ]̃|C^
	Uint16*		pSrc,			// ]̃|C^
	Sint32		destW,			// ]̕
	Sint32		destH,			// ]̍
	Sint32		srcX,			// ]̊JnwW
	Sint32		srcY,			// ]̊JnxW
	Sint32		srcW,			// ]̕
	Sint32		srcH,			// ]̍
	Sint32		dstPitch,		// in pixel
	Sint32		srcPitch);		// in bixel


#endif		/* MMX_IMPL_H_INCLUDED */

