/*-----------------------------------------------------------------------------
	[Mouse.c]
		}EX܂B

	Copyright (C) 2004 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
-----------------------------------------------------------------------------*/
#include "WinMain.h"
#include "Mouse.h"

#include "InputInterface.h"


#include "JoyPad.h"


static Uint32	_ReadCount;
static Sint8	_DeltaX;
static Sint8	_DeltaY;
static Sint32	_CurrX;
static Sint32	_CurrY;
static Sint32	_PrevX;
static Sint32	_PrevY;
static BOOL		_bMsConnected = FALSE;
static Uint8	_ButtonState;
static Sint32	_ClockCounter;


void
MOUSE_RButtonDown(
	BOOL		bDown)
{
	_ButtonState &= ~1;
	_ButtonState |= bDown;
}

void
MOUSE_LButtonDown(
	BOOL		bDown)
{
	_ButtonState &= ~2;
	_ButtonState |= bDown << 1;
}


void
MOUSE_SelButtonDown(
	BOOL		bDown)
{
	_ButtonState &= ~4;
	_ButtonState |= bDown << 2;
}

void
MOUSE_RunButtonDown(
	BOOL		bDown)
{
	_ButtonState &= ~8;
	_ButtonState |= bDown << 3;
}


void
MOUSE_Update(
	Sint32		x,
	Sint32		y)
{
	_CurrX = x;
	_CurrY = y;
}


void
MOUSE_Reset()
{
	if (_ClockCounter >= 7159090/60/2)
	{
		_ReadCount = 0;
		_ClockCounter = 0;
	}
}


Uint8
MOUSE_ReadDelta()
{
	switch (_ReadCount++)
	{
		case 0: /* read delta x hi */
		{
			Sint32		dx;
			Sint32		dy;

			WINMAIN_GetMousePos(&_CurrX, &_CurrY);
			dx = _PrevX - _CurrX;
			dy = _PrevY - _CurrY;

			if (dx > 127)		dx = 127;
			if (dy > 127)		dy = 127;
			if (dx < -128)		dx = -128;
			if (dy < -128)		dy = -128;

			_PrevX = _CurrX;
			_PrevY = _CurrY;

			_DeltaX = (Sint8)dx;
			_DeltaY = (Sint8)dy;

//			printf("dx hi = %d\n", ((Uint8)_DeltaX) >> 4);

			return ((Uint8)_DeltaX) >> 4;
		}

		case 1: /* read delta x lo */
//			printf("dx lo = %d\n", ((Uint8)_DeltaX) & 0xf);
			return ((Uint8)_DeltaX) & 0xf;

		case 2: /* read delta y hi */
//			printf("dy hi = %d\n", ((Uint8)_DeltaY) >> 4);
			return ((Uint8)_DeltaY) >> 4;

		case 3: /* read delta y lo */
			_ReadCount = 0;
			_ClockCounter = 0;
//			printf("dy lo = %d\n", ((Uint8)_DeltaY) & 0xf);
			return ((Uint8)_DeltaY) & 0xf;
	}

	return 0;
}


Uint8
MOUSE_ReadButtons()
{
	Uint8		ret = _ButtonState;

	if (INPUT_IsPressed(0, JOYPAD_BUTTON_SELECT))	ret |= 4;
	if (INPUT_IsPressed(0, JOYPAD_BUTTON_RUN))		ret |= 8;

	return ret ^ 0xf;
}


void
MOUSE_Connect(
	BOOL		bConnect)
{
	_bMsConnected = bConnect;
}


BOOL
MOUSE_IsConnected()
{
	return _bMsConnected;
}



void
MOUSE_AdvanceClock(
	Sint32		cycles)
{
	_ClockCounter += cycles;
}


// save variable
#define SAVE_V(V)	if (fwrite(&V, sizeof(V), 1, p) != 1)	return FALSE
#define LOAD_V(V)	if (fread(&V, sizeof(V), 1, p) != 1)	return FALSE
/*-----------------------------------------------------------------------------
	[SaveState]
		Ԃt@Cɕۑ܂B 
-----------------------------------------------------------------------------*/
BOOL
MOUSE_SaveState(
	FILE*		p)
{
	if (p == NULL)
		return FALSE;

	SAVE_V(_ReadCount);
	SAVE_V(_DeltaX);
	SAVE_V(_DeltaY);
	SAVE_V(_CurrX);
	SAVE_V(_CurrY);
	SAVE_V(_PrevX);
	SAVE_V(_PrevY);
	SAVE_V(_bMsConnected);
	SAVE_V(_ButtonState);

	return TRUE;
}


/*-----------------------------------------------------------------------------
	[LoadState]
		Ԃt@Cǂݍ݂܂B 
-----------------------------------------------------------------------------*/
BOOL
MOUSE_LoadState(
	FILE*		p)
{
	if (p == NULL)
		return FALSE;

	LOAD_V(_ReadCount);
	LOAD_V(_DeltaX);
	LOAD_V(_DeltaY);
	LOAD_V(_CurrX);
	LOAD_V(_CurrY);
	LOAD_V(_PrevX);
	LOAD_V(_PrevY);
	LOAD_V(_bMsConnected);
	LOAD_V(_ButtonState);

	return TRUE;
}

#undef SAVE_V
#undef LOAD_V
