/*-----------------------------------------------------------------------------
	[Printf.c]

		Implements a printf function which displays a text on the
	main window's title bar.

	Copyright (C) 2005 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
-----------------------------------------------------------------------------*/
#include <stdio.h>
#include <stdarg.h>
#include "Printf.h"
#include "WinMain.h"


#define PRINTF_MESSAGE_MIN		32			/* ms     */
#define PRINTF_MESSAGE_MAX		60*3		/* frames */

static char						_MessageBuffer[2048];
static Uint32					_FrameCount = 0;



/*----------------------------------------------------------------------------
	[PRINTF]
		Displays a text message for several seconds.
----------------------------------------------------------------------------*/
void
PRINTF(
	const char*		pMessage, ...)
{
	va_list			ap;

	va_start(ap, pMessage);
	vsprintf(_MessageBuffer, pMessage, ap);
	va_end(ap);

	while (strchr(_MessageBuffer, '\n'))
		*strchr(_MessageBuffer, '\n') = '\0';

	puts(_MessageBuffer);
	WINMAIN_SetCaption(_MessageBuffer);
	Sleep(PRINTF_MESSAGE_MIN);
	_FrameCount = 0;
}


void
PRINTF_Update()
{
	if (++_FrameCount == PRINTF_MESSAGE_MAX)
		WINMAIN_SetCaption(NULL);
}


BOOL
PRINTF_Init()
{
	_FrameCount = 0;
	return TRUE;
}


void
PRINTF_Deinit()
{
	_FrameCount = 0;
}

