/******************************************************************************
	[Timer.c]
		^C}[܂D

	Copyright (C) 2004 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
******************************************************************************/
#include <stdio.h>
#include "Timer.h"
#include "IntCtrl.h"

/*
	^C}[̊荞ݎF
	21.47727 / 3 / 1024 = 6991.298828125 [Hz] --> 1.430349e-4 [s]
	21.47727 / 3 / 1024 / 128 = 54.6195220947265625 [Hz] --> 0.01830847 [s]

	^C}͂bot̓NbN 21.47727 / 3 [MHz] 
	POQSē삷DƂƂ́Cbot̂POQSTCN
	_EJE^̂PTCNƓDāC_EJE^
	Ŗ{̒lPOQS{(<<10)ĕێ邱ƂɂD
*/
static Sint32	_DownCounter;
static Sint32	_ReloadRegister;
static BOOL		_bTimerRunning;


/*-----------------------------------------------------------------------------
** [TIMER_Init]
**   ^C}[܂D
**---------------------------------------------------------------------------*/
Sint32
TIMER_Init()
{
	_bTimerRunning = FALSE;

	return 0;
}


/*-----------------------------------------------------------------------------
** [TIMER_Destroy]
**   ^C}[̏IsȂ܂D
**---------------------------------------------------------------------------*/
void
TIMER_Deinit()
{
	INTCTRL_Cancel(INTCTRL_TIRQ);
}


/*-----------------------------------------------------------------------------
** [TIMER_Read]
**   ^C}[̓ǂݏołD
**---------------------------------------------------------------------------*/
Uint8
TIMER_Read(
	Uint32 regNum)
{
	return (Uint8)((_DownCounter >> 10) & 0x7f);
}


/*-----------------------------------------------------------------------------
** [TIMER_Write]
**   ^C}[ւ̏ݓłD
**---------------------------------------------------------------------------*/
void
TIMER_Write(
	Uint32		regNum,
	Uint8		data)
{
	switch (regNum & 1)
	{
		case 0:
			_ReloadRegister = ((data & 0x7f) + 1) * 1024 - 1;
			return;

		case 1:
			data &= 1;
			/*
			** CR: 0 --> 1 ŃJEgJnD
			*/
			if (data && !_bTimerRunning)
				_DownCounter = _ReloadRegister;

			_bTimerRunning = (data != 0);
			return;
	}
}


/*-----------------------------------------------------------------------------
	[TIMER_AdvanceClock]
		ŵbotNbN^C}[i߂܂D
-----------------------------------------------------------------------------*/
Uint32
TIMER_AdvanceClock(
	Uint32		clock)
{
	Uint32		ret = 0;

	if (_bTimerRunning)
	{
		_DownCounter -= clock;
		if (_DownCounter < 0)	/* "<=" ł͂Ȃ "<" ɂ */
		{
			ret = TIMER_IRQ;
			INTCTRL_Request(INTCTRL_TIRQ);
			_DownCounter = _ReloadRegister;
//			printf("DownCounter Reload = %02X\n", _ReloadRegister);
		}
	}

	return ret;
}


#define SAVE_V(V)	if (fwrite(&V, sizeof(V), 1, p) != 1)	return FALSE
#define LOAD_V(V)	if (fread(&V, sizeof(V), 1, p) != 1)	return FALSE
/*-----------------------------------------------------------------------------
	[SaveState]
		Ԃt@Cɕۑ܂B 
-----------------------------------------------------------------------------*/
BOOL
TIMER_SaveState(
	FILE*		p)
{
	if (p == NULL)
		return FALSE;

	SAVE_V(_DownCounter);
	SAVE_V(_ReloadRegister);
	SAVE_V(_bTimerRunning);

	return TRUE;
}


/*-----------------------------------------------------------------------------
	[LoadState]
		Ԃt@Cǂݍ݂܂B 
-----------------------------------------------------------------------------*/
BOOL
TIMER_LoadState(
	FILE*		p)
{
	if (p == NULL)
		return FALSE;

	LOAD_V(_DownCounter);
	LOAD_V(_ReloadRegister);
	LOAD_V(_bTimerRunning);

	return TRUE;
}

#undef SAVE_V
#undef LOAD_V
