/*-----------------------------------------------------------------------------
	[VDC.h]

	Copyright (C) 2004 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
-----------------------------------------------------------------------------*/
#ifndef VDC_H_INCLUDED
#define VDC_H_INCLUDED

#include <stdio.h>
#include "TypeDefs.h"


/*
** AR ̒lɂăANZX郌WX^
*/
#define		VDC_MAWR			0x00
#define		VDC_MARR			0x01
#define		VDC_VWR				0x02
#define		VDC_VRR				0x02
#define		VDC_CR				0x05
#define		VDC_RCR				0x06
#define		VDC_BXR				0x07
#define		VDC_BYR				0x08
#define		VDC_MWR				0x09
#define		VDC_HSR				0x0A
#define		VDC_HDR				0x0B
#define		VDC_VPR				0x0C
#define		VDC_VDW				0x0D
#define		VDC_VCR				0x0E
#define		VDC_DCR				0x0F
#define		VDC_SOUR			0x10
#define		VDC_DESR			0x11
#define		VDC_LENR			0x12
#define		VDC_SATB			0x13


/*
** VDC STATUS
*/
#define		VDC_STAT_CR				0x01  // sprite collision
#define		VDC_STAT_OR				0x02  // over detection
#define		VDC_STAT_RR				0x04  // raster detection
#define		VDC_STAT_DS				0x08  // DMA (VRAM-SATB) end
#define		VDC_STAT_DV				0x10  // DMA (VRAM-VRAM) end
#define		VDC_STAT_VD				0x20  // vertical retrace period
#define		VDC_STAT_BSY			0x40  // VRAM reading / writing

/*
** VDC CONTROL (R05)
*/
#define		VDC_CTRL_CC				0x01	// enable IRQ on sprite collision
#define		VDC_CTRL_OC				0x02	// enable IRQ on "over"
#define		VDC_CTRL_RC				0x04	// enable IRQ1 on raster detection
#define		VDC_CTRL_VC				0x08	// enable IRQ1 on v-retrace period

/*
** DMA CONTROL ($0F)
*/
#define		VDC_DMACTRL_CR			0x01	// request IRQ1 after VRAM->SATB DMA
#define		VDC_DMACTRL_OR			0x02	// request IRQ1 after VRAM->VRAM DMA


/*
** VDC_AdvanceClock Ԃl
*/
#define		VDC_OK					0x00	// ɂȂɂȂ
#define		VDC_RASTER_HIT			0x01	// w胉X^ɂȂ
#define		VDC_VBL_START			0x02	// uuNJn
#define		VDC_VBL_END				0x04	// uuNI
#define		VDC_VRAMDMA_END			0x08	// VRAM-VRAM DMA I 
#define		VDC_SATBDMA_END			0x10	// VRAM-SATB DMA I 
#define		VDC_DISPLAY_END			0x20	// \I 

/*-----------------------------------------------------------------------------
	Define Function Prototypes
-----------------------------------------------------------------------------*/
Sint32
VDC_Init();

void
VDC_Deinit();


Uint8
VDC_Read(Uint32 regNum);

void
VDC_Write(
	Uint32		regNum,
	Uint8		data);

Uint32
VDC_AdvanceClock(Sint32 clock);

Uint32
VDC_AdvanceLine();

const
Sint32
VDC_GetDisplayWidth();

const
Sint32
VDC_GetDisplayHeight();

const
Sint32
VDC_GetTopOffset();

const
Sint32
VDC_GetLeftOffset();

const
Uint32
VDC_GetDisplayEnd();

const
Sint32
VDC_GetScanLine();

const
Uint8*
VDC_GetLineBuffer();

const
Uint8*
VDC_GetSpBgBuffer();


BOOL
VDC_SaveState(
	FILE*		p);

BOOL
VDC_LoadState(
	FILE*		p);


// Debug functions
Uint8* VDC_GetVideoRam();

#endif		/* VDC_H_INCLUDED */

