/*-----------------------------------------------------------------------------
	[WinMain.c]

	Copyright (C) 2004 Ki

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
-----------------------------------------------------------------------------*/
#include <windows.h>
#include <stdio.h>
#include <string.h>

#include "WinMain.h"
#include "AppEvent.h"
#include "CdFader.h"
#include "AudioConfig.h"
#include "MainBoard.h"

#include "Mouse.h"


#ifdef DEBUGBUILD
#define CAPTION		"PROJECT PC2E DEBUG BUILD " __DATE__
#else
#define CAPTION		"PROJECT PC2E " __DATE__
#endif

static HINSTANCE		_hInstance;
static HWND				_hMainWnd;

//static BOOL				_bCaptionClicked = FALSE;


static
int
init_argc(
	LPSTR		lpCmdLine)
{
	int			argc = 1;

	while (lpCmdLine != NULL)
	{
		// ' ' ̓XLbv 
		while (*lpCmdLine == ' ')
		{
			++lpCmdLine;
		}

		if (strlen(lpCmdLine) > 0)
			++argc;
		else
			break;

		// " 𔭌ꍇ͎ " ܂łP argument Ƃ 
		if (*lpCmdLine == '"')
		{
			++lpCmdLine;

			// " ݂ 
			if (strchr(lpCmdLine, '"') != NULL)
			{
				// " XLbv 
				lpCmdLine = strchr(lpCmdLine, '"') + 1;
			}
			else
			{
				// ݂Ȃꍇ argument ȂƂ݂Ȃ 
				argc = 1;
				break;
			}
		}
		else
		{
			if (strchr(lpCmdLine, ' ') != NULL)
			{
				lpCmdLine = strchr(lpCmdLine, ' ');
			}
			else
			{
				break;
			}
		}
	}

	return argc;
}


static
char**
init_argv(
	int			argc,
	LPSTR		lpCmdLine)
{
	char**		ppArgv;
	char*		p;
	int			i;

	if (argc == 0)
	{
		return NULL;
	}

	ppArgv = (char**)GlobalAlloc(GMEM_FIXED, sizeof(char*) * argc);

	if (ppArgv == NULL)
	{
		exit(-1);
	}


	for (i = 0; i < argc; i++)
	{
		ppArgv[i] = (char*)GlobalAlloc(GMEM_FIXED, MAX_PATH);

		if (i == 0)
		{
			// argv[0]
			GetModuleFileName(NULL, ppArgv[i], MAX_PATH);
		}
		else
		{
			// ' ' ̓XLbv 
			while (*lpCmdLine == ' ')
			{
				++lpCmdLine;
			}

			// " 𔭌ꍇ͎ " ܂ł argument Ƃ 
			if (*lpCmdLine == '"')
			{
				p = lpCmdLine + 1;
				strcpy(ppArgv[i], p);

				//  " T 
				if ((p = strchr(ppArgv[i], '"')) != NULL)
				{
					*p = '\0';
					// " QXLbv 
					lpCmdLine += strlen(ppArgv[i]) + 2;
				}
				else
				{
					//  " Ȃꍇ̓[vʂ 
					// (argc ̏Ōς݂Ȃ̂łɂ͂Ȃ͂) 
					break;
				}
			}
			else
			{
				strcpy(ppArgv[i], lpCmdLine);

				if ((p = strchr(ppArgv[i], ' ')) != NULL)
				{
					*p = '\0';
				}

				lpCmdLine += strlen(ppArgv[i]);
			}
		}
	}

	return ppArgv;
}


static
void
set_fullscreen_windowstyle(
	HWND		hWnd,
	int			width,
	int			height)
{
	SetWindowLong(hWnd, GWL_STYLE, GetWindowLong(hWnd, GWL_STYLE) & ~(WS_MINIMIZEBOX | WS_SYSMENU | WS_CAPTION));
//	SetWindowPos(hWnd, NULL, 0, 0, width, height, SWP_NOMOVE | SWP_NOSIZE | SWP_NOZORDER | SWP_FRAMECHANGED);
	SetWindowPos(hWnd, HWND_TOPMOST, 0, 0, width, height, SWP_NOMOVE | SWP_NOSIZE | SWP_FRAMECHANGED);

//	puts("set_fullscreen_windowstyle");

	// Hide mouse cursor by decrementing its internal counter
	//WINMAIN_ShowCursor(FALSE);
}


#ifdef DEBUGBUILD
static
void
set_normal_windowstyle(
	HWND		hWnd,
	int			width,
	int			height)
{
	RECT		rc;
	DWORD		dwStyle;
	int			x;
	int			y;

	dwStyle = GetWindowLong(hWnd, GWL_STYLE) | (WS_MINIMIZEBOX | WS_SYSMENU | WS_CAPTION);
	SetWindowLong(hWnd, GWL_STYLE, dwStyle);

	GetWindowRect(hWnd, &rc);
	x = rc.left;
	y = rc.top;

	SetRect(&rc, 0, 0, width, height);

	AdjustWindowRect(&rc, GetWindowLong(hWnd, GWL_STYLE), GetMenu(hWnd) != NULL);
	SetWindowPos(hWnd, HWND_NOTOPMOST, x, y, rc.right - rc.left, rc.bottom - rc.top, SWP_FRAMECHANGED);

//	WINMAIN_ShowCursor(TRUE);
}
#else
static
void
set_normal_windowstyle(
	HWND		hWnd,
	int			width,
	int			height)
{
	RECT		rc;
	DWORD		dwStyle;
	int			x;
	int			y;

	dwStyle = GetWindowLong(hWnd, GWL_STYLE) | (WS_MINIMIZEBOX | WS_SYSMENU | WS_CAPTION);
	SetWindowLong(hWnd, GWL_STYLE, dwStyle);

	SetRect(&rc, 0, 0, width, height);

	AdjustWindowRect(&rc, GetWindowLong(hWnd, GWL_STYLE), GetMenu(hWnd) != NULL);

	x = (GetSystemMetrics(SM_CXMAXIMIZED)-(rc.right-rc.left)) / 2;
	y = (GetSystemMetrics(SM_CYMAXIMIZED)-(rc.bottom-rc.top)) / 2;

	SetWindowPos(hWnd, HWND_NOTOPMOST, x, y, rc.right - rc.left, rc.bottom - rc.top, SWP_FRAMECHANGED);
//	WINMAIN_ShowCursor(TRUE);

//	puts("set_normal_windowstyle");
}
#endif


static
LRESULT
CALLBACK
wnd_proc(
	HWND		hWnd,
	UINT		uMsg,
	WPARAM		wParam,
	LPARAM		lParam)
{
	switch(uMsg)
	{
	case WM_PAINT:
		APPEVENT_Set(APPEVENT_REDRAWSCREEN, NULL);
		break;

	/* wParam = handle to the mixer device, lParam = dwControlID member of the MIXERCONTROL structure */
	case MM_MIXM_CONTROL_CHANGE:
		//CDFADER_Synchronize((Uint32)wParam, (Uint32)lParam);
		AUDIOCONFIG_Update();
		break;
/*
	case MM_MIXM_LINE_CHANGE:
		printf("MM_MIXM_LINE_CHANGE, wParam = %08X, lParam = %08X\n", wParam, lParam);
		break;
*/
	case WM_KEYDOWN:
		switch (wParam)
		{
		case VK_ESCAPE:		PostMessage(hWnd, WM_ENTERMENULOOP, 0, 0);			break;
		//APPEVENT_Set(APPEVENT_SHOWMENU, 0);					break;
		case VK_F1:			APPEVENT_Set(APPEVENT_RESET, NULL);					break;
		case VK_F2:			APPEVENT_Set(APPEVENT_RUN, NULL);					break;
		case VK_SPACE:		APPEVENT_Set(APPEVENT_FILEDIALOG, NULL);			break;
		case VK_F4:			APPEVENT_Set(APPEVENT_PARTIALMEMORYLOAD, NULL);		break;
		case VK_F5:			APPEVENT_Set(APPEVENT_SAVESTATE, NULL);				break;
		case VK_F6:			APPEVENT_Set(APPEVENT_RECORD, NULL);				break;
		case VK_F7:			APPEVENT_Set(APPEVENT_LOADSTATE, NULL);				break;
		case VK_F8:			APPEVENT_Set(APPEVENT_PLAYBACK, NULL);				break;
		case VK_F12:		APPEVENT_Set(APPEVENT_TOGGLEFULLSCREEN, NULL);		break;
		}
		break;

	// F10 Ƃ͂g 
	case WM_SYSKEYDOWN:
		switch (wParam)
		{
		case VK_MENU:		APPEVENT_Set(APPEVENT_SHOWMENU, NULL);				break;
//		case VK_F10:
//			break;
		}
		break;

	case WM_LBUTTONDOWN:
		MOUSE_LButtonDown(TRUE);
		break;

	case WM_LBUTTONUP:
		MOUSE_LButtonDown(FALSE);
		break;

	case WM_RBUTTONDOWN:
		MOUSE_RButtonDown(TRUE);
		break;

	case WM_RBUTTONUP:
		MOUSE_RButtonDown(FALSE);
		break;

//	case WM_MOUSEMOVE:
//		if (GetCapture() == hWnd)
//		MOUSE_Update(LOWORD(lParam), HIWORD(lParam));
//		break;

	case WM_DROPFILES:
		{
			HDROP		hDrop;
			char		dragFilePathName[MAX_PATH];

			hDrop = (HANDLE)wParam;
			DragQueryFile(hDrop, 0, dragFilePathName, MAX_PATH);

			APPEVENT_Set(APPEVENT_OPENGAME, dragFilePathName);

			DragFinish(hDrop);
		}
		break;

	case WM_ENTERMENULOOP:
		APPEVENT_Set(APPEVENT_SHOWMENU, NULL);
		break;

//	case WM_EXITMENULOOP:
//		puts("exit menu loop");
//		APPEVENT_Set(APPEVENT_HIDEMENU, NULL);
//		break;

	case WM_CLOSE:
		APPEVENT_Set(APPEVENT_EXIT, NULL);
		break;

	case WM_DESTROY:
		PostQuitMessage(0);
		return 0;

	case WM_SET_FULLSCREEN_WS:
		set_fullscreen_windowstyle(hWnd, (int)wParam, (int)lParam);
		APPEVENT_Set(APPEVENT_REDRAWSCREEN, NULL);
		return 0;

	case WM_SET_NORMAL_WS:
		set_normal_windowstyle(hWnd, (int)wParam, (int)lParam);
		APPEVENT_Set(APPEVENT_REDRAWSCREEN, NULL);
		return 0;

	case WM_MEMED_CLOSE:
		APPEVENT_Set(APPEVENT_SWITCH_MEMORYEDITOR, NULL);
		return 0;

	case WM_COMMAND:
		switch (LOWORD(wParam))
		{
		case WM_OPEN_FILE:				APPEVENT_Set(APPEVENT_FILEDIALOG, NULL);			break;
		case WM_RESET_EMULATOR:			APPEVENT_Set(APPEVENT_RESET, NULL);					break;
		case WM_RUN_EMULATOR:			APPEVENT_Set(APPEVENT_RUN, NULL);					break;
//		case WM_STOP_EMULATOR:			APPEVENT_Set(APPEVENT_PAUSE, NULL);					break;
		case WM_LOAD_STATE:				APPEVENT_Set(APPEVENT_LOADSTATE, NULL);				break;
		case WM_SAVE_STATE:				APPEVENT_Set(APPEVENT_SAVESTATE, NULL);				break;
		case WM_RECORD_GAMEPLAY:		APPEVENT_Set(APPEVENT_RECORD, NULL);				break;
		case WM_PLAYBACK_GAMEPLAY:		APPEVENT_Set(APPEVENT_PLAYBACK, NULL);				break;
		case WM_CDROM_LOG:				APPEVENT_Set(APPEVENT_CDROM_LOG, NULL);				break;
		case WM_HDWR_LOG:				APPEVENT_Set(APPEVENT_HDWR_LOG, NULL);				break;
		case WM_TRACE_1_STEP:			APPEVENT_Set(APPEVENT_TRACE_1, NULL);				break;
		case WM_TRACE_10_STEP:			APPEVENT_Set(APPEVENT_TRACE_10, NULL);				break;
		case WM_TRACE_100_STEP:			APPEVENT_Set(APPEVENT_TRACE_100, NULL);				break;
		case WM_TRACE_1000_STEP:		APPEVENT_Set(APPEVENT_TRACE_1000, NULL);			break;
		case WM_TRACE_10000_STEP:		APPEVENT_Set(APPEVENT_TRACE_10000, NULL);			break;
		case WM_TRACE_1_FRAME:			APPEVENT_Set(APPEVENT_ADVANCEFRAME_1, NULL);		break;
		case WM_TRACE_10_FRAME:			APPEVENT_Set(APPEVENT_ADVANCEFRAME_10, NULL);		break;
		case WM_TRACE_100_FRAME:		APPEVENT_Set(APPEVENT_ADVANCEFRAME_100, NULL);		break;
		case WM_SCREEN_X1:				APPEVENT_Set(APPEVENT_SCREEN_X1, NULL);				break;
		case WM_SCREEN_X2:				APPEVENT_Set(APPEVENT_SCREEN_X2, NULL);				break;
		case WM_SCREEN_X3:				APPEVENT_Set(APPEVENT_SCREEN_X3, NULL);				break;
		case WM_SCREEN_X4:				APPEVENT_Set(APPEVENT_SCREEN_X4, NULL);				break;

		case WM_INPUT_TWO_BUTTON_PAD:	APPEVENT_Set(APPEVENT_INPUT_TWO_BUTTON_PAD, NULL);	break;
		case WM_INPUT_SIX_BUTTON_PAD:	APPEVENT_Set(APPEVENT_INPUT_SIX_BUTTON_PAD, NULL);	break;
		case WM_INPUT_MOUSE:			APPEVENT_Set(APPEVENT_INPUT_MOUSE, NULL);			break;
		case WM_INPUT_MULTI_TAP:		APPEVENT_Set(APPEVENT_INPUT_MULTI_TAP, NULL);		break;
		case WM_INPUT_MB128:			APPEVENT_Set(APPEVENT_INPUT_MB128, NULL);			break;

		case WM_INPUT_CONFIGURE_PAD1:	APPEVENT_Set(APPEVENT_INPUT_CONFIGURE_PAD1, NULL);	break;
		case WM_INPUT_CONFIGURE_PAD2:	APPEVENT_Set(APPEVENT_INPUT_CONFIGURE_PAD2, NULL);	break;
		case WM_INPUT_CONFIGURE_PAD3:	APPEVENT_Set(APPEVENT_INPUT_CONFIGURE_PAD3, NULL);	break;
		case WM_INPUT_CONFIGURE_PAD4:	APPEVENT_Set(APPEVENT_INPUT_CONFIGURE_PAD4, NULL);	break;
		case WM_INPUT_CONFIGURE_PAD5:	APPEVENT_Set(APPEVENT_INPUT_CONFIGURE_PAD5, NULL);	break;

		case WM_SCREEN_FULLSCREEN:		APPEVENT_Set(APPEVENT_TOGGLEFULLSCREEN, NULL);		break;
		case WM_SCREEN_STRETCHED:		APPEVENT_Set(APPEVENT_SCREEN_STRETCHED, NULL);		break;
		case WM_SCREEN_SCANLINED:		APPEVENT_Set(APPEVENT_SCREEN_SCANLINED, NULL);		break;
		case WM_SCREEN_HWACCEL:			APPEVENT_Set(APPEVENT_SCREEN_HWACCEL, NULL);		break;
		case WM_SCREEN_SYNC_VBLANK:		APPEVENT_Set(APPEVENT_SCREEN_SYNC_VBLANK, NULL);	break;

		case WM_AUDIO_SR96000:			APPEVENT_Set(APPEVENT_AUDIO_SR96000, NULL);			break;
		case WM_AUDIO_SR88200:			APPEVENT_Set(APPEVENT_AUDIO_SR88200, NULL);			break;
		case WM_AUDIO_SR64000:			APPEVENT_Set(APPEVENT_AUDIO_SR64000, NULL);			break;
		case WM_AUDIO_SR48000:			APPEVENT_Set(APPEVENT_AUDIO_SR48000, NULL);			break;
		case WM_AUDIO_SR44100:			APPEVENT_Set(APPEVENT_AUDIO_SR44100, NULL);			break;
		case WM_AUDIO_SR32000:			APPEVENT_Set(APPEVENT_AUDIO_SR32000, NULL);			break;
		case WM_AUDIO_SR22050:			APPEVENT_Set(APPEVENT_AUDIO_SR22050, NULL);			break;
		case WM_AUDIO_SR11025:			APPEVENT_Set(APPEVENT_AUDIO_SR11025, NULL);			break;

		case WM_AUDIO_SB4096:			APPEVENT_Set(APPEVENT_AUDIO_SB4096, NULL);			break;
		case WM_AUDIO_SB3840:			APPEVENT_Set(APPEVENT_AUDIO_SB3840, NULL);			break;
		case WM_AUDIO_SB3584:			APPEVENT_Set(APPEVENT_AUDIO_SB3584, NULL);			break;
		case WM_AUDIO_SB3328:			APPEVENT_Set(APPEVENT_AUDIO_SB3328, NULL);			break;
		case WM_AUDIO_SB3072:			APPEVENT_Set(APPEVENT_AUDIO_SB3072, NULL);			break;
		case WM_AUDIO_SB2816:			APPEVENT_Set(APPEVENT_AUDIO_SB2816, NULL);			break;
		case WM_AUDIO_SB2560:			APPEVENT_Set(APPEVENT_AUDIO_SB2560, NULL);			break;
		case WM_AUDIO_SB2304:			APPEVENT_Set(APPEVENT_AUDIO_SB2304, NULL);			break;
		case WM_AUDIO_SB2048:			APPEVENT_Set(APPEVENT_AUDIO_SB2048, NULL);			break;

		case WM_AUDIO_SETVOLUME:		APPEVENT_Set(APPEVENT_AUDIO_SETVOLUME, NULL);		break;

		case WM_SAVE_BMP:				APPEVENT_Set(APPEVENT_SAVE_BMP, NULL);				break;

		case WM_EXIT:					SendMessage(hWnd, WM_CLOSE, 0, 0);					break;
		}
		break;

	default:
		break;
	}

	return DefWindowProc(hWnd, uMsg, wParam, lParam);
}


static
HWND
create_main_window(
	HINSTANCE		hInstance,
	int				nCmdShow)
{
	WNDCLASS	wc;
	HWND		hWnd;
	const char	className[] = CAPTION;

	ZeroMemory(&wc, sizeof(wc));
	wc.style		 = 0;
	wc.lpfnWndProc	 = wnd_proc;
	wc.cbClsExtra	 = 0;
	wc.cbWndExtra	 = 0;
	wc.hInstance	 = hInstance;
	wc.hIcon		 = LoadIcon(NULL, IDI_APPLICATION);
	wc.hCursor		 = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = (HBRUSH)GetStockObject(BLACK_BRUSH);
	wc.lpszMenuName	 = "";
	wc.lpszClassName = className;

	if (RegisterClass(&wc) == 0)	return NULL;

#ifdef DEBUGBUILD
	hWnd = CreateWindow(
		className,
		className,
		WS_MINIMIZEBOX | WS_SYSMENU | WS_CAPTION,
		20,
		50,
		256,
		240,
		NULL,
		NULL,
		hInstance,
		NULL
	);
#else
	hWnd = CreateWindow(
		className,
		className,
		WS_MINIMIZEBOX | WS_SYSMENU | WS_CAPTION,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		256,
		240,
		NULL,
		NULL,
		hInstance,
		NULL
	);
#endif


	if (hWnd == NULL)
	{
		return NULL;
	}

	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);

	// Drag&Drop 
	DragAcceptFiles(hWnd, TRUE);

	return hWnd;
}


static
void
deinit_argv(
	int		argc,
	char**	ppArgv)
{
	while (argc--)
	{
		GlobalFree((HGLOBAL)ppArgv[argc]);
	}

	GlobalFree((HGLOBAL)ppArgv);
}


const
HINSTANCE
WINMAIN_GetHInstance()
{
	return _hInstance;
}

const
HWND
WINMAIN_GetHwnd()
{
	return _hMainWnd;
}


void
WINMAIN_SetCaption(
	const char*		pCaption)
{
	if (pCaption)
		SetWindowText(_hMainWnd, pCaption);
	else
		SetWindowText(_hMainWnd, CAPTION);
}


Uint32
WINMAIN_ShowCursor(
	BOOL		bShow)
{
	if (bShow)
		while (ShowCursor(bShow) < 0);
	else
		while (ShowCursor(bShow) >= 0);

	return 0;
}


void
WINMAIN_GetMousePos(
	Sint32*		x,
	Sint32*		y)
{
	POINT		p;

	GetCursorPos(&p);

	*x = p.x;
	*y = p.y;
}


void
WINMAIN_SetFullScreenWindow(
	Sint32		width,
	Sint32		height)
{
//	PostMessage(_hMainWnd, WM_SET_FULLSCREEN_WS, (WPARAM)width, (LPARAM)height);
	SendMessage(_hMainWnd, WM_SET_FULLSCREEN_WS, (WPARAM)width, (LPARAM)height);
}


void
WINMAIN_SetNormalWindow(
	Sint32		width,
	Sint32		height)
{
//	PostMessage(_hMainWnd, WM_SET_NORMAL_WS, (WPARAM)width, (LPARAM)height);
	SendMessage(_hMainWnd, WM_SET_NORMAL_WS, (WPARAM)width, (LPARAM)height);
}


int
WINAPI
WinMain(
	HINSTANCE	hInstance,
	HINSTANCE	hPrevInstance,
	LPSTR		lpCmdLine,
	int			nCmdShow)
{
	char**		argv;
	int			argc;
	int			ret;

	_hInstance = hInstance;

	argc = init_argc(lpCmdLine);
	argv = init_argv(argc, lpCmdLine);

	if (argv == NULL)
		return -1;

	_hMainWnd = create_main_window(hInstance, nCmdShow);

	if (_hMainWnd == NULL)
	{
		deinit_argv(argc, argv);
		return -1;
	}

	ret = __main__(argc, argv);

	deinit_argv(argc, argv);

	return ret;
}
