/*-----------------------------------------------------------------------------
	[CriticalSection.c]
		Implements a critical section wrapper.

	Copyright (C) 2004 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
**---------------------------------------------------------------------------*/
#include <windows.h>		// wrap Win32 critical section 

#include "CriticalSection.h"


typedef struct
{
	CRITICAL_SECTION		cs;
	BOOL					bUsed;
} CS;


static CS					_CS[CS_MAX];


/*-----------------------------------------------------------------------------
	[Init]
-----------------------------------------------------------------------------*/
BOOL
CS_Init()
{
	ZeroMemory(_CS, sizeof(_CS));
	return TRUE;
}


/*-----------------------------------------------------------------------------
	[Deinit]
-----------------------------------------------------------------------------*/
BOOL
CS_Deinit()
{
	int		i;

	for (i = 0; i < CS_MAX; i++)
	{
		if (_CS[i].bUsed)
		{
			DeleteCriticalSection(&_CS[i].cs);
		}
	}

	return TRUE;
}


/*-----------------------------------------------------------------------------
	[Create]
		Returns id:  < 0 on failure.
-----------------------------------------------------------------------------*/
Sint32
CS_Create()
{
	int			i;
	Sint32		id = -1;

	for (i = 0; i < CS_MAX; i++)
	{
		if (!_CS[i].bUsed)
		{
			InitializeCriticalSection(&_CS[i].cs);
			_CS[i].bUsed = TRUE;
			id = i;
			break;
		}
	}

	return id;
}


/*-----------------------------------------------------------------------------
	[Delete]
		ҋ@̃XbhԂŔjĂȂB 
-----------------------------------------------------------------------------*/
BOOL
CS_Delete(
	const Sint32	id)
{
	if (id < CS_MAX)
	{
		if (_CS[id].bUsed)
		{
			_CS[id].bUsed = FALSE;
			DeleteCriticalSection(&_CS[id].cs);
			return TRUE;
		}
	}

	return FALSE;
}


/*-----------------------------------------------------------------------------
	[Enter]
-----------------------------------------------------------------------------*/
BOOL
CS_Enter(
	const Sint32		id)
{
	if (id < CS_MAX)
	{
		if (_CS[id].bUsed)
		{
			EnterCriticalSection(&_CS[id].cs);
			return TRUE;
		}
	}

	return FALSE;
}


/*-----------------------------------------------------------------------------
	[Leave]
-----------------------------------------------------------------------------*/
BOOL
CS_Leave(
	const Sint32		id)
{
	if (id < CS_MAX)
	{
		if (_CS[id].bUsed)
		{
			LeaveCriticalSection(&_CS[id].cs);
			return TRUE;
		}
	}

	return FALSE;
}

