/******************************************************************************
	[InputInterface.h]

		͌ñC^tFCX`܂D

		Define input interface.

	Copyright (C) 2004 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
******************************************************************************/
#ifndef INPUT_INTERFACE_H_INCLUDED
#define INPUT_INTERFACE_H_INCLUDED

#include <stdio.h>

#include <dinput.h>
#include "TypeDefs.h"


#define INPUT_NUM_BUTTON		16


enum InputType
{
//	INPUT_TYPE_KEYBOARD,
	INPUT_TYPE_JOYSTICK,
};

enum KeyType
{
	INPUT_JOYSTICK_BUTTON1  = 0x0001,
	INPUT_JOYSTICK_BUTTON2  = 0x0002,
	INPUT_JOYSTICK_BUTTON3  = 0x0004,
	INPUT_JOYSTICK_BUTTON4  = 0x0008,
	INPUT_JOYSTICK_BUTTON5  = 0x0010,
	INPUT_JOYSTICK_BUTTON6  = 0x0020,
	INPUT_JOYSTICK_BUTTON7  = 0x0040,
	INPUT_JOYSTICK_BUTTON8  = 0x0080,
	INPUT_JOYSTICK_BUTTON9  = 0x0100,
	INPUT_JOYSTICK_BUTTON10 = 0x0200,
	INPUT_JOYSTICK_BUTTON11 = 0x0400,
	INPUT_JOYSTICK_BUTTON12 = 0x0800,
	INPUT_JOYSTICK_UP       = 0x1000,
	INPUT_JOYSTICK_DOWN     = 0x2000,
	INPUT_JOYSTICK_LEFT     = 0x4000,
	INPUT_JOYSTICK_RIGHT    = 0x8000
};


BOOL	INPUT_Init(Sint32	inputType);
void	INPUT_Deinit();

void	INPUT_UpdateState();
void	INPUT_ClearState();

BOOL	INPUT_IsPressed(Sint32 joyID, Sint32 userButtonID);
BOOL	INPUT_IsTriggered(Sint32 userButtonID);
BOOL	INPUT_IsKeyPressed(Sint32 userKeyID);

BOOL	INPUT_ConnectButton(Sint32 joyID, Sint32 userButtonID, Sint32 inputButtonID);
BOOL	INPUT_ConnectKey(Sint32 userButtonID, Sint32 inputKeyID);

void	INPUT_Record(BOOL bRecord);
void	INPUT_Playback(BOOL bPlayback);

Sint32	INPUT_GetNumJoystick();

BOOL	INPUT_WriteBuffer(FILE*	fp);
BOOL	INPUT_ReadBuffer(FILE* fp);

#endif // INPUT_INTERFACE_H_INCLUDED

