/*-----------------------------------------------------------------------------
	[JoyPad.c]
		pbhLq܂B

	Copyright (C) 2004 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
**---------------------------------------------------------------------------*/
#include "JoyPad.h"
#include "InputInterface.h"
#include "MB128.h"
#include "Mouse.h"


static BOOL		_bHighNibble = FALSE;

static BOOL		_bSixButtonPad = FALSE;

static BOOL		_bMultiTap = TRUE;

static BOOL		_bPrevSEL = FALSE;
static BOOL		_bPrevCLR = FALSE;

static Uint32	_Counter = 0;


static
Uint8
read_two_button_pad()
{
	Uint8		ret = 0;

	if (_bPrevCLR)
	{
		return 0xf0 & ~0x40;
	}

	if (_Counter == 0)
		++_Counter;

	if (!_bMultiTap)
	{
		if (_Counter != 1)
			return 0xff & ~0x40;
	}

	if (_bHighNibble)
	{
		if (INPUT_IsPressed(_Counter-1, JOYPAD_BUTTON_UP))		ret |= 1;
		if (INPUT_IsPressed(_Counter-1, JOYPAD_BUTTON_RIGHT))	ret |= 2;
		if (INPUT_IsPressed(_Counter-1, JOYPAD_BUTTON_DOWN))	ret |= 4;
		if (INPUT_IsPressed(_Counter-1, JOYPAD_BUTTON_LEFT))	ret |= 8;
	}
	else
	{
		if (INPUT_IsPressed(_Counter-1, JOYPAD_BUTTON_I))		ret |= 1;
		if (INPUT_IsPressed(_Counter-1, JOYPAD_BUTTON_II))		ret |= 2;
		if (INPUT_IsPressed(_Counter-1, JOYPAD_BUTTON_SELECT))	ret |= 4;
		if (INPUT_IsPressed(_Counter-1, JOYPAD_BUTTON_RUN))		ret |= 8;
	}

	return ~ret & 0x0f;
}


static
Uint8
read_six_button_pad()
{
	static BOOL		bSecondByte = FALSE;
	Uint8			ret = 0;

	if (_bPrevCLR)
		return 0xf0 & ~0x40;

	if (_Counter == 0)
		++_Counter;

	if (!_bMultiTap)
	{
		if (_Counter != 1)
			return 0xff & ~0x40;
	}

	if (bSecondByte)
	{
		if (_bHighNibble)
		{
			ret = 1 | 2 | 4 | 8;
			bSecondByte = FALSE;
		}
		else
		{
			if (INPUT_IsPressed(_Counter-1, JOYPAD_BUTTON_I))		ret |= 1;
			if (INPUT_IsPressed(_Counter-1, JOYPAD_BUTTON_II))		ret |= 2;
			if (INPUT_IsPressed(_Counter-1, JOYPAD_BUTTON_SELECT))	ret |= 4;
			if (INPUT_IsPressed(_Counter-1, JOYPAD_BUTTON_RUN))		ret |= 8;
		}
		return ~ret & 0x0f;
	}

	if (_bHighNibble)
	{
		if (INPUT_IsPressed(_Counter-1, JOYPAD_BUTTON_UP))		ret |= 1;
		if (INPUT_IsPressed(_Counter-1, JOYPAD_BUTTON_RIGHT))	ret |= 2;
		if (INPUT_IsPressed(_Counter-1, JOYPAD_BUTTON_DOWN))	ret |= 4;
		if (INPUT_IsPressed(_Counter-1, JOYPAD_BUTTON_LEFT))	ret |= 8;
		bSecondByte = TRUE;
	}
	else
	{
		if (INPUT_IsPressed(_Counter-1, JOYPAD_BUTTON_III))		ret |= 1;
		if (INPUT_IsPressed(_Counter-1, JOYPAD_BUTTON_IV))		ret |= 2;
		if (INPUT_IsPressed(_Counter-1, JOYPAD_BUTTON_V))		ret |= 4;
		if (INPUT_IsPressed(_Counter-1, JOYPAD_BUTTON_VI))		ret |= 8;
	}

	return ~ret & 0x0f;
}



/*-----------------------------------------------------------------------------
	 
-----------------------------------------------------------------------------*/
Sint32
JOYPAD_Init()
{
	INPUT_Init(INPUT_TYPE_JOYSTICK);

	_bHighNibble = FALSE;
	_bSixButtonPad = FALSE;
	_bPrevSEL = FALSE;
	_bPrevCLR = FALSE;
	_Counter = 0;

	JOYPAD_ConnectMB128(TRUE);

	return 0;
}


void
JOYPAD_Deinit()
{
	INPUT_Deinit();
}


BOOL
JOYPAD_UseSixButton(
	BOOL	bSixButton)
{
	BOOL	b = _bSixButtonPad;
	_bSixButtonPad = bSixButton;
	return b;
}


BOOL
JOYPAD_ConnectMouse(
	BOOL	bConnect)
{
	BOOL	b = MOUSE_IsConnected();
	MOUSE_Connect(bConnect);
	return b;
}


BOOL
JOYPAD_ConnectMultiTap(
	BOOL	bConnect)
{
	BOOL	b = _bMultiTap;
	_bMultiTap = bConnect;
	return b;
}


BOOL
JOYPAD_ConnectMB128(
	BOOL	bConnect)
{
	BOOL	ret = MB128_IsConnected();
	MB128_Connect(bConnect);
	return ret;
}


/*	$1000 (R) status */
Uint8
JOYPAD_Read(
	Uint32		regNum)
{
	if (MB128_IsActive())
	{
		return MB128_Read();
	}

	if (MOUSE_IsConnected())
	{
		if (_Counter == 1 && _bPrevSEL)
		{
			return MOUSE_ReadDelta();
		}
		else
		{
			return MOUSE_ReadButtons();
		}
	}

	if (_bSixButtonPad)
		return read_six_button_pad();

	return read_two_button_pad();
}


/*	$1000 (W) select */
void
JOYPAD_Write(
	Uint32		regNum,
	Uint8		data)
{
	if (MB128_IsConnected())
	{
		MB128_Write(data);
	}

	/* ++counter on CLR=0, SEL = 1 */
	if ((data & 3) == 1)
	{
		++_Counter;
	}

	/* reset counter on SEL=1, CLR = 0-->1 */
	if ((data & 3) == 3 && !_bPrevCLR /*&& _bPrevSEL*/)
	{
		_Counter = 0;
		MOUSE_Reset();
	}

	_bHighNibble = data & 1;
	_bPrevCLR = (data >> 1) & 1;
	_bPrevSEL = data & 1;
}


BOOL
JOYPAD_ChangeButtonConnection(
	Sint32		padID,
	Sint32		pceButton,
	Sint32		appButton)
{
	return INPUT_ConnectButton(padID, pceButton, appButton);
}


// save variable
#define SAVE_V(V)	if (fwrite(&V, sizeof(V), 1, p) != 1)	return FALSE
#define LOAD_V(V)	if (fread(&V, sizeof(V), 1, p) != 1)	return FALSE
/*-----------------------------------------------------------------------------
	[SaveState]
		Ԃt@Cɕۑ܂B 
-----------------------------------------------------------------------------*/
BOOL
JOYPAD_SaveState(
	FILE*		p)
{
	if (p == NULL)
		return FALSE;

	SAVE_V(_bHighNibble);
	SAVE_V(_bSixButtonPad);
	SAVE_V(_bMultiTap);
	SAVE_V(_bPrevSEL);
	SAVE_V(_bPrevCLR);
	SAVE_V(_Counter);

	MOUSE_SaveState(p);

	return MB128_SaveState(p);
}


/*-----------------------------------------------------------------------------
	[LoadState]
		Ԃt@Cǂݍ݂܂B 
-----------------------------------------------------------------------------*/
BOOL
JOYPAD_LoadState(
	FILE*		p)
{
	if (p == NULL)
		return FALSE;

	LOAD_V(_bHighNibble);
	LOAD_V(_bSixButtonPad);
	LOAD_V(_bMultiTap);
	LOAD_V(_bPrevSEL);
	LOAD_V(_bPrevCLR);
	LOAD_V(_Counter);

	MOUSE_LoadState(p);

	return MB128_LoadState(p);
}

#undef SAVE_V
#undef LOAD_V
