#include <stdio.h>
#include "snes.h"

unsigned short objnamesel;
unsigned char window[3][256];
int wobjlog;
unsigned short ppufc;
int vlog=0;
unsigned short cgramw[256];
int bit16=0;
unsigned char mosaic;
int rescan[4];
unsigned short sobjaddr;
int curframe=0;
int bg1on,bg2on;
int fpsc;

int prioritybuffer[4][2];
/*Tile caching system*/
unsigned long tiless[4096][2][8][2];
unsigned long tiless16[4096][2][8][4];
unsigned long tilemask[4096][2][8][2];
unsigned long tilemask16[4096][2][8][4];
//unsigned long tiless4[2048][2][8][2];
//unsigned long tilemask4[2048][2][8][2];
char tiledatm[4096][8];
char tileupdate[4096];
//char tiledatm4[2048][8];
//char tileupdate4[2048];
int blanktile0=0;

void updatetiles()
{
        int c,y;
/*        for (c=0;c<2048;c++)
        {
                if (tileupdate4[c])
                {
                        for (y=0;y<8;y++)
                        {
                                tiless4[c][0][y][0]=ppu.bittable[0][ppu.vram[(c<<5)|(y<<1)]>>4]|(ppu.bittable[0][ppu.vram[(c<<5)|(y<<1)|1]>>4]<<1)|(ppu.bittable[0][ppu.vram[(c<<5)|(y<<1)|16]>>4]<<2)|(ppu.bittable[0][ppu.vram[(c<<5)|(y<<1)|17]>>4]<<3);
                                tiless4[c][0][y][1]=ppu.bittable[0][ppu.vram[(c<<5)|(y<<1)]&15]|(ppu.bittable[0][ppu.vram[(c<<5)|(y<<1)|1]&15]<<1)|(ppu.bittable[0][ppu.vram[(c<<5)|(y<<1)|16]&15]<<2)|(ppu.bittable[0][ppu.vram[(c<<5)|(y<<1)|17]&15]<<3);
                                tiless4[c][1][y][0]=ppu.bittable[1][ppu.vram[(c<<5)|(y<<1)]>>4]|(ppu.bittable[1][ppu.vram[(c<<5)|(y<<1)|1]>>4]<<1)|(ppu.bittable[1][ppu.vram[(c<<5)|(y<<1)|16]>>4]<<2)|(ppu.bittable[1][ppu.vram[(c<<5)|(y<<1)|17]>>4]<<3);
                                tiless4[c][1][y][1]=ppu.bittable[1][ppu.vram[(c<<5)|(y<<1)]&15]|(ppu.bittable[1][ppu.vram[(c<<5)|(y<<1)|1]&15]<<1)|(ppu.bittable[1][ppu.vram[(c<<5)|(y<<1)|16]&15]<<2)|(ppu.bittable[1][ppu.vram[(c<<5)|(y<<1)|17]&15]<<3);
                                tilemask4[c][0][y][0]=0;
                                if (tiless4[c][0][y][0]&0xFF) tilemask4[c][0][y][0]|=0xFF;
                                if (tiless4[c][0][y][0]&0xFF00) tilemask4[c][0][y][0]|=0xFF00;
                                if (tiless4[c][0][y][0]&0xFF0000) tilemask4[c][0][y][0]|=0xFF0000;
                                if (tiless4[c][0][y][0]&0xFF000000) tilemask4[c][0][y][0]|=0xFF000000;
                                tilemask4[c][0][y][1]=0;
                                if (tiless4[c][0][y][1]&0xFF) tilemask4[c][0][y][1]|=0xFF;
                                if (tiless4[c][0][y][1]&0xFF00) tilemask4[c][0][y][1]|=0xFF00;
                                if (tiless4[c][0][y][1]&0xFF0000) tilemask4[c][0][y][1]|=0xFF0000;
                                if (tiless4[c][0][y][1]&0xFF000000) tilemask4[c][0][y][1]|=0xFF000000;
                                tilemask4[c][1][y][0]=0;
                                if (tiless4[c][1][y][0]&0xFF) tilemask4[c][1][y][0]|=0xFF;
                                if (tiless4[c][1][y][0]&0xFF00) tilemask4[c][1][y][0]|=0xFF00;
                                if (tiless4[c][1][y][0]&0xFF0000) tilemask4[c][1][y][0]|=0xFF0000;
                                if (tiless4[c][1][y][0]&0xFF000000) tilemask4[c][1][y][0]|=0xFF000000;
                                tilemask4[c][1][y][1]=0;
                                if (tiless4[c][1][y][1]&0xFF) tilemask4[c][1][y][1]|=0xFF;
                                if (tiless4[c][1][y][1]&0xFF00) tilemask4[c][1][y][1]|=0xFF00;
                                if (tiless4[c][1][y][1]&0xFF0000) tilemask4[c][1][y][1]|=0xFF0000;
                                if (tiless4[c][1][y][1]&0xFF000000) tilemask4[c][1][y][1]|=0xFF000000;
                                if (tilemask4[c][0][y][0]|tilemask4[c][0][y][1]) tiledatm4[c][y]=1;
                                else                                             tiledatm4[c][y]=0;
                        }
                        tileupdate4[c]=0;
                }
        }*/
        for (c=0;c<4096;c++)
        {
                if (tileupdate[c])
                {
                        for (y=0;y<8;y++)
                        {
                                tiless[c][0][y][0]=ppu.bittable[0][ppu.vram[(c<<4)|(y<<1)]>>4]
                                                 |(ppu.bittable[0][ppu.vram[(c<<4)|(y<<1)|1]>>4]<<1);
                                tiless[c][0][y][1]=ppu.bittable[0][ppu.vram[(c<<4)|(y<<1)]&15]|(ppu.bittable[0][ppu.vram[(c<<4)|(y<<1)|1]&15]<<1);
                                tiless[c][1][y][0]=ppu.bittable[1][ppu.vram[(c<<4)|(y<<1)]>>4]|(ppu.bittable[1][ppu.vram[(c<<4)|(y<<1)|1]>>4]<<1);
                                tiless[c][1][y][1]=ppu.bittable[1][ppu.vram[(c<<4)|(y<<1)]&15]|(ppu.bittable[1][ppu.vram[(c<<4)|(y<<1)|1]&15]<<1);
                                tiless16[c][0][y][0]=(tiless[c][0][y][0]&0xFF)|((tiless[c][0][y][0]&0xFF00)<<8);
                                tiless16[c][0][y][1]=((tiless[c][0][y][0]&0xFF0000)>>16)|((tiless[c][0][y][0]&0xFF000000)>>8);
                                tiless16[c][0][y][2]=(tiless[c][0][y][1]&0xFF)|((tiless[c][0][y][1]&0xFF00)<<8);
                                tiless16[c][0][y][3]=((tiless[c][0][y][1]&0xFF0000)>>16)|((tiless[c][0][y][1]&0xFF000000)>>8);
                                tiless16[c][1][y][0]=(tiless[c][1][y][0]&0xFF)|((tiless[c][1][y][0]&0xFF00)<<8);
                                tiless16[c][1][y][1]=((tiless[c][1][y][0]&0xFF0000)>>16)|((tiless[c][1][y][0]&0xFF000000)>>8);
                                tiless16[c][1][y][2]=(tiless[c][1][y][1]&0xFF)|((tiless[c][1][y][1]&0xFF00)<<8);
                                tiless16[c][1][y][3]=((tiless[c][1][y][1]&0xFF0000)>>16)|((tiless[c][1][y][1]&0xFF000000)>>8);
                                tilemask[c][0][y][0]=0;
                                if (tiless[c][0][y][0]&0xFF) tilemask[c][0][y][0]|=0xFF;
                                if (tiless[c][0][y][0]&0xFF00) tilemask[c][0][y][0]|=0xFF00;
                                if (tiless[c][0][y][0]&0xFF0000) tilemask[c][0][y][0]|=0xFF0000;
                                if (tiless[c][0][y][0]&0xFF000000) tilemask[c][0][y][0]|=0xFF000000;
                                tilemask[c][0][y][1]=0;
                                if (tiless[c][0][y][1]&0xFF) tilemask[c][0][y][1]|=0xFF;
                                if (tiless[c][0][y][1]&0xFF00) tilemask[c][0][y][1]|=0xFF00;
                                if (tiless[c][0][y][1]&0xFF0000) tilemask[c][0][y][1]|=0xFF0000;
                                if (tiless[c][0][y][1]&0xFF000000) tilemask[c][0][y][1]|=0xFF000000;
                                tilemask[c][1][y][0]=0;
                                if (tiless[c][1][y][0]&0xFF) tilemask[c][1][y][0]|=0xFF;
                                if (tiless[c][1][y][0]&0xFF00) tilemask[c][1][y][0]|=0xFF00;
                                if (tiless[c][1][y][0]&0xFF0000) tilemask[c][1][y][0]|=0xFF0000;
                                if (tiless[c][1][y][0]&0xFF000000) tilemask[c][1][y][0]|=0xFF000000;
                                tilemask[c][1][y][1]=0;
                                if (tiless[c][1][y][1]&0xFF) tilemask[c][1][y][1]|=0xFF;
                                if (tiless[c][1][y][1]&0xFF00) tilemask[c][1][y][1]|=0xFF00;
                                if (tiless[c][1][y][1]&0xFF0000) tilemask[c][1][y][1]|=0xFF0000;
                                if (tiless[c][1][y][1]&0xFF000000) tilemask[c][1][y][1]|=0xFF000000;
                                tilemask16[c][0][y][0]=(tilemask[c][0][y][0]&0xFF)|((tilemask[c][0][y][0]&0xFF00)<<8);
                                tilemask16[c][0][y][1]=((tilemask[c][0][y][0]&0xFF0000)>>16)|((tilemask[c][0][y][0]&0xFF000000)>>8);
                                tilemask16[c][0][y][2]=(tilemask[c][0][y][1]&0xFF)|((tilemask[c][0][y][1]&0xFF00)<<8);
                                tilemask16[c][0][y][3]=((tilemask[c][0][y][1]&0xFF0000)>>16)|((tilemask[c][0][y][1]&0xFF000000)>>8);
                                tilemask16[c][1][y][0]=(tilemask[c][1][y][0]&0xFF)|((tilemask[c][1][y][0]&0xFF00)<<8);
                                tilemask16[c][1][y][1]=((tilemask[c][1][y][0]&0xFF0000)>>16)|((tilemask[c][1][y][0]&0xFF000000)>>8);
                                tilemask16[c][1][y][2]=(tilemask[c][1][y][1]&0xFF)|((tilemask[c][1][y][1]&0xFF00)<<8);
                                tilemask16[c][1][y][3]=((tilemask[c][1][y][1]&0xFF0000)>>16)|((tilemask[c][1][y][1]&0xFF000000)>>8);
                                tilemask16[c][0][y][0]|=(tilemask16[c][0][y][0]<<8);
                                tilemask16[c][0][y][1]|=(tilemask16[c][0][y][1]<<8);
                                tilemask16[c][0][y][2]|=(tilemask16[c][0][y][2]<<8);
                                tilemask16[c][0][y][3]|=(tilemask16[c][0][y][3]<<8);
                                tilemask16[c][1][y][0]|=(tilemask16[c][1][y][0]<<8);
                                tilemask16[c][1][y][1]|=(tilemask16[c][1][y][1]<<8);
                                tilemask16[c][1][y][2]|=(tilemask16[c][1][y][2]<<8);
                                tilemask16[c][1][y][3]|=(tilemask16[c][1][y][3]<<8);
                                if (tilemask[c][0][y][0]|tilemask[c][0][y][1]) tiledatm[c][y]=1;
                                else                                           tiledatm[c][y]=0;
                        }
                        tileupdate[c]=0;
                }
        }
}

int vidout=0;
int sblankchk;
int spcemu,palf,soundupdate;
unsigned char *ram;
int lastsetzf=1;
int xmode[4],ymode[4],xsize[4],bgdat[4];
BITMAP *dasbuffer;
unsigned long matrixr;
unsigned short m7a,m7b;
int objsize[4]={1,1,2,2};
int objsizes[16][2]={ {1,1}, {2,2}, {1,1}, {4,4}, {1,1}, {8,8}, {2,2}, {4,4}, {2,2}, {8,8}, {4,4}, {8,8} };

struct
{
        int x[128],y[128],xs[128],ys[128];
        int hf[128],vf[128],p[128],sx[128],sy[128];
        unsigned short t[128];
        unsigned long c[128];
} sprites;

unsigned long hmostable[256];
unsigned char fliptable[256];

unsigned short m7a,m7b,m7c,m7d,m7x,m7y;
unsigned char m7sel;
int m7write;

void dumpvram()
{
        int c;
        FILE *f=fopen("vram.dmp","wb");
        fwrite(ppu.vram,65536,1,f);
        fclose(f);
        f=fopen("window.dmp","wb");
        fwrite(window,768,1,f);
        fclose(f);
        f=fopen("objram.dmp","wb");
        fwrite(ppu.vram,544,1,f);
        fclose(f);
        f=fopen("cgramw.dmp","wb");
        fwrite(cgramw,512,1,f);
        fclose(f);
        save_pcx("temp.pcx",ppu.b,ppu.pal);
        printf("HDMA enable : %02X\n",hdmaena);
        for (c=0;c<8;c++)
        {
                printf("HDMA %i : ctrl %02X src %02X:%04X dest %02X ibank %02X\n",c,dma.ctrl[c],dma.srcbank[c],dma.src[c],dma.dest[c],hdma.ibank[c]);
        }
        printf("Vinc %i %i\n",ppu.vinc,ppu.vidportc&3);
        printf("Mainena %i Subena %i\n",ppu.main,ppu.sub);
        printf("CGWSEL %02X CGADSUB %02X fixedcol %02X\n",ppu.cgwsel,ppu.cgadsub,ppu.fixedcol);
//        printf("BG1 addr=%04X\n",ppu.bg[0]);
//        for (c=0;c<128;c++)
//        {
//                printf("%i : %03X %03X %04X %08X\n",c,sprites.x[c],sprites.y[c],sprites.t[c],sprites.c[c]);
//        }
//        for (c=0;c<8;c++) printf("col %i %08X\n",c,ppu.coltable[c]);
}

void initppu()
{
        ppu.vram=(unsigned char *)malloc(65536);
        ppu.vramw=(unsigned short *)ppu.vram;
        memset(ppu.vram,0,65536);
        memset(objram,0,1024);
        memset(&sprites,0,sizeof(sprites));
//        atexit(dumpvram);
        if (bit16) set_color_depth(16);
        set_gfx_mode(GFX_VESA2L,400,300,0,0);
        set_palette(desktop_palette);
        ppu.b=create_bitmap(288,256);
        ppu.s=create_bitmap(288,256);
        if (!ppu.b)
        {
                printf("Bitmap failed\n");
                exit(-1);
        }
        maketables();
        dasbuffer=create_bitmap(256,256);
}

void resetppu()
{
        memset(ppu.vram,0,65536);
        memset(objram,0,1024);
        memset(&sprites,0,sizeof(sprites));
}

void maketables()
{
        int c;
        for (c=0;c<16;c++)
        {
                ppu.bittable[0][c]=0;
                if (c&0x8) ppu.bittable[0][c]|=0x00000001;
                if (c&0x4) ppu.bittable[0][c]|=0x00000100;
                if (c&0x2) ppu.bittable[0][c]|=0x00010000;
                if (c&0x1) ppu.bittable[0][c]|=0x01000000;
                ppu.bittable[1][c]=0;
                if (c&0x1) ppu.bittable[1][c]|=0x00000001;
                if (c&0x2) ppu.bittable[1][c]|=0x00000100;
                if (c&0x4) ppu.bittable[1][c]|=0x00010000;
                if (c&0x8) ppu.bittable[1][c]|=0x01000000;
                ppu.masktable[0][c]=0;
                if (c&0x8) ppu.masktable[0][c]|=0x000000FF;
                if (c&0x4) ppu.masktable[0][c]|=0x0000FF00;
                if (c&0x2) ppu.masktable[0][c]|=0x00FF0000;
                if (c&0x1) ppu.masktable[0][c]|=0xFF000000;
                ppu.masktable[1][c]=0;
                if (c&0x1) ppu.masktable[1][c]|=0x000000FF;
                if (c&0x2) ppu.masktable[1][c]|=0x0000FF00;
                if (c&0x4) ppu.masktable[1][c]|=0x00FF0000;
                if (c&0x8) ppu.masktable[1][c]|=0xFF000000;
        }
        for (c=0;c<256;c++)
        {
                fliptable[c]=0;
                if (c&0x01) fliptable[c]|=0x80;
                if (c&0x02) fliptable[c]|=0x40;
                if (c&0x04) fliptable[c]|=0x20;
                if (c&0x08) fliptable[c]|=0x10;
                if (c&0x10) fliptable[c]|=0x08;
                if (c&0x20) fliptable[c]|=0x04;
                if (c&0x40) fliptable[c]|=0x02;
                if (c&0x80) fliptable[c]|=0x01;
        }
        ppu.coltable[0]=0;
        ppu.coltable[1]=0x01010101;
        ppu.coltable[2]=0x02020202;
        ppu.coltable[3]=0x03030303;
        ppu.coltable[4]=0x04040404;
        ppu.coltable[5]=0x05050505;
        ppu.coltable[6]=0x06060606;
        ppu.coltable[7]=0x07070707;
        ppu.coltable16[0]=0;
        ppu.coltable16[1]=0x00010001;
        ppu.coltable16[2]=0x00020002;
        ppu.coltable16[3]=0x00030003;
        ppu.coltable16[4]=0x00040004;
        ppu.coltable16[5]=0x00050005;
        ppu.coltable16[6]=0x00060006;
        ppu.coltable16[7]=0x00070007;
        for (c=0;c<256;c++) hmostable[c]=c|(c<<8)|(c<<16)|(c<<24);
//        for (c=0;c<8;c++) printf("col %08X\n",ppu.coltable[c]);
}
int ins;
void dumpppuregs()
{
        printf("PPU regs :\n");
        printf("BG  : %04X %04X %04X %04X\n",ppu.bg[0],ppu.bg[1],ppu.bg[2],ppu.bg[3]);
        printf("CHR : %04X %04X %04X %04X\n",ppu.chr[0],ppu.chr[1],ppu.chr[2],ppu.chr[3]);
}

void writeppu(unsigned short addr, unsigned char val)
{
        unsigned short tempw,tempw2;
        int c,s;
        unsigned short baddr;
//        if (curline==32) printf("Writing to %04X %02X line 32\n",addr,val);
        switch (addr)
        {
                case 0x2100: /*Screen Display Register*/
                ppu.sdr=val;
//                printf("SDR %02X at line %i\n",val,curline);
//                if (val&0x80) ppu.sdr=0;
                return;
                case 0x2101: /*Sprite Size Register*/
//                printf("Name select %i\n",(val>>3)&3);
                sprchraddr=(val&3)<<14;
                objnamesel=((val>>3)&3)<<13;
                val>>=5;
                val<<=1;
                objsize[0]=objsizes[val][0];
                objsize[1]=objsizes[val][1];
                objsize[2]=objsizes[val+1][0];
                objsize[3]=objsizes[val+1][1];
                return;
                case 0x2102:
                objaddr&=0x100;
                objaddr|=val;
//                printf("OBJ addr now %03X\n",objaddr<<1);
                sobjaddr=objaddr;
                return;
                case 0x2103:
                if (val&1)
                   objaddr|=0x100;
                else
                   objaddr&=0xFE;
//                printf("OBJ addr now %03X\n",objaddr<<1);
                firstobjwrite=1;
                sobjaddr=objaddr;
                return;
                case 0x2104:
//                printf("OBJ write %03X %02X line %i frame %i\n",objaddr<<1,val,curline,curframe);
                if (objaddr>0x10F) { objaddr=0; firstobjwrite=1; }
//                if (firstobjwrite  && ((objaddr<<1)==0)) printf("OBJ write 0 %02X %02X:%04X %04X %04X\n",val,pbr,pc,x.w,dp);
//                printf("OBJ %04X write %02X %02X:%04X %02X %02X\n",(objaddr<<1)+firstobjwrite,val,pbr,pc,dma.ctrl[0],y.b.l);
                if (firstobjwrite)
                   objram[objaddr<<1]=val;
                else
                {
                        objram[(objaddr<<1)+1]=val;
                        objaddr++;
                }
                firstobjwrite^=1;
                return;
                case 0x2105: /*Screen Mode Register*/
                ppu.mode=val;
//                printf("mode %02X at line %i\n",val,curline);
                vlog=1;
                return;
                case 0x2106: /*Mosaic*/
                mosaic=val;
//                printf("mosaic %02X at line %i\n",val,curline);
                return;
                case 0x2107: /*BG1 Address*/
//                printf("2107 write %02X\n",val);
                addr=ppu.bg[0];
                ppu.bg[0]=(val&0xFC)<<9;
                bgdat[0]=val&3;
                xsize[0]=val&1;
                ymode[0]=(val&2)>>1;
                if (addr==ppu.bg[0]) return;
                rescan[0]=1;
/*                switch (val&3)
                {
                        case 0: s=1024; break;
                        case 1: case 2: s=2048; break;
                        case 3: s=4096; break;
                }
                baddr=ppu.bg[0]>>1;
                prioritybuffer[0][0]=prioritybuffer[0][1]=0;
                for (c=0;c<s;c++)
                {
                        if (ppu.vramw[baddr]&0x2000) prioritybuffer[0][1]=1;
                        else                         prioritybuffer[0][0]=1;
                        if (prioritybuffer[0][0] && prioritybuffer[0][1]) return;
                        baddr++;
                }*/
//                printf("BG1 addr=%04X size %i %i %02X\n",ppu.bg[0],xsize[0],ymode[0],bgdat[1]);
                return;
                case 0x2108: /*BG2 Address*/
//                printf("2108 write %02X\n",val);
                addr=ppu.bg[1];
                ppu.bg[1]=(val&0xFC)<<9;
                bgdat[1]=val&3;
                xsize[1]=val&1;
                ymode[1]=(val&2)>>1;
                if (addr==ppu.bg[1]) return;
                rescan[1]=1;
/*                switch (val&3)
                {
                        case 0: s=1024; break;
                        case 1: case 2: s=2048; break;
                        case 3: s=4096; break;
                }
                baddr=ppu.bg[1]>>1;
                prioritybuffer[1][0]=prioritybuffer[1][1]=0;
                for (c=0;c<s;c++)
                {
                        if (ppu.vramw[baddr]&0x2000) prioritybuffer[1][1]=1;
                        else                         prioritybuffer[1][0]=1;
                        if (prioritybuffer[1][0] && prioritybuffer[1][1]) return;
                        baddr++;
                }*/
                return;
                case 0x2109: /*BG3 Address*/
//                printf("2109 write %02X\n",val);
                addr=ppu.bg[2];
                ppu.bg[2]=(val&0xFC)<<9;
                bgdat[2]=val&3;
                xsize[2]=val&1;
                ymode[2]=(val&2)>>1;
                if (addr==ppu.bg[2]) return;
                rescan[2]=1;
/*                switch (val&3)
                {
                        case 0: s=1024; break;
                        case 1: case 2: s=2048; break;
                        case 3: s=4096; break;
                }
                baddr=ppu.bg[2]>>1;
                prioritybuffer[2][0]=prioritybuffer[2][1]=0;
                for (c=0;c<s;c++)
                {
                        if (ppu.vramw[baddr]&0x2000) prioritybuffer[2][1]=1;
                        else                         prioritybuffer[2][0]=1;
                        if (prioritybuffer[2][0] && prioritybuffer[2][1]) return;
                        baddr++;
                }*/
//                printf("BG3 addr=%04X\n",ppu.bg[2]);
                return;
                case 0x210A: /*BG4 Address*/
                addr=ppu.bg[3];
                ppu.bg[3]=(val&0xFC)<<9;
                bgdat[3]=val&3;
                xsize[3]=val&1;
                ymode[3]=(val&2)>>1;
                if (addr==ppu.bg[3]) return;
                rescan[3]=1;
/*                switch (val&3)
                {
                        case 0: s=1024; break;
                        case 1: case 2: s=2048; break;
                        case 3: s=4096; break;
                }
                baddr=ppu.bg[3]>>1;
                prioritybuffer[3][0]=prioritybuffer[3][1]=0;
                for (c=0;c<s;c++)
                {
                        if (ppu.vramw[baddr]&0x2000) prioritybuffer[3][1]=1;
                        else                         prioritybuffer[3][0]=1;
                        if (prioritybuffer[3][0] && prioritybuffer[3][1]) return;
                        baddr++;
                }*/
                return;
                case 0x210B: /*BG1+2 CHR Address*/
                ppu.chr[0]=(val&0xF)<<13;
                ppu.chr[1]=(val>>4)<<13;
//                printf("CHR 0 %04X 1 %04X %02X %04X\n",ppu.chr[0],ppu.chr[1],val,pc);
                return;
                case 0x210C: /*BG2+3 CHR Address*/
                ppu.chr[2]=(val&0xF)<<13;
                ppu.chr[3]=(val>>4)<<13;                
                return;
                case 0x210D: /*BG1 Horizontal Scroll*/
                ppu.xs[0]>>=8;
                ppu.xs[0]|=(val<<8);
                return;
                case 0x210E: /*BG1 Vertical Scroll*/
                ppu.ys[0]>>=8;
                ppu.ys[0]|=(val<<8);
//                printf("BG1 vscroll %04X %04X\n",ppu.ys[0],pc);
                return;
                case 0x210F: /*BG2 Horizontal Scroll*/
                ppu.xs[1]>>=8;
                ppu.xs[1]|=(val<<8);
                return;
                case 0x2110: /*BG2 Vertical Scroll*/
                ppu.ys[1]>>=8;
                ppu.ys[1]|=(val<<8);
                return;
                case 0x2111: /*BG3 Horizontal Scroll*/
                ppu.xs[2]>>=8;
                ppu.xs[2]|=(val<<8);
                return;
                case 0x2112: /*BG3 Vertical Scroll*/
                ppu.ys[2]>>=8;
                ppu.ys[2]|=(val<<8);
                return;
                case 0x2113: /*BG4 Horizontal Scroll*/
                ppu.xs[3]>>=8;
                ppu.xs[3]|=(val<<8);
                return;
                case 0x2114: /*BG4 Vertical Scroll*/
                ppu.ys[3]>>=8;
                ppu.ys[3]|=(val<<8);
                return;
                case 0x2115: /*Video Port Control*/
                ppu.vidportc=val;
//                printf("Vidportc %02X\n",val);
                switch (ppu.vidportc&3)
                {
                        case 0: ppu.vinc=1; break;
                        case 1: ppu.vinc=32; break;
                        case 2: case 3: ppu.vinc=128; break;
                }
                switch (ppu.vidportc&0xC)
                {
                        case 0: ppu.fgcount=0; break;
                        case 4: ppu.fgcount=0x20; ppu.fgmask=0xFF; ppu.fgshift=5; break;
                        case 8: ppu.fgcount=0x40; ppu.fgmask=0x1FF; ppu.fgshift=6; break;
                        case 12: ppu.fgcount=0x80; ppu.fgmask=0x3FF; ppu.fgshift=7; break;
                }
                return;
                case 0x2116: /*Video Addr Low*/
                ppu.firstread=1;
                ppu.vaddr=(ppu.vaddr&0x7F00)|val;
                return;
                case 0x2117: /*Video Addr High*/
                ppu.firstread=1;
                ppu.vaddr=(ppu.vaddr&0xFF)|((val&0x7F)<<8);
//                printf("Video addr %04X\n",ppu.vaddr<<1);
                return;
                case 0x2118: /*Video Data Low*/
                ppu.firstread=1;
                if (ppu.fgcount)
                {
                        tempw=ppu.vaddr&ppu.fgmask;
                        tempw2=(ppu.vaddr&~ppu.fgmask)+(tempw>>ppu.fgshift)+((tempw&(ppu.fgcount-1))<<3);
                        ppu.vram[(tempw2&0x7FFF)<<1]=val;
                        tileupdate[(tempw2&0x7FFF)>>3]=1;
                }
                else
                {
                        ppu.vram[(ppu.vaddr&0x7FFF)<<1]=val;
                        tileupdate[(ppu.vaddr&0x7FFF)>>3]=1;
                }
                if (!(ppu.vidportc&0x80)) ppu.vaddr+=ppu.vinc;
                return;
                case 0x2119: /*Video Data High*/
                ppu.firstread=1;
                if (ppu.fgcount)
                {
                        tempw=ppu.vaddr&ppu.fgmask;
                        tempw2=(ppu.vaddr&~ppu.fgmask)+(tempw>>ppu.fgshift)+((tempw&(ppu.fgcount-1))<<3)+1;
                        ppu.vram[(tempw2&0x7FFF)<<1]=val;
                        tileupdate[(tempw2&0x7FFF)>>3]=1;
                }
                else
                {
                        ppu.vram[((ppu.vaddr&0x7FFF)<<1)+1]=val;
                        tileupdate[(ppu.vaddr&0x7FFF)>>3]=1;
                        tempw2=ppu.vaddr;
                }
                if (((tempw2<<1)&0xF000)==ppu.bg[0]) rescan[0]=1;
                if (((tempw2<<1)&0xF000)==ppu.bg[1]) rescan[1]=1;
                if (((tempw2<<1)&0xF000)==ppu.bg[2]) rescan[2]=1;
                if (((tempw2<<1)&0xF000)==ppu.bg[3]) rescan[3]=1;
                if (ppu.vidportc&0x80) ppu.vaddr+=ppu.vinc;
//                tileupdate[(ppu.vaddr&0x7FFF)>>3]=1;
//                tileupdate4[(ppu.vaddr&0x7FFF)>>4]=1;
                return;
                case 0x211A:
                m7sel=val;
//                printf("M7 sel %02X\n",val);
                return;
                case 0x211B:
                m7a=(m7a>>8)|(val<<8);
                matrixr=(short)m7a*((short)m7b>>8);
//                printf("M7A write %02X at line %i\n",val,curline);
                return;
                case 0x211C:
                m7b=(m7b>>8)|(val<<8);
                matrixr=(short)m7a*((short)m7b>>8);
//                printf("M7B write %02X at line %i\n",val,curline);
                m7write=1;
                return;
                case 0x211D:
                m7c=(m7c>>8)|(val<<8);
//                printf("M7C write %02X at line %i\n",val,curline);
                return;
                case 0x211E:
                m7d=(m7d>>8)|(val<<8);
//                printf("M7D write %02X at line %i\n",val,curline);
//                m7write=1;
                return;
                case 0x211F:
                m7x=(m7x>>8)|(val<<8);
                return;
                case 0x2120:
                m7y=(m7y>>8)|(val<<8);
                return;
                case 0x2121: /*Colour Selection Register*/
                ppu.cgramaddr=val<<1;
//                printf("CGRAM addr %02X %04X %04X\n",val,ppu.cgramaddr,pc);
                return;
                case 0x2122: /*Colour Data Register*/
//                printf("CGRAM %04X write %02X\n",ppu.cgramaddr,val);
                ppu.cgram[ppu.cgramaddr&0x1FF]=val;
                tempw=ppu.cgram[ppu.cgramaddr&0x1FE]|(ppu.cgram[(ppu.cgramaddr&0x1FE)+1]<<8);
                ppu.pal[ppu.cgramaddr>>1].r=(tempw&31)<<1;
                ppu.pal[ppu.cgramaddr>>1].g=((tempw>>5)&31)<<1;
                ppu.pal[ppu.cgramaddr>>1].b=((tempw>>10)&31)<<1;
                cgramw[ppu.cgramaddr>>1]=(ppu.pal[ppu.cgramaddr>>1].b>>1)|
                                         (ppu.pal[ppu.cgramaddr>>1].g<<5)|
                                         (ppu.pal[ppu.cgramaddr>>1].r<<10);
//                ppu.paldirty[ppu.cgramaddr>>1]=1;
//                set_palette(ppu.pal);
                ppu.cgramaddr++;
                return;
                case 0x2125: /*Colour window settings*/
                ppu.wobjsel=val;
//                printf("2125 write %02X\n",val);
                return;
                case 0x2126: /*Window regs*/
                ppu.w1l=val;
//                printf("2126 write %02X\n",val);
                return;
                case 0x2127:
                ppu.w1r=val;
//                printf("2127 write %02X\n",val);
                return;
                case 0x2128:
                ppu.w2l=val;
//                printf("2128 write %02X\n",val);
                return;
                case 0x2129:
                ppu.w2r=val;
//                printf("2129 write %02X\n",val);
                return;
                case 0x212B: /*Mask logic for colour window*/
                wobjlog=val;
//                printf("WOBJLOG %02X\n",val);
                return;
                case 0x212C: /*Main Screen*/
                ppu.main=val;
//                printf("Main screen %02X %02X:%04X\n",val,pbr,pc);
                return;
                case 0x212D: /*Sub Screen*/
                ppu.sub=val;
//                printf("Sub screen %02X %02X:%04X\n",val,pbr,pc);
//                printf("Sub screen %02X\n",val);
                return;
                case 0x2130: /*Fixed colour addition*/
                ppu.cgwsel=val;
//                printf("2130 write %02X line %i\n",val,curline);
                return;
                case 0x2131: /*Addition/Subtraction*/
                ppu.cgadsub=val;
//                printf("2131 write %02X line %i\n",val,curline);
                return;
                case 0x2132: /*Fixed colour data*/
                ppu.fixedcol=val;
                ppufc=0;
                if (val&0x20) ppufc|=(val&0x1F);
                if (val&0x40) ppufc|=((val&0x1F)<<6);
                if (val&0x80) ppufc|=((val&0x1F)<<11);
//                printf("2132 write %02X line %i %02X:%04X\n",val,curline,pbr,pc);
                return;
                case 0x2140: case 0x2141: case 0x2142: case 0x2143:
                case 0x2144: case 0x2145: case 0x2146: case 0x2147:
//                if ((pc>0x9615)&&(pc<0x963F)) printf("Write %04X %02X\n",addr,val);
                if (spcemu) write214x(addr&0x2143,val);
                else        setzf=0;
                return;
                case 0x2180: /*VRAM write*/
//                if ((ppu.wramaddr)==0) printf("0 write %02X at %02X:%04X\n",val,pbr,pc);
                ram[ppu.wramaddr]=val;
                ppu.wramaddr=(ppu.wramaddr+1)&0x1FFFF;
                return;
                case 0x2181: /*VRAM addr low*/
                ppu.wramaddr=(ppu.wramaddr&0x1FF00)|val;
                return;
                case 0x2182: /*VRAM addr mid*/
                ppu.wramaddr=(ppu.wramaddr&0x100FF)|(val<<8);
                return;
                case 0x2183: /*VRAM addr high*/
                ppu.wramaddr=(ppu.wramaddr&0xFFFF)|((val&1)<<16);
                return;
        }
//        printf("Bad PPU write %04X %02X\n",addr,val);
/*        dumpregs();
        exit(-1);*/
}

unsigned char *ram;

int skip=0;

unsigned char doskipper()
{
        int temp=skip;
        skip++;
        if (skip==19) skip=0;
//        skip&=3;
//        if (!(&1)) skip&=~1;
//        else        skip|=1;
//        printf("Skipper %i %i  ",temp,temp>>1);
        switch (temp>>1)
        {
                case 0:
                case 1:
                setzf=2;
                return 0;
                case 2:
                if (temp&1) return a.b.h;
                else        return a.b.l;
                break;
                case 3:
                if (temp&1) return x.b.h;
                else        return x.b.l;
                break;
                case 4:
                if (temp&1) return y.b.h;
                else        return y.b.l;
                break;
                case 5:
                if (temp&1) return 0xBB;
                else        return 0xAA;
                break;
                case 6:
                setzf=2;
                return 0;
                case 7:
                if (temp&1) return 0xBB;
                else        return 0xAA;
                break;
                case 8:
                if (temp&1) return 0x33;
                else        return 0x33;
                break;
                case 9:
                return 0;
        }
        printf("Shouldn't have got here\n");
        exit(-1);
}

inline unsigned short getareg() { return a.w; }

unsigned short vlatch;

unsigned char readppu(unsigned short a)
{
        unsigned char temp;
        unsigned long templ;
        if (a>0x21FF) return 0x21;
        switch (a)
        {
                case 0x2134:
                return matrixr;
                case 0x2135:
                return matrixr>>8;
                case 0x2136:
                return matrixr>>16;
                case 0x2137: /*Latch*/
                vlatch=curline;
//                printf("VLATCH %i %02X %02X:%04X\n",vlatch,vlatch,pbr,pc);
                return 0xFF;
                case 0x2139: /*VRAM Read Low*/
                if (ppu.firstread)
                {
                        ppu.firstread=0;
                        return ppu.vram[(ppu.vaddr<<1)&0xFFFF];
                }
                temp=ppu.vram[((ppu.vaddr<<1)-2)&0xFFFF];
//                printf("Read 2139 vinc %i %i\n",ppu.vinc,ppu.vidportc&3);
                if (!(ppu.vidportc&0x80))
                   ppu.vaddr+=ppu.vinc;
                return temp;
                case 0x213A: /*VRAM Read High*/
                if (ppu.firstread)
                {
                        ppu.firstread=0;
                        return ppu.vram[((ppu.vaddr<<1)+1)&0xFFFF];
                }
                temp=ppu.vram[((ppu.vaddr<<1)-1)&0xFFFF];
//                printf("Read 213A vinc %i %i\n",ppu.vinc,ppu.vidportc&3);
                if (ppu.vidportc&0x80)
                   ppu.vaddr+=ppu.vinc;
                return temp;
                
                case 0x213D: /*Vertical counter*/
                temp=vlatch&0xFF;
                vlatch>>=8;
                return temp;
                case 0x213E: /*PPU time/range flags*/
//                printf("Read 213E %02X:%04X\n",pbr,pc);
                return 0;
                //S=1FEE
                case 0x213F:
                if (palf) return 0x10;
                return 0x00; /*NTSC*/ ///*PAL*/
                
                case 0x2140: case 0x2141: case 0x2142: case 0x2143:  /*SPC*/
                case 0x2144: case 0x2145: case 0x2146: case 0x2147:
                if (spcemu) return read214x(a&0x2143);
                
                temp=doskipper();
//                printf("%02X  %02X:%04X  %04X\n",temp,pbr,pc,a);
                return temp;
                
                case 0x2180: /*WRAM read*/
                temp=ram[ppu.wramaddr];
                ppu.wramaddr=(ppu.wramaddr+1)&0x1FFFF;
                return temp;
                case 0x2181: /*WRAM addr low*/
                return ppu.wramaddr;
                case 0x2182: /*WRAM addr mid*/
                return ppu.wramaddr>>8;
                case 0x2183: /*WRAM addr high*/
                return ppu.wramaddr>>16;
                
                default:
//                return 0;
//                printf("Bad PPU read %04X %02X:%04X %i\n",a,pbr,pc,stage);
                return 0;
//                dumpregs();
//                exit(-1);
        }
}

void vblankhdma()
{
        int c;
        for (c=0;c<8;c++)
        {
                hdma.hdmaon[c]=1;
                hdma.hdmacount[c]=0;
                hdma.srcbank[c]=dma.srcbank[c];
                hdma.src[c]=dma.src[c];
        }
}

static inline unsigned char readf(unsigned char b, unsigned short a)
{
        if (mempointv[b][a>>13])
           return mempoint[b][a>>13][a&0x1FFF];
        else
           return 0;
}

void doline(int line)
{
        int c;
        unsigned char mask=1;
//        printf("HDMA on\n");
        for (c=0;c<8;c++)
        {
                if (hdmaena&mask && hdma.hdmaon[c])
                {
                        if (!hdma.hdmacount[c])
                        {
                                stage=162;
                                hdma.hdmacount[c]=readf(hdma.srcbank[c],hdma.src[c]); hdma.src[c]++;
                                if (!hdma.hdmacount[c])
                                {
                                        hdma.hdmaon[c]=0;
                                        goto skiphdma;
                                }
                                if (hdma.hdmacount[c]&0x80)
                                {
                                        hdma.hdmacount[c]&=0x7F;
                                        hdma.repeat[c]=1;
                                }
                                else
                                   hdma.repeat[c]=0;
//                                if (dma.dest[c]==0xD) printf("210D write line %03i src %02X:%04X ctrl %02X count %i\n",line,hdma.srcbank[c],hdma.src[c],dma.ctrl[c],hdma.hdmacount[c]);
                                if (dma.ctrl[c]&0x40)
                                {
                                        hdma.ta[c]=readf(hdma.srcbank[c],hdma.src[c])|(readf(hdma.srcbank[c],hdma.src[c]+1)<<8); hdma.src[c]+=2;
                                        switch (dma.ctrl[c]&7)
                                        {
                                                case 0: /*One reg write once*/
                                                hdma.hdmaval[c]=readf(hdma.ibank[c],hdma.ta[c]); hdma.ta[c]++;
                                                break;
                                                case 1: /*Two regs write once*/
                                                hdma.hdmaval[c]=readf(hdma.ibank[c],hdma.ta[c])|(readf(hdma.ibank[c],hdma.ta[c]+1)<<8); hdma.ta[c]+=2;
                                                break;
                                                case 2: /*One reg write twice*/
                                                hdma.hdmaval[c]=readf(hdma.ibank[c],hdma.ta[c])|(readf(hdma.ibank[c],hdma.ta[c]+1)<<8); hdma.ta[c]+=2;
                                                break;
                                                case 3: /*Two regs write twice*/
                                                hdma.hdmaval[c]=readf(hdma.ibank[c],hdma.ta[c])|(readf(hdma.ibank[c],hdma.ta[c]+1)<<8)|(readf(hdma.ibank[c],hdma.ta[c]+2)<<16)|(readf(hdma.ibank[c],hdma.ta[c]+3)<<24); hdma.ta[c]+=4;
                                                break;
                                                case 4: /*Four regs write once*/
                                                hdma.hdmaval[c]=readf(hdma.ibank[c],hdma.ta[c])|(readf(hdma.ibank[c],hdma.ta[c]+1)<<8)|(readf(hdma.ibank[c],hdma.ta[c]+2)<<16)|(readf(hdma.ibank[c],hdma.ta[c]+3)<<24); hdma.ta[c]+=4;
                                                break;

                                                default:
                                                printf("Bad HDMA indirect mode %i  count %i dest %02X  data %02X:%04X\n",dma.ctrl[c]&7,hdma.hdmacount[c],dma.dest[c],hdma.ibank[c],hdma.ta[c]);
                                                dumpregs();
                                                exit(-1);
                                        }
                                }
                                else
                                {
                                        switch (dma.ctrl[c]&7)
                                        {
                                                case 0: /*One reg write once*/
                                                stage=160;
                                                hdma.hdmaval[c]=readf(hdma.srcbank[c],hdma.src[c]); hdma.src[c]++;
                                                stage=161;
                                                break;
                                                case 1: /*Two regs write once*/
                                                stage=160;
                                                hdma.hdmaval[c]=readf(hdma.srcbank[c],hdma.src[c])|(readf(hdma.srcbank[c],hdma.src[c]+1)<<8); hdma.src[c]+=2;
                                                stage=161;
                                                break;
                                                case 2: /*One reg write twice*/
                                                stage=160;
                                                hdma.hdmaval[c]=readf(hdma.srcbank[c],hdma.src[c])|(readf(hdma.srcbank[c],hdma.src[c]+1)<<8); hdma.src[c]+=2;
                                                stage=161;
                                                break;
                                                case 3: /*Two regs write twice*/
                                                stage=160;
                                                hdma.hdmaval[c]=readf(hdma.srcbank[c],hdma.src[c])|(readf(hdma.srcbank[c],hdma.src[c]+1)<<8)|(readf(hdma.srcbank[c],hdma.src[c]+2)<<16)|(readf(hdma.srcbank[c],hdma.src[c]+3)<<24); hdma.src[c]+=4;
                                                stage=161;
                                                break;
                                                case 4: /*Four regs*/
                                                stage=160;
                                                hdma.hdmaval[c]=readf(hdma.srcbank[c],hdma.src[c])|(readf(hdma.srcbank[c],hdma.src[c]+1)<<8)|(readf(hdma.srcbank[c],hdma.src[c]+2)<<16)|(readf(hdma.srcbank[c],hdma.src[c]+3)<<24); hdma.src[c]+=4;
                                                stage=161;
                                                break;

                                                default:
                                                printf("Bad HDMA mode %i  count %i dest %02X\n",dma.ctrl[c]&7,hdma.hdmacount[c],dma.dest[c]);
                                                dumpregs();
                                                exit(-1);
                                        }
                                }
                                switch (dma.ctrl[c]&7)
                                {
                                        case 0: /*One reg write once*/
                                        writeppu(0x2100|dma.dest[c],hdma.hdmaval[c]);
                                        break;
                                        case 1: /*Two regs write once*/
                                        writeppu(0x2100|dma.dest[c],hdma.hdmaval[c]);
                                        writeppu(0x2100|dma.dest[c]+1,hdma.hdmaval[c]>>8);
                                        break;
                                        case 2: /*One reg write twice*/
                                        writeppu(0x2100|dma.dest[c],hdma.hdmaval[c]);
                                        writeppu(0x2100|dma.dest[c],hdma.hdmaval[c]>>8);
                                        break;
                                        case 3: /*Two regs write twice*/
                                        writeppu(0x2100|dma.dest[c],hdma.hdmaval[c]);
                                        writeppu(0x2100|dma.dest[c],hdma.hdmaval[c]>>8);
                                        writeppu(0x2100|dma.dest[c]+1,hdma.hdmaval[c]>>16);
                                        writeppu(0x2100|dma.dest[c]+1,hdma.hdmaval[c]>>24);
                                        break;
                                        case 4: /*Four regs*/
                                        writeppu(0x2100|dma.dest[c],hdma.hdmaval[c]);
                                        writeppu(0x2100|dma.dest[c]+1,hdma.hdmaval[c]>>8);
                                        writeppu(0x2100|dma.dest[c]+2,hdma.hdmaval[c]>>16);
                                        writeppu(0x2100|dma.dest[c]+3,hdma.hdmaval[c]>>24);
                                        break;
                                }
                                skiphdma:
                        }
                        else
                        {
                                hdma.hdmacount[c]--;
                                if (hdma.repeat[c])
                                {
                                        if (dma.ctrl[c]&0x40)
                                        {
                                                switch (dma.ctrl[c]&7)
                                                {
                                                        case 0: /*One reg write once*/
                                                        hdma.hdmaval[c]=readf(hdma.ibank[c],hdma.ta[c]); hdma.ta[c]++;
                                                        break;
                                                        case 1: /*Two regs write once*/
                                                        hdma.hdmaval[c]=readf(hdma.ibank[c],hdma.ta[c])|(readf(hdma.ibank[c],hdma.ta[c]+1)<<8); hdma.ta[c]+=2;
                                                        break;
                                                        case 2: /*One reg write twice*/
                                                        hdma.hdmaval[c]=readf(hdma.ibank[c],hdma.ta[c])|(readf(hdma.ibank[c],hdma.ta[c]+1)<<8); hdma.ta[c]+=2;
                                                        break;
                                                        case 3: /*Two regs write twice*/
                                                        hdma.hdmaval[c]=readf(hdma.ibank[c],hdma.ta[c])|(readf(hdma.ibank[c],hdma.ta[c]+1)<<8)|(readf(hdma.ibank[c],hdma.ta[c]+2)<<16)|(readf(hdma.ibank[c],hdma.ta[c]+3)<<24); hdma.ta[c]+=4;
                                                        break;
                                                        case 4: /*Four regs write once*/
                                                        hdma.hdmaval[c]=readf(hdma.ibank[c],hdma.ta[c])|(readf(hdma.ibank[c],hdma.ta[c]+1)<<8)|(readf(hdma.ibank[c],hdma.ta[c]+2)<<16)|(readf(hdma.ibank[c],hdma.ta[c]+3)<<24); hdma.ta[c]+=4;
                                                        break;

                                                        default:
                                                        printf("Bad HDMA indirect mode %i  count %i dest %02X  data %02X:%04X\n",dma.ctrl[c]&7,hdma.hdmacount[c],dma.dest[c],hdma.ibank[c],hdma.ta[c]);
                                                        dumpregs();
                                                        exit(-1);
                                                }
                                        }
                                        else
                                        {
                                                switch (dma.ctrl[c]&7)
                                                {
                                                        case 0: /*One reg write once*/
                                                        stage=160;
                                                        hdma.hdmaval[c]=readf(hdma.srcbank[c],hdma.src[c]); hdma.src[c]++;
                                                        stage=161;
                                                        break;
                                                        case 1: /*Two regs write once*/
                                                        stage=160;
                                                        hdma.hdmaval[c]=readf(hdma.srcbank[c],hdma.src[c])|(readf(hdma.srcbank[c],hdma.src[c]+1)<<8); hdma.src[c]+=2;
                                                        stage=161;
                                                        break;
                                                        case 2: /*One reg write twice*/
                                                        stage=160;
                                                        hdma.hdmaval[c]=readf(hdma.srcbank[c],hdma.src[c])|(readf(hdma.srcbank[c],hdma.src[c]+1)<<8); hdma.src[c]+=2;
                                                        stage=161;
                                                        break;
                                                        case 3: /*Two regs write twice*/
                                                        stage=160;
                                                        hdma.hdmaval[c]=readf(hdma.srcbank[c],hdma.src[c])|(readf(hdma.srcbank[c],hdma.src[c]+1)<<8)|(readf(hdma.srcbank[c],hdma.src[c]+2)<<16)|(readf(hdma.srcbank[c],hdma.src[c]+3)<<24); hdma.src[c]+=4;
                                                        stage=161;
                                                        break;
                                                        case 4: /*Four regs*/
                                                        stage=160;
                                                        hdma.hdmaval[c]=readf(hdma.srcbank[c],hdma.src[c])|(readf(hdma.srcbank[c],hdma.src[c]+1)<<8)|(readf(hdma.srcbank[c],hdma.src[c]+2)<<16)|(readf(hdma.srcbank[c],hdma.src[c]+3)<<24); hdma.src[c]+=4;
                                                        stage=161;
                                                        break;

                                                        default:
                                                        printf("Bad HDMA mode %i  count %i dest %02X\n",dma.ctrl[c]&7,hdma.hdmacount[c],dma.dest[c]);
                                                        dumpregs();
                                                        exit(-1);
                                                }
                                        }
                                        switch (dma.ctrl[c]&7)
                                        {
                                                case 0: /*One reg write once*/
                                                writeppu(0x2100|dma.dest[c],hdma.hdmaval[c]);
                                                break;
                                                case 1: /*Two regs write once*/
                                                writeppu(0x2100|dma.dest[c],hdma.hdmaval[c]);
                                                writeppu(0x2100|dma.dest[c]+1,hdma.hdmaval[c]>>8);
                                                break;
                                                case 2: /*One reg write twice*/
                                                writeppu(0x2100|dma.dest[c],hdma.hdmaval[c]);
                                                writeppu(0x2100|dma.dest[c],hdma.hdmaval[c]>>8);
                                                break;
                                                case 3: /*Two regs write twice*/
                                                writeppu(0x2100|dma.dest[c],hdma.hdmaval[c]);
                                                writeppu(0x2100|dma.dest[c],hdma.hdmaval[c]>>8);
                                                writeppu(0x2100|dma.dest[c]+1,hdma.hdmaval[c]>>16);
                                                writeppu(0x2100|dma.dest[c]+1,hdma.hdmaval[c]>>24);
                                                break;
                                                case 4: /*Four regs*/
                                                writeppu(0x2100|dma.dest[c],hdma.hdmaval[c]);
                                                writeppu(0x2100|dma.dest[c]+1,hdma.hdmaval[c]>>8);
                                                writeppu(0x2100|dma.dest[c]+2,hdma.hdmaval[c]>>16);
                                                writeppu(0x2100|dma.dest[c]+3,hdma.hdmaval[c]>>24);
                                                break;
                                        }
                                }
                        }
                }
                mask<<=1;
        }
//        printf("HDMA off\n");
        lines[line].bg[0]=ppu.bg[0]>>1;
        lines[line].chr[0]=ppu.chr[0]>>1;
        lines[line].bg[1]=ppu.bg[1]>>1;
        lines[line].chr[1]=ppu.chr[1]>>1;
        lines[line].bg[2]=ppu.bg[2]>>1;
        lines[line].chr[2]=ppu.chr[2]>>1;
        lines[line].bg[3]=ppu.bg[3]>>1;
        lines[line].chr[3]=ppu.chr[3]>>1;
        lines[line].mode=ppu.mode&7;
        lines[line].tsize[3]=(ppu.mode&0x80)?1:0;
        lines[line].tsize[2]=(ppu.mode&0x40)?1:0;
        lines[line].tsize[1]=(ppu.mode&0x20)?1:0;
        lines[line].tsize[0]=(ppu.mode&0x10)?1:0;
        lines[line].screenon=!(ppu.sdr&0x80);
        if (sblankchk) lines[line].screenon=1;
        lines[line].bright=ppu.sdr&0xF;
        if (ppu.sdr&0x80) lines[line].bright=0;
//        printf("bright %i line %i\n",lines[line].bright,line);
//        if (subscreenon) lines[line].mainena=ppu.main|ppu.sub;
//        else
        lines[line].mainena=ppu.main;
        lines[line].subena=ppu.sub;
        if (!bg1on) lines[line].mainena&=~1;
        if (!bg2on) lines[line].mainena&=~2;
        if (!bg3on) lines[line].mainena&=~4;
        if (!bg1on) lines[line].subena&=~1;
        if (!bg2on) lines[line].subena&=~2;
        if (!bg3on) lines[line].subena&=~4;
        lines[line].bg3pri=ppu.mode&8;
        lines[line].xs[0]=ppu.xs[0];
        lines[line].xs[1]=ppu.xs[1];
        lines[line].xs[2]=ppu.xs[2];
        lines[line].xs[3]=ppu.xs[3];
        lines[line].ys[0]=ppu.ys[0];
        lines[line].ys[1]=ppu.ys[1];
        lines[line].ys[2]=ppu.ys[2];
        lines[line].ys[3]=ppu.ys[3];
        lines[line].xsize[0]=xsize[0]&1;
        lines[line].ysize[0]=ymode[0]&1;
        lines[line].xsize[1]=bgdat[1]&1;
        lines[line].ysize[1]=(bgdat[1]&2)>>1;
        lines[line].xsize[2]=bgdat[2]&1;
        lines[line].ysize[2]=(bgdat[2]&2)>>1;
        lines[line].xsize[3]=bgdat[3]&1;
        lines[line].ysize[3]=(bgdat[3]&2)>>1;
        lines[line].m7a=m7a;
        lines[line].m7c=m7c;
        lines[line].m7x=m7x;
        lines[line].m7y=m7y;
        lines[line].m7sel=m7sel;
        lines[line].m7b=m7b;
        lines[line].m7d=m7d;
        lines[line].cgwsel=ppu.cgwsel;
        lines[line].cgadsub=ppu.cgadsub;
        lines[line].mosaic=mosaic>>4;
        lines[line].mena=mosaic&0xF;
        if (m7write || !line)
           lines[line].m7change=1;
        else
           lines[line].m7change=0;
        m7write=0;
        lines[line].fixedcol=ppufc;
        lines[line].wobjsel=ppu.wobjsel;
        lines[line].w1l=ppu.w1l;
        lines[line].w1r=ppu.w1r;
        lines[line].w2l=ppu.w2l;
        lines[line].w2r=ppu.w2r;
        if (line)
        {
                if ((ppu.w1l!=lines[line-1].w1l) ||
                    (ppu.w1r!=lines[line-1].w1r) ||
                    (ppu.w2l!=lines[line-1].w2l) ||
                    (ppu.w2r!=lines[line-1].w2r))
                    lines[line].wchg=1;
                else
                   lines[line].wchg=0;
        }
}
                        
unsigned short ylookup[2][64]=
{
        {0x000,0x020,0x040,0x060,0x080,0x0A0,0x0C0,0x0E0,
         0x100,0x120,0x140,0x160,0x180,0x1A0,0x1C0,0x1E0,
         0x200,0x220,0x240,0x260,0x280,0x2A0,0x2C0,0x2E0,
         0x300,0x320,0x340,0x360,0x380,0x3A0,0x3C0,0x3E0,
         0x000,0x020,0x040,0x060,0x080,0x0A0,0x0C0,0x0E0,
         0x100,0x120,0x140,0x160,0x180,0x1A0,0x1C0,0x1E0,
         0x200,0x220,0x240,0x260,0x280,0x2A0,0x2C0,0x2E0,
         0x300,0x320,0x340,0x360,0x380,0x3A0,0x3C0,0x3E0},
        {0x000,0x020,0x040,0x060,0x080,0x0A0,0x0C0,0x0E0,
         0x100,0x120,0x140,0x160,0x180,0x1A0,0x1C0,0x1E0,
         0x200,0x220,0x240,0x260,0x280,0x2A0,0x2C0,0x2E0,
         0x300,0x320,0x340,0x360,0x380,0x3A0,0x3C0,0x3E0,
         0x800,0x820,0x840,0x860,0x880,0x8A0,0x8C0,0x8E0,
         0x900,0x920,0x940,0x960,0x980,0x9A0,0x9C0,0x9E0,
         0xA00,0xA20,0xA40,0xA60,0xA80,0xAA0,0xAC0,0xAE0,
         0xB00,0xB20,0xB40,0xB60,0xB80,0xBA0,0xBC0,0xBE0}
};

unsigned short xlookup[2][64]=
{
        {0x000,0x001,0x002,0x003,0x004,0x005,0x006,0x007,
         0x008,0x009,0x00A,0x00B,0x00C,0x00D,0x00E,0x00F,
         0x010,0x011,0x012,0x013,0x014,0x015,0x016,0x017,
         0x018,0x019,0x01A,0x01B,0x01C,0x01D,0x01E,0x01F,
         0x000,0x001,0x002,0x003,0x004,0x005,0x006,0x007,
         0x008,0x009,0x00A,0x00B,0x00C,0x00D,0x00E,0x00F,
         0x010,0x011,0x012,0x013,0x014,0x015,0x016,0x017,
         0x018,0x019,0x01A,0x01B,0x01C,0x01D,0x01E,0x01F},
        {0x000,0x001,0x002,0x003,0x004,0x005,0x006,0x007,
         0x008,0x009,0x00A,0x00B,0x00C,0x00D,0x00E,0x00F,
         0x010,0x011,0x012,0x013,0x014,0x015,0x016,0x017,
         0x018,0x019,0x01A,0x01B,0x01C,0x01D,0x01E,0x01F,
         0x400,0x401,0x402,0x403,0x404,0x405,0x406,0x407,
         0x408,0x409,0x40A,0x40B,0x40C,0x40D,0x40E,0x40F,
         0x410,0x411,0x412,0x413,0x414,0x415,0x416,0x417,
         0x418,0x419,0x41A,0x41B,0x41C,0x41D,0x41E,0x41F},
};

void decodesprites()
{
        int c;
        int addr=512-4;
        int sprsize;
        int addrtemp=543;
        int tempval,temppos=0;
        tempval=objram[addrtemp];
        for (c=127;c>=0;c--)
        {
                sprites.x[c]=objram[c<<2];
                if (tempval&0x40) sprites.x[c]|=256;
//                sprites.x[c]+=8;
//                sprites.x[c]&=511;
//                if (sprites.x[c]>=256) sprites.x[c]-=512;
                sprites.y[c]=objram[(c<<2)+1];
                sprites.t[c]=objram[(c<<2)+2]|((objram[(c<<2)+3]&1)<<8);
                if (bit16) sprites.c[c]=(ppu.coltable16[(objram[(c<<2)+3]>>1)&7]|0x00080008)<<4;
                else       sprites.c[c]=(ppu.coltable[(objram[(c<<2)+3]>>1)&7]|0x08080808)<<4;
                if ((objram[(c<<2)+3]>>1)&4) sprites.c[c]|=0x80008000;
//                else       sprites.c[c]=(ppu.coltable[(objram[(c<<2)+3]>>1)&7]|0x08080808)<<4;
                sprites.p[c]=(objram[(c<<2)+3]>>4)&3;
                sprites.hf[c]=(objram[(c<<2)+3]&0x40)?1:0;
                sprites.vf[c]=(objram[(c<<2)+3]&0x80)?1:0;
                sprsize=tempval&0x80;
                if (sprsize)
                {
                        sprites.sx[c]=objsize[2];
                        sprites.sy[c]=objsize[3];
                }
                else
                {
                        sprites.sx[c]=objsize[0];
                        sprites.sy[c]=objsize[1];
                }
                tempval<<=2;
                temppos++;
                if (temppos==4)
                {
                        addrtemp--;
                        tempval=objram[addrtemp];
                }
                temppos&=3;
//                printf("%03i : %i %03i %03i %02i %02i %04X %02X %02X %02X %02X\n",c,sprites.p[c],sprites.x[c],sprites.y[c],sprites.sx[c],sprites.sy[c],sprites.t[c],objram[c<<2],objram[(c<<2)+1],objram[(c<<2)+2],objram[(c<<2)+3]);
//                printf("%03i %03i %03i %03i %03i %03i\n",c,sprp[c],sprx[c],spry[c],sprsx[c],sprsy[c]);
        }
//        printf("\n");
}

void dosprites(int pri, int ms)
{
        int c,x,y,yy;
        int hstart,hend,hdir;
        int vstart,vend,vdir;
        unsigned short temptile;
        unsigned long *tilep,*maskp,*p;
        if (ms) c=lines[0].subena;
        else    c=lines[0].mainena;
        if (!(c&0x10)) return;
        for (c=127;c>=0;c--)
        {
                if (pri==sprites.p[c])
                {
                        sprites.x[c]&=511;
                        sprites.y[c]&=511;
                        if (sprites.x[c]&256) sprites.x[c]-=512;
                        if (sprites.y[c]>240) sprites.y[c]-=256;
                        if ((sprites.x[c]<264) && (sprites.y[c]<240) && ((sprites.x[c]+(sprites.sx[c]<<3))>=0) && ((sprites.y[c]+(sprites.sy[c]<<3))>=-16)) /*Clip offscreen sprites*/
                        {
                                if (sprites.vf[c])
                                {
                                        vend=-8;
                                        vstart=(sprites.sy[c]-1)<<3;
                                        vdir=-8;
                                        temptile=(sprites.t[c]+(sprchraddr>>5))<<1;
//                                        temptile=(sprites.t[c]+((sprites.sy[c]-1)<<4)+(sprchraddr>>5))<<1;
                                }
                                else
                                {
                                        vstart=0;
                                        vend=sprites.sy[c]<<3;
                                        vdir=8;
                                        temptile=(sprites.t[c]+(sprchraddr>>5))<<1;
                                }
                                if (sprites.t[c]&256) temptile+=(objnamesel>>5)<<1;
                                if (sprites.hf[c])
                                {
                                        hend=-8;
                                        hstart=(sprites.sx[c]-1)<<3;
                                        hdir=-8;
                                }
                                else
                                {
                                        hstart=0;
                                        hend=sprites.sx[c]<<3;
                                        hdir=8;
                                }
                                for (y=vstart;y!=vend;y+=vdir)
                                {
//                                        if (sprites.vf[c]) printf("VF sprite %i temptile %i\n",c,temptile);
                                        if ((y+sprites.y[c]+16)>=0 && (y+sprites.y[c]+24)<=247)
                                        {
                                                for (x=hstart;x!=hend;x+=hdir)
                                                {
                                                        if ((x+sprites.x[c]+16)>=0 && (x+sprites.x[c]+24)<=279)
                                                        {
                                                                for (yy=0;yy<8;yy++)
                                                                {
                                                                        if (!bit16)  p=((unsigned long *)((ppu.b->line[y+yy+sprites.y[c]+17])+((x+sprites.x[c]+16))));
                                                                        else if (ms) p=((unsigned long *)((ppu.s->line[y+yy+sprites.y[c]+17])+((x+sprites.x[c]+16)<<1)));
                                                                        else         p=((unsigned long *)((ppu.b->line[y+yy+sprites.y[c]+17])+((x+sprites.x[c]+16)<<1)));
                                                                        if (sprites.vf[c]) yy^=7;
                                                                        if (bit16)
                                                                        {
                                                                                tilep=tiless16[temptile][sprites.hf[c]][yy];
                                                                                maskp=tilemask16[temptile][sprites.hf[c]][yy];
                                                                        }
                                                                        else
                                                                        {
                                                                                tilep=tiless[temptile][sprites.hf[c]][yy];
                                                                                maskp=tilemask[temptile][sprites.hf[c]][yy];
                                                                        }
                                                                        if (sprites.vf[c]) yy^=7;
                                                                        if (bit16)
                                                                        {
                                                                                if (sprites.hf[c])
                                                                                {
                                                                                        p[2]=(p[2]&~(maskp[0]|maskp[64]))|tilep[0]|(tilep[64]<<2)|(sprites.c[c]&(maskp[0]|maskp[64]));
                                                                                        p[3]=(p[3]&~(maskp[1]|maskp[65]))|tilep[1]|(tilep[65]<<2)|(sprites.c[c]&(maskp[1]|maskp[65]));
                                                                                        p[0]=(p[0]&~(maskp[2]|maskp[66]))|tilep[2]|(tilep[66]<<2)|(sprites.c[c]&(maskp[2]|maskp[66]));
                                                                                        p[1]=(p[1]&~(maskp[3]|maskp[67]))|tilep[3]|(tilep[67]<<2)|(sprites.c[c]&(maskp[3]|maskp[67]));
                                                                                }
                                                                                else
                                                                                {
                                                                                        p[0]=(p[0]&~(maskp[0]|maskp[64]))|tilep[0]|(tilep[64]<<2)|(sprites.c[c]&(maskp[0]|maskp[64]));
                                                                                        p[1]=(p[1]&~(maskp[1]|maskp[65]))|tilep[1]|(tilep[65]<<2)|(sprites.c[c]&(maskp[1]|maskp[65]));
                                                                                        p[2]=(p[2]&~(maskp[2]|maskp[66]))|tilep[2]|(tilep[66]<<2)|(sprites.c[c]&(maskp[2]|maskp[66]));
                                                                                        p[3]=(p[3]&~(maskp[3]|maskp[67]))|tilep[3]|(tilep[67]<<2)|(sprites.c[c]&(maskp[3]|maskp[67]));
                                                                                }
                                                                        }
                                                                        else
                                                                        {
                                                                                if (sprites.hf[c])
                                                                                {
                                                                                        p[1]=(p[1]&~(maskp[0]|maskp[32]))|tilep[0]|(tilep[32]<<2)|(sprites.c[c]&(maskp[0]|maskp[32]));
                                                                                        p[0]=(p[0]&~(maskp[1]|maskp[33]))|tilep[1]|(tilep[33]<<2)|(sprites.c[c]&(maskp[1]|maskp[33]));
                                                                                }
                                                                                else
                                                                                {
                                                                                        p[0]=(p[0]&~(maskp[0]|maskp[32]))|tilep[0]|(tilep[32]<<2)|(sprites.c[c]&(maskp[0]|maskp[32]));
                                                                                        p[1]=(p[1]&~(maskp[1]|maskp[33]))|tilep[1]|(tilep[33]<<2)|(sprites.c[c]&(maskp[1]|maskp[33]));                                                                                }
                                                                        }
                                                                }
                                                        }
                                                        temptile+=2;
                                                }
                                        }
                                        else
                                           temptile+=(sprites.sx[c]<<1);
                                        if (vdir>0) temptile+=0x20;
                                        else        temptile+=0x20;
                                        temptile-=(sprites.sx[c]<<1);
                                }
//                                textprintf(ppu.b,font,x+sprites.x[c]+16,y+yy+sprites.y[c]+17,makecol(255,255,255),"%02X",c);
                        }
                }
        }
}

int bgs[4][8]=
{
        {2,4,4,8,8,4,4,7},
        {2,4,4,4,2,2,0,7},
        {2,2,0,0,0,0,0,0},
        {2,0,0,0,0,0,0,0}
};

#define getm7pixel(x2,y2) temp=ppu.vram[(((y2&~7)<<5)|((x2&~7)>>2))&0xFFFF]; col=ppu.vram[((temp<<7)+((y2&7)<<4)+((x2&7)<<1)+1)&0xFFFF]

/*Inaccuratly named - this actually draws an entire BG*/
void drawline(int bg, int pri, int bg3p, int ms)
{
        int line,mode;
        union
        {
                struct
                {
                        unsigned long a,b,c,d;
                } l;
                struct
                {
                        unsigned short a,b,c,d;
                } w;
                struct
                {
                        unsigned char a,b,c,d,e,f,g,h;
                } b;
        } data;
        int y,xx,yy,xxx,yyy,x2;
        unsigned short tile,temp,temptile;
        unsigned long *p,datml;
        unsigned char *pb,*tilebp,*maskbp;
        unsigned short datm,*pw;
        unsigned short baddr,m7bb,m7dd;
        int x=0;
        unsigned long col=0;
        int xmode=0;
        int lin;
        int hflip;
        int tilemode;
        int yhalf;
        int cx,cy,voff,hoff;
        unsigned long aa=0,bb,cc=0,dd;
        int ma,mb,mc,md;
        unsigned int m7xx=(m7x<<19)>>19,m7yy=(m7y<<19)>>19;
        unsigned long *tilep,*maskp;
        unsigned short *xlk;
        int mosaiccount;
        int lastlin;
        int mscmode,hmos;
        unsigned char mosdat,mosmsk;
        unsigned long mosdatl;
        unsigned long arith;
        mosaiccount=-1;
        m7bb=lines[0].m7b;
        m7dd=lines[0].m7d;
        for (line=0;line<224;line++)
        {
//                if (bg==0) printf("BG0 %i %i\n",lines[line].xsize[bg],lines[line].ysize[bg]);
                mode=bgs[bg][lines[line].mode];
                if (ms) x=lines[line].subena;
                else    x=lines[line].mainena;
                if (mode==7 && bg==0 && pri) goto skipdraw;
                if (lines[line].screenon && (x&(1<<bg) && !(bg==2 && lines[line].mode==1 && pri && ((bg3p && !lines[line].bg3pri) || (!bg3p && lines[line].bg3pri)))))
                {
//                        printf("lines %i %i %i\n",line,lines[line].cgadsub,(1<<bg));
                        if (lines[line].cgadsub&(1<<bg)) arith=0x80008000;
                        else                             arith=0;
//                        arith=0x40004000;
                        tilemode=lines[line].tsize[bg];
                        mscmode=((lines[line].mena&(1<<bg))&&lines[line].mosaic)?16:0;
                        if ((lines[line].mena&(1<<bg)) && mosaiccount>-1)
                           lin=lastlin;
                        else
                        {
                                if (tilemode) lin=(line+lines[line].ys[bg])&1023;
                                else          lin=(line+lines[line].ys[bg])&511;
                                lastlin=lin;
                        }
                        if (mosaiccount==-1) mosaiccount=lines[line].mosaic;
                        mosaiccount--;
                        if (mosaiccount==-2) mosaiccount=-1;
                        baddr=lines[line].bg[bg];
                        if (!bit16)
                        {
                                if (tilemode) p=(unsigned long *)(((ppu.b->line[line+16])-(lines[line].xs[bg]&15))+16);
                                else          p=(unsigned long *)(((ppu.b->line[line+16])-(lines[line].xs[bg]&7))+16);
                        }
                        else if (ms)
                        {
                                if (tilemode) p=(unsigned long *)(((ppu.s->line[line+16])-((lines[line].xs[bg]&15)<<1))+32);
                                else          p=(unsigned long *)(((ppu.s->line[line+16])-((lines[line].xs[bg]&7)<<1))+32);
                        }
                        else
                        {
                                if (tilemode) p=(unsigned long *)(((ppu.b->line[line+16])-((lines[line].xs[bg]&15)<<1))+32);
                                else          p=(unsigned long *)(((ppu.b->line[line+16])-((lines[line].xs[bg]&7)<<1))+32);
                        }
                        y=lin&7;
                        pri=(pri)?0x2000:0;
//                        printf("%i %i %04X %04X ",bg,line,baddr,ylookup[ymode[bg]][(lin>>3)&63]);
                        if (tilemode) baddr+=ylookup[lines[line].ysize[bg]][(lin>>4)&63];
                        else          baddr+=ylookup[lines[line].ysize[bg]][(lin>>3)&63];//((lin>>3)<<5);
                        if (tilemode && (lin&8)) yhalf=1; else yhalf=0;
//                        printf("%04X\n",baddr);
                        if (tilemode) x=(lines[line].xs[bg]>>4)&63;
                        else          x=(lines[line].xs[bg]>>3)&63;
                        xlk=xlookup[lines[line].xsize[bg]];
                        if (bit16)
                        {
                                switch (mode|tilemode)
                                {
                                        case 2:
                                        for (xx=0;xx<132;xx+=4)
                                        {
                                                tile=ppu.vramw[baddr+xlk[x&63]];
                                                if ((tile&0x2000)==pri)
                                                {
                                                        col=(ppu.coltable16[(tile>>10)&7]<<2)|arith;
                                                        temptile=(tile&1023)+(lines[line].chr[bg]>>3);
                                                        hflip=(tile&0x4000)?1:0;
                                                        if (tile&0x8000) y^=7;
                                                        tilep=tiless16[temptile][hflip][y];
                                                        maskp=tilemask16[temptile][hflip][y];
                                                        if (!lines[line].mask)
                                                        {
                                                                if (hflip)
                                                                {
                                                                        p[xx+2]=tilep[0]|(col&maskp[0]);
                                                                        p[xx+3]=tilep[1]|(col&maskp[1]);
                                                                        p[xx]=  tilep[2]|(col&maskp[2]);
                                                                        p[xx+1]=tilep[3]|(col&maskp[3]);
                                                                }
                                                                else
                                                                {
                                                                        p[xx]=  tilep[0]|(col&maskp[0]);
                                                                        p[xx+1]=tilep[1]|(col&maskp[1]);
                                                                        p[xx+2]=tilep[2]|(col&maskp[2]);
                                                                        p[xx+3]=tilep[3]|(col&maskp[3]);
                                                                }
                                                        }
                                                        else if (lines[line].mask && (tiledatm[temptile][y]|tiledatm[temptile+1][y]))
                                                        {
                                                                if (hflip)
                                                                {
                                                                        p[xx+2]=(p[xx+2]&~maskp[0])|tilep[0]|(col&maskp[0]);
                                                                        p[xx+3]=(p[xx+3]&~maskp[1])|tilep[1]|(col&maskp[1]);
                                                                        p[xx]=  (p[xx]  &~maskp[2])|tilep[2]|(col&maskp[2]);
                                                                        p[xx+1]=(p[xx+1]&~maskp[3])|tilep[3]|(col&maskp[3]);
                                                                }
                                                                else
                                                                {
                                                                        p[xx]=  (p[xx]  &~maskp[0])|tilep[0]|(col&maskp[0]);
                                                                        p[xx+1]=(p[xx+1]&~maskp[1])|tilep[1]|(col&maskp[1]);
                                                                        p[xx+2]=(p[xx+2]&~maskp[2])|tilep[2]|(col&maskp[2]);
                                                                        p[xx+3]=(p[xx+3]&~maskp[3])|tilep[3]|(col&maskp[3]);
                                                                }
                                                        }
                                                        if (tile&0x8000) y^=7;
                                                }
                                                x++;
                                        }
                                        break;

                                        case 3:
                                        for (xx=0;xx<132;xx+=8)
                                        {
                                                tile=ppu.vramw[baddr+xlk[x&63]];
                                                if ((tile&0x2000)==pri)
                                                {
                                                        col=(ppu.coltable16[(tile>>10)&7]<<2)|arith;
                                                        temptile=(tile&1023)+(lines[line].chr[bg]>>3);
                                                        if ((tile&0x8000) && !yhalf) temptile+=32;
                                                        if (!(tile&0x8000) && yhalf) temptile+=32;
                                                        hflip=(tile&0x4000)?1:0;
                                                        if (tile&0x8000) y^=7;
                                                        tilep=tiless16[temptile][hflip][y];
                                                        maskp=tilemask16[temptile][hflip][y];
                                                        if (!lines[line].mask)
                                                        {
                                                                if (hflip)
                                                                {
                                                                        p[xx+6]=tilep[64]|col;
                                                                        p[xx+7]=tilep[65]|col;
                                                                        p[xx+4]=tilep[66]|col;
                                                                        p[xx+5]=tilep[67]|col;
                                                                        p[xx+2]=tilep[0]|col;
                                                                        p[xx+3]=tilep[1]|col;
                                                                        p[xx]=  tilep[2]|col;
                                                                        p[xx+1]=tilep[3]|col;
                                                                }
                                                                else
                                                                {
                                                                        p[xx]=  tilep[0]|col;
                                                                        p[xx+1]=tilep[1]|col;
                                                                        p[xx+2]=tilep[2]|col;
                                                                        p[xx+3]=tilep[3]|col;
                                                                        p[xx+4]=tilep[64]|col;
                                                                        p[xx+5]=tilep[65]|col;
                                                                        p[xx+6]=tilep[66]|col;
                                                                        p[xx+7]=tilep[67]|col;
                                                                }
                                                        }
                                                        else if (lines[line].mask && (tiledatm[temptile][y]|tiledatm[temptile+1][y]))
                                                        {
                                                                if (hflip)
                                                                {
                                                                        p[xx+6]=(p[xx+6]&~maskp[0])|tilep[0]|(col&maskp[0]);
                                                                        p[xx+7]=(p[xx+7]&~maskp[1])|tilep[1]|(col&maskp[1]);
                                                                        p[xx+4]=(p[xx+4]&~maskp[2])|tilep[2]|(col&maskp[2]);
                                                                        p[xx+5]=(p[xx+5]&~maskp[3])|tilep[3]|(col&maskp[3]);
                                                                        p[xx+2]=(p[xx+2]&~maskp[64])|tilep[64]|(col&maskp[64]);
                                                                        p[xx+3]=(p[xx+3]&~maskp[65])|tilep[65]|(col&maskp[65]);
                                                                        p[xx]=  (p[xx]  &~maskp[66])|tilep[66]|(col&maskp[66]);
                                                                        p[xx+1]=(p[xx+1]&~maskp[67])|tilep[67]|(col&maskp[67]);
                                                                }
                                                                else
                                                                {
                                                                        p[xx]=  (p[xx]  &~maskp[0])|tilep[0]|(col&maskp[0]);
                                                                        p[xx+1]=(p[xx+1]&~maskp[1])|tilep[1]|(col&maskp[1]);
                                                                        p[xx+2]=(p[xx+2]&~maskp[2])|tilep[2]|(col&maskp[2]);
                                                                        p[xx+3]=(p[xx+3]&~maskp[3])|tilep[3]|(col&maskp[3]);
                                                                        p[xx+4]=(p[xx+4]&~maskp[64])|tilep[64]|(col&maskp[64]);
                                                                        p[xx+5]=(p[xx+5]&~maskp[65])|tilep[65]|(col&maskp[65]);
                                                                        p[xx+6]=(p[xx+6]&~maskp[66])|tilep[66]|(col&maskp[66]);
                                                                        p[xx+7]=(p[xx+7]&~maskp[67])|tilep[67]|(col&maskp[67]);
                                                                }
                                                        }
                                                        if (tile&0x8000) y^=7;
                                                }
                                                x++;
                                        }
                                        break;

                                        case 4:
                                        for (xx=0;xx<132;xx+=4)
                                        {
                                                tile=ppu.vramw[baddr+xlk[x&63]];
                                                if ((tile&0x2000)==pri)
                                                {
                                                        col=(ppu.coltable16[(tile>>10)&7]<<4)|arith;
                                                        temptile=((tile&1023)+(lines[line].chr[bg]>>4))<<1;
                                                        hflip=(tile&0x4000)?1:0;
                                                        if (tile&0x8000) y^=7;
                                                        tilep=tiless16[temptile][hflip][y];
                                                        maskp=tilemask16[temptile][hflip][y];
                                                        if (!lines[line].mask)
                                                        {
                                                                if (hflip)
                                                                {
                                                                        p[xx+2]=tilep[0]|(tilep[64]<<2)|(col&(maskp[0]|maskp[64]));
                                                                        p[xx+3]=tilep[1]|(tilep[65]<<2)|(col&(maskp[1]|maskp[65]));
                                                                        p[xx]=  tilep[2]|(tilep[66]<<2)|(col&(maskp[2]|maskp[66]));
                                                                        p[xx+1]=tilep[3]|(tilep[67]<<2)|(col&(maskp[3]|maskp[67]));
                                                                }
                                                                else
                                                                {
                                                                        p[xx]=  tilep[0]|(tilep[64]<<2)|(col&(maskp[0]|maskp[64]));
                                                                        p[xx+1]=tilep[1]|(tilep[65]<<2)|(col&(maskp[1]|maskp[65]));
                                                                        p[xx+2]=tilep[2]|(tilep[66]<<2)|(col&(maskp[2]|maskp[66]));
                                                                        p[xx+3]=tilep[3]|(tilep[67]<<2)|(col&(maskp[3]|maskp[67]));
                                                                }
                                                        }
                                                        else if (lines[line].mask && (tiledatm[temptile][y]|tiledatm[temptile+1][y]))
                                                        {
                                                                if (hflip)
                                                                {
                                                                        p[xx+2]=(p[xx+2]&~(maskp[0]|maskp[64]))|(tilep[0]|(tilep[64]<<2))|(col&(maskp[0]|maskp[64]));
                                                                        p[xx+3]=(p[xx+3]&~(maskp[1]|maskp[65]))|(tilep[1]|(tilep[65]<<2))|(col&(maskp[1]|maskp[65]));
                                                                        p[xx]=  (p[xx]  &~(maskp[2]|maskp[66]))|(tilep[2]|(tilep[66]<<2))|(col&(maskp[2]|maskp[66]));
                                                                        p[xx+1]=(p[xx+1]&~(maskp[3]|maskp[67]))|(tilep[3]|(tilep[67]<<2))|(col&(maskp[3]|maskp[67]));
                                                                }
                                                                else
                                                                {
                                                                        p[xx]=  (p[xx]  &~(maskp[0]|maskp[64]))|(tilep[0]|(tilep[64]<<2))|(col&(maskp[0]|maskp[64]));
                                                                        p[xx+1]=(p[xx+1]&~(maskp[1]|maskp[65]))|(tilep[1]|(tilep[65]<<2))|(col&(maskp[1]|maskp[65]));
                                                                        p[xx+2]=(p[xx+2]&~(maskp[2]|maskp[66]))|(tilep[2]|(tilep[66]<<2))|(col&(maskp[2]|maskp[66]));
                                                                        p[xx+3]=(p[xx+3]&~(maskp[3]|maskp[67]))|(tilep[3]|(tilep[67]<<2))|(col&(maskp[3]|maskp[67]));
                                                                }
                                                        }
                                                        if (tile&0x8000) y^=7;
                                                }
                                                x++;
                                        }
                                        break;

                                        case 5:
                                        for (xx=0;xx<132;xx+=8)
                                        {
                                                tile=ppu.vramw[baddr+xlk[x&63]];
                                                if ((tile&0x2000)==pri)
                                                {
                                                        col=(ppu.coltable16[(tile>>10)&7]<<4)|arith;
                                                        temptile=((tile&1023)+(lines[line].chr[bg]>>4))<<1;
                                                        if ((tile&0x8000) && !yhalf) temptile+=32;
                                                        if (!(tile&0x8000) && yhalf) temptile+=32;
                                                        hflip=(tile&0x4000)?1:0;
                                                        if (tile&0x8000) y^=7;
                                                        tilep=tiless16[temptile][hflip][y];
                                                        maskp=tilemask16[temptile][hflip][y];
                                                        if (!lines[line].mask)
                                                        {
                                                                if (hflip)
                                                                {
                                                                        p[xx+6]=tilep[128]|(tilep[192]<<2)|col;
                                                                        p[xx+7]=tilep[129]|(tilep[193]<<2)|col;
                                                                        p[xx+4]=tilep[130]|(tilep[194]<<2)|col;
                                                                        p[xx+5]=tilep[131]|(tilep[195]<<2)|col;
                                                                        p[xx+2]=tilep[0]|(tilep[64]<<2)|col;
                                                                        p[xx+3]=tilep[1]|(tilep[65]<<2)|col;
                                                                        p[xx]=  tilep[2]|(tilep[66]<<2)|col;
                                                                        p[xx+1]=tilep[3]|(tilep[67]<<2)|col;
                                                                }
                                                                else
                                                                {
                                                                        p[xx]=  tilep[0]|(tilep[64]<<2)|col;
                                                                        p[xx+1]=tilep[1]|(tilep[65]<<2)|col;
                                                                        p[xx+2]=tilep[2]|(tilep[66]<<2)|col;
                                                                        p[xx+3]=tilep[3]|(tilep[67]<<2)|col;
                                                                        p[xx+4]=tilep[128]|(tilep[192]<<2)|col;
                                                                        p[xx+5]=tilep[129]|(tilep[193]<<2)|col;
                                                                        p[xx+6]=tilep[130]|(tilep[194]<<2)|col;
                                                                        p[xx+7]=tilep[131]|(tilep[195]<<2)|col;
                                                                }
                                                        }
                                                        else if (lines[line].mask && (tiledatm[temptile][y]|tiledatm[temptile+1][y]))
                                                        {
                                                                if (hflip)
                                                                {
                                                                        p[xx+6]=(p[xx+6]&~(maskp[0]|maskp[64]))|(tilep[0]|(tilep[64]<<2))|(col&(maskp[0]|maskp[64]));
                                                                        p[xx+7]=(p[xx+7]&~(maskp[1]|maskp[65]))|(tilep[1]|(tilep[65]<<2))|(col&(maskp[1]|maskp[65]));
                                                                        p[xx+4]=(p[xx+4]&~(maskp[2]|maskp[66]))|(tilep[2]|(tilep[66]<<2))|(col&(maskp[2]|maskp[66]));
                                                                        p[xx+5]=(p[xx+5]&~(maskp[3]|maskp[67]))|(tilep[3]|(tilep[67]<<2))|(col&(maskp[3]|maskp[67]));
                                                                        p[xx+2]=(p[xx+2]&~(maskp[128]|maskp[192]))|(tilep[128]|(tilep[192]<<2))|(col&(maskp[128]|maskp[192]));
                                                                        p[xx+3]=(p[xx+3]&~(maskp[129]|maskp[193]))|(tilep[129]|(tilep[193]<<2))|(col&(maskp[129]|maskp[193]));
                                                                        p[xx]=  (p[xx]  &~(maskp[130]|maskp[194]))|(tilep[130]|(tilep[194]<<2))|(col&(maskp[130]|maskp[194]));
                                                                        p[xx+1]=(p[xx+1]&~(maskp[131]|maskp[195]))|(tilep[131]|(tilep[195]<<2))|(col&(maskp[131]|maskp[195]));
                                                                }
                                                                else
                                                                {
                                                                        p[xx]=  (p[xx]  &~(maskp[0]|maskp[64]))|(tilep[0]|(tilep[64]<<2))|(col&(maskp[0]|maskp[64]));
                                                                        p[xx+1]=(p[xx+1]&~(maskp[1]|maskp[65]))|(tilep[1]|(tilep[65]<<2))|(col&(maskp[1]|maskp[65]));
                                                                        p[xx+2]=(p[xx+2]&~(maskp[2]|maskp[66]))|(tilep[2]|(tilep[66]<<2))|(col&(maskp[2]|maskp[66]));
                                                                        p[xx+3]=(p[xx+3]&~(maskp[3]|maskp[67]))|(tilep[3]|(tilep[67]<<2))|(col&(maskp[3]|maskp[67]));
                                                                        p[xx+4]=(p[xx+4]&~(maskp[128]|maskp[192]))|(tilep[128]|(tilep[192]<<2))|(col&(maskp[128]|maskp[192]));
                                                                        p[xx+5]=(p[xx+5]&~(maskp[129]|maskp[193]))|(tilep[129]|(tilep[193]<<2))|(col&(maskp[129]|maskp[193]));
                                                                        p[xx+6]=(p[xx+6]&~(maskp[130]|maskp[194]))|(tilep[130]|(tilep[194]<<2))|(col&(maskp[130]|maskp[194]));
                                                                        p[xx+7]=(p[xx+7]&~(maskp[131]|maskp[195]))|(tilep[131]|(tilep[195]<<2))|(col&(maskp[131]|maskp[195]));
                                                                }
                                                        }
                                                        if (tile&0x8000) y^=7;
                                                }
                                                x++;
                                        }
                                        break;

                                        case 7:
                                        pw=(unsigned short *)(((ppu.b->line[line+16]))+32);
                                        cx=(((int)lines[line].m7x<<19)>>19);
                                        cy=(((int)lines[line].m7y<<19)>>19);
                                        hoff=((int)lines[line].xs[0]<<19)>>19;
                                        voff=((int)lines[line].ys[0]<<19)>>19;
                                        ma=((int)lines[line].m7a<<16)>>16;
                                        mb=((int)lines[line].m7b<<16)>>16;
                                        mc=((int)lines[line].m7c<<16)>>16;
                                        md=((int)lines[line].m7d<<16)>>16;
                                        y=line;
                                        y+=(voff-cy);
                                        bb=(mb*y)+(cx<<8);
                                        dd=(md*y)+(cy<<8);
                                        x=hoff-cx;
                                        aa=(ma*x);
                                        cc=(mc*x);
                                        for (x=0;x<256;x++)
                                        {
                                                xx=((aa+bb)>>8);//&1023;
                                                yy=((cc+dd)>>8);//&1023;
                                                if ((xx|yy)&0xFFFFFC00)
                                                {
                                                        switch (lines[line].m7sel>>6)
                                                        {
                                                                case 0: case 1: getm7pixel((xx&1023),(yy&1023)); break;
                                                                case 2: col=0; break;
                                                                case 3: col=ppu.vram[(((yy&7)<<4)+((xx&7)<<1)+1)&0xFFFF]; break;
                                                        }
                                                }
                                                else
                                                {
                                                        getm7pixel(xx,yy);
                                                }
                                                if (col) *pw=col;
                                                aa+=ma;
                                                cc+=mc;
                                                pw++;
                                        }
                                        break;

                                        case 8:
                                        for (xx=0;xx<132;xx+=4)
                                        {
                                                tile=ppu.vramw[baddr+xlk[x&63]];
                                                if ((tile&0x2000)==pri)
                                                {
                                                        col=ppu.coltable16[(tile>>10)&7]<<4;
                                                        temptile=((tile&1023)+(lines[line].chr[bg]>>5))<<2;
                                                        hflip=(tile&0x4000)?1:0;
                                                        if (tile&0x8000) y^=7;
                                                        tilep=tiless16[temptile][hflip][y];
                                                        maskp=tilemask16[temptile][hflip][y];
                                                        if (!lines[line].mask)
                                                        {
                                                                if (hflip)
                                                                {
                                                                        p[xx+2]=tilep[0]|(tilep[64]<<2)|(tilep[128]<<4)|(tilep[192]<<6);
                                                                        p[xx+3]=tilep[1]|(tilep[65]<<2)|(tilep[129]<<4)|(tilep[193]<<6);
                                                                        p[xx]=  tilep[2]|(tilep[66]<<2)|(tilep[130]<<4)|(tilep[194]<<6);
                                                                        p[xx+1]=tilep[3]|(tilep[67]<<2)|(tilep[131]<<4)|(tilep[195]<<6);
                                                                }
                                                                else
                                                                {
                                                                        p[xx]=  tilep[0]|(tilep[64]<<2)|(tilep[128]<<4)|(tilep[192]<<6);
                                                                        p[xx+1]=tilep[1]|(tilep[65]<<2)|(tilep[129]<<4)|(tilep[193]<<6);
                                                                        p[xx+2]=tilep[2]|(tilep[66]<<2)|(tilep[130]<<4)|(tilep[194]<<6);
                                                                        p[xx+3]=tilep[3]|(tilep[67]<<2)|(tilep[131]<<4)|(tilep[195]<<6);
                                                                }
                                                        }
                                                        else if (lines[line].mask && (tiledatm[temptile][y]|tiledatm[temptile+1][y]))
                                                        {
                                                                if (hflip)
                                                                {
                                                                        p[xx+2]=(p[xx+2]&~(maskp[0]|maskp[64]|maskp[128]|maskp[192]))|(tilep[0]|(tilep[64]<<2)|(tilep[128]<<4)|(tilep[192]<<6));
                                                                        p[xx+3]=(p[xx+3]&~(maskp[1]|maskp[65]|maskp[129]|maskp[193]))|(tilep[1]|(tilep[65]<<2)|(tilep[129]<<4)|(tilep[193]<<6));
                                                                        p[xx]=  (p[xx]  &~(maskp[2]|maskp[66]|maskp[130]|maskp[194]))|(tilep[2]|(tilep[66]<<2)|(tilep[130]<<4)|(tilep[194]<<6));
                                                                        p[xx+1]=(p[xx+1]&~(maskp[3]|maskp[67]|maskp[131]|maskp[195]))|(tilep[3]|(tilep[67]<<2)|(tilep[131]<<4)|(tilep[195]<<6));
                                                                }
                                                                else
                                                                {
                                                                        p[xx]=  (p[xx]  &~(maskp[0]|maskp[64]|maskp[128]|maskp[192]))|(tilep[0]|(tilep[64]<<2)|(tilep[128]<<4)|(tilep[192]<<6));
                                                                        p[xx+1]=(p[xx+1]&~(maskp[1]|maskp[65]|maskp[129]|maskp[193]))|(tilep[1]|(tilep[65]<<2)|(tilep[129]<<4)|(tilep[193]<<6));
                                                                        p[xx+2]=(p[xx+2]&~(maskp[2]|maskp[66]|maskp[130]|maskp[194]))|(tilep[2]|(tilep[66]<<2)|(tilep[130]<<4)|(tilep[194]<<6));
                                                                        p[xx+3]=(p[xx+3]&~(maskp[3]|maskp[67]|maskp[131]|maskp[195]))|(tilep[3]|(tilep[67]<<2)|(tilep[131]<<4)|(tilep[195]<<6));
                                                                }
                                                        }
                                                        if (tile&0x8000) y^=7;
                                                }
                                                x++;
                                        }
                                        break;
                                }
                        }
                        else
                        {
                        switch (mode|tilemode|mscmode)
                        {
                                case 1:
                                memset(&ppu.b->line[line+16][16],0,264);
                                break;
                                case 2:
                                for (xx=0;xx<66;xx+=2)
                                {
                                        tile=ppu.vramw[baddr+xlk[x&63]];
                                        if ((tile&0x2000)==pri && !(!(tile&0x3FF) && lines[line].mask && blanktile0))
                                        {
                                                col=ppu.coltable[(tile>>10)&7]<<2;
                                                temptile=(tile&1023)+(lines[line].chr[bg]>>3);
                                                hflip=(tile&0x4000)?1:0;
                                                if (tile&0x8000) y^=7;
                                                tilep=tiless[temptile][hflip][y];
                                                maskp=tilemask[temptile][hflip][y];
                                                if (!lines[line].mask)
                                                {
                                                        p[xx+hflip]=tilep[0]|(col&maskp[0]);
                                                        p[xx+(!hflip)]=tilep[1]|(col&maskp[1]);
                                                }
                                                else if (lines[line].mask && tiledatm[temptile][y])
                                                {
                                                        p[xx+hflip]=(p[xx+hflip]&~maskp[0])|(tilep[0]|(col&maskp[0]));
                                                        p[xx+!hflip]=(p[xx+!hflip]&~maskp[1])|(tilep[1]|(col&maskp[1]));
                                                }
                                                if (tile&0x8000) y^=7;
/*                                                if (tile&0x8000) temp=((tile&1023)<<3)+lines[line].chr[bg]+(y^7);
                                                else             temp=((tile&1023)<<3)+lines[line].chr[bg]+y;
                                                data.w.a=ppu.vramw[temp];
                                                datm=data.b.a|data.b.b;
                                                hflip=(tile&0x4000)?1:0;
                                                if (lines[line].mask && datm)
                                                {
                                                        p[(xx<<1)+hflip]&=~ppu.masktable[hflip][datm>>4];
                                                        p[(xx<<1)+hflip]|=ppu.bittable[hflip][data.b.a>>4]|(ppu.bittable[hflip][data.b.b>>4]<<1)|(col&ppu.masktable[hflip][datm>>4]);
                                                        p[(xx<<1)+(1^hflip)]&=~ppu.masktable[hflip][datm&0xF];
                                                        p[(xx<<1)+(1^hflip)]|=ppu.bittable[hflip][data.b.a&0xF]|(ppu.bittable[hflip][data.b.b&0xF]<<1)|(col&ppu.masktable[hflip][datm&0xF]);
                                                }
                                                if (!lines[line].mask)
                                                {
                                                        p[(xx<<1)+hflip]=ppu.bittable[hflip][data.b.a>>4]|(ppu.bittable[hflip][data.b.b>>4]<<1)|(col&ppu.masktable[hflip][datm>>4]);
                                                        p[(xx<<1)+(1^hflip)]=ppu.bittable[hflip][data.b.a&0xF]|(ppu.bittable[hflip][data.b.b&0xF]<<1)|(col&ppu.masktable[hflip][datm&0xF]);
                                                }*/
                                        }
                                        x++;
                                }
                                break;
                                case 4:
                                for (xx=0;xx<66;xx+=2)
                                {
                                        tile=ppu.vramw[baddr+xlk[x&63]];
                                        if ((tile&0x2000)==pri && !(!(tile&0x3FF) && lines[line].mask && blanktile0))
                                        {
                                                col=ppu.coltable[(tile>>10)&7]<<4;
                                                temptile=((tile&1023)+(lines[line].chr[bg]>>4))<<1;
                                                hflip=(tile&0x4000)?1:0;
                                                if (tile&0x8000) y^=7;
                                                tilep=tiless[temptile][hflip][y];
                                                maskp=tilemask[temptile][hflip][y];
                                                if (!lines[line].mask)
                                                {
                                                        if (hflip)
                                                        {
                                                                p[xx+1]=tilep[0]|(tilep[32]<<2)|(col&(maskp[0]|maskp[32]));
                                                                p[xx]=tilep[1]|(tilep[33]<<2)|(col&(maskp[1]|maskp[33]));
                                                        }
                                                        else
                                                        {
                                                                p[xx]=tilep[0]|(tilep[32]<<2)|(col&(maskp[0]|maskp[32]));
                                                                p[xx+1]=tilep[1]|(tilep[33]<<2)|(col&(maskp[1]|maskp[33]));
                                                        }
                                                }
                                                else if (lines[line].mask && (tiledatm[temptile][y]|tiledatm[temptile+1][y]))
                                                {
                                                        if (hflip)
                                                        {
                                                                p[xx+1]=(p[xx+1]&~(maskp[0]|maskp[32]))|(tilep[0]|(tilep[32]<<2)|(col&(maskp[0]|maskp[32])));
                                                                p[xx]=(p[xx]&~(maskp[1]|maskp[33]))|(tilep[1]|(tilep[33]<<2)|(col&(maskp[1]|maskp[33])));
                                                        }
                                                        else
                                                        {
                                                                p[xx]=(p[xx]&~(maskp[0]|maskp[32]))|(tilep[0]|(tilep[32]<<2)|(col&(maskp[0]|maskp[32])));
                                                                p[xx+1]=(p[xx+1]&~(maskp[1]|maskp[33]))|(tilep[1]|(tilep[33]<<2)|(col&(maskp[1]|maskp[33])));
                                                        }
                                                }
                                                if (tile&0x8000) y^=7;
                                        }
                                        x++;
                                }
                                break;
                                case 5:
                                for (xx=0;xx<17;xx++)
                                {
                                        tile=ppu.vramw[baddr+xlookup[lines[line].xsize[bg]][x&63]];
                                        if ((tile&0x2000)==pri && !(!(tile&0x3FF) && lines[line].mask))
                                        {
                                                col=ppu.coltable[(tile>>10)&7]<<4;
                                                if (tile&0x8000) temp=((tile&1023)<<4)+lines[line].chr[bg]+(y^7);
                                                else             temp=((tile&1023)<<4)+lines[line].chr[bg]+y;
                                                if ((tile&0x8000) && !yhalf) temp+=256;
                                                if (!(tile&0x8000) && yhalf) temp+=256;
                                                data.w.a=ppu.vramw[temp];
                                                data.w.b=ppu.vramw[temp+8];
                                                data.w.c=ppu.vramw[temp+16];
                                                data.w.d=ppu.vramw[temp+24];
                                                datm=data.b.a|data.b.b|data.b.c|data.b.d;
                                                datm|=(data.b.e|data.b.f|data.b.g|data.b.h)<<8;
//                                                datm=data.w.a|data.w.b|data.w.c|data.w.d;
                                                hflip=(tile&0x4000)?1:0;
                                                if (lines[line].mask && datm)
                                                {
                                                        if (hflip)
                                                        {
                                                                p[((xx<<2)+3)&127]&=  ~ppu.masktable[hflip][(datm>>4)&0xF];
                                                                p[((xx<<2)+3)&127]|=  ppu.bittable[hflip][data.b.a>>4]|(ppu.bittable[hflip][data.b.b>>4]<<1)|(ppu.bittable[hflip][data.b.c>>4]<<2)|(ppu.bittable[hflip][data.b.d>>4]<<3)|(col&ppu.masktable[hflip][(datm>>4)&0xF]);
                                                                p[((xx<<2)+2)&127]&=~ppu.masktable[hflip][datm&0xF];
                                                                p[((xx<<2)+2)&127]|=ppu.bittable[hflip][data.b.a&0xF]|(ppu.bittable[hflip][data.b.b&0xF]<<1)|(ppu.bittable[hflip][data.b.c&0xF]<<2)|(ppu.bittable[hflip][data.b.d&0xF]<<3)|(col&ppu.masktable[hflip][datm&0xF]);
                                                                p[((xx<<2)+1)&127]&=~ppu.masktable[hflip][(datm>>12)&0xF];
                                                                p[((xx<<2)+1)&127]|=ppu.bittable[hflip][data.b.e>>4]|(ppu.bittable[hflip][data.b.f>>4]<<1)|(ppu.bittable[hflip][data.b.g>>4]<<2)|(ppu.bittable[hflip][data.b.h>>4]<<3)|(col&ppu.masktable[hflip][(datm>>12)&0xF]);
                                                                p[((xx<<2))&127]&=~ppu.masktable[hflip][(datm>>8)&0xF];
                                                                p[((xx<<2))&127]|=ppu.bittable[hflip][data.b.e&0xF]|(ppu.bittable[hflip][data.b.f&0xF]<<1)|(ppu.bittable[hflip][data.b.g&0xF]<<2)|(ppu.bittable[hflip][data.b.h&0xF]<<3)|(col&ppu.masktable[hflip][(datm>>8)&0xF]);
                                                        }
                                                        else
                                                        {
                                                                p[((xx<<2))&127]&=  ~ppu.masktable[hflip][(datm>>4)&0xF];
                                                                p[((xx<<2))&127]|=  ppu.bittable[hflip][data.b.a>>4]|(ppu.bittable[hflip][data.b.b>>4]<<1)|(ppu.bittable[hflip][data.b.c>>4]<<2)|(ppu.bittable[hflip][data.b.d>>4]<<3)|(col&ppu.masktable[hflip][(datm>>4)&0xF]);
                                                                p[((xx<<2)+1)&127]&=~ppu.masktable[hflip][datm&0xF];
                                                                p[((xx<<2)+1)&127]|=ppu.bittable[hflip][data.b.a&0xF]|(ppu.bittable[hflip][data.b.b&0xF]<<1)|(ppu.bittable[hflip][data.b.c&0xF]<<2)|(ppu.bittable[hflip][data.b.d&0xF]<<3)|(col&ppu.masktable[hflip][datm&0xF]);
                                                                p[((xx<<2)+2)&127]&=~ppu.masktable[hflip][(datm>>12)&0xF];
                                                                p[((xx<<2)+2)&127]|=ppu.bittable[hflip][data.b.e>>4]|(ppu.bittable[hflip][data.b.f>>4]<<1)|(ppu.bittable[hflip][data.b.g>>4]<<2)|(ppu.bittable[hflip][data.b.h>>4]<<3)|(col&ppu.masktable[hflip][(datm>>12)&0xF]);
                                                                p[((xx<<2)+3)&127]&=~ppu.masktable[hflip][(datm>>8)&0xF];
                                                                p[((xx<<2)+3)&127]|=ppu.bittable[hflip][data.b.e&0xF]|(ppu.bittable[hflip][data.b.f&0xF]<<1)|(ppu.bittable[hflip][data.b.g&0xF]<<2)|(ppu.bittable[hflip][data.b.h&0xF]<<3)|(col&ppu.masktable[hflip][(datm>>8)&0xF]);
                                                        }
                                                }
                                                if (!lines[line].mask)
                                                {
                                                        if (hflip)
                                                        {
                                                                p[((xx<<2)+3)&127]=  ppu.bittable[hflip][data.b.a>>4] |(ppu.bittable[hflip][data.b.b>>4]<<1) |(ppu.bittable[hflip][data.b.c>>4]<<2) |(ppu.bittable[hflip][data.b.d>>4]<<3) |(col&ppu.masktable[hflip][(datm>>4)&0xF]);
                                                                p[((xx<<2)+2)&127]=ppu.bittable[hflip][data.b.a&0xF]|(ppu.bittable[hflip][data.b.b&0xF]<<1)|(ppu.bittable[hflip][data.b.c&0xF]<<2)|(ppu.bittable[hflip][data.b.d&0xF]<<3)|(col&ppu.masktable[hflip][datm&0xF]);
                                                                p[((xx<<2)+1)&127]=ppu.bittable[hflip][data.b.e>>4] |(ppu.bittable[hflip][data.b.f>>4]<<1) |(ppu.bittable[hflip][data.b.g>>4]<<2) |(ppu.bittable[hflip][data.b.h>>4]<<3) |(col&ppu.masktable[hflip][(datm>>12)&0xF]);
                                                                p[((xx<<2))&127]=ppu.bittable[hflip][data.b.e&0xF]|(ppu.bittable[hflip][data.b.f&0xF]<<1)|(ppu.bittable[hflip][data.b.g&0xF]<<2)|(ppu.bittable[hflip][data.b.h&0xF]<<3)|(col&ppu.masktable[hflip][(datm>>8)&0xF]);
                                                        }
                                                        else
                                                        {
                                                                p[((xx<<2))&127]=  ppu.bittable[hflip][data.b.a>>4] |(ppu.bittable[hflip][data.b.b>>4]<<1) |(ppu.bittable[hflip][data.b.c>>4]<<2) |(ppu.bittable[hflip][data.b.d>>4]<<3) |(col&ppu.masktable[hflip][(datm>>4)&0xF]);
                                                                p[((xx<<2)+1)&127]=ppu.bittable[hflip][data.b.a&0xF]|(ppu.bittable[hflip][data.b.b&0xF]<<1)|(ppu.bittable[hflip][data.b.c&0xF]<<2)|(ppu.bittable[hflip][data.b.d&0xF]<<3)|(col&ppu.masktable[hflip][datm&0xF]);
                                                                p[((xx<<2)+2)&127]=ppu.bittable[hflip][data.b.e>>4] |(ppu.bittable[hflip][data.b.f>>4]<<1) |(ppu.bittable[hflip][data.b.g>>4]<<2) |(ppu.bittable[hflip][data.b.h>>4]<<3) |(col&ppu.masktable[hflip][(datm>>12)&0xF]);
                                                                p[((xx<<2)+3)&127]=ppu.bittable[hflip][data.b.e&0xF]|(ppu.bittable[hflip][data.b.f&0xF]<<1)|(ppu.bittable[hflip][data.b.g&0xF]<<2)|(ppu.bittable[hflip][data.b.h&0xF]<<3)|(col&ppu.masktable[hflip][(datm>>8)&0xF]);
                                                        }
                                                }
                                        }
                                        x++;
                                }
                                break;

//#if 0
                                case 7:
                                pb=(unsigned char *)(((ppu.b->line[line+16]))+16);
                                cx=(((int)lines[line].m7x<<19)>>19);
                                cy=(((int)lines[line].m7y<<19)>>19);
                                hoff=((int)lines[line].xs[0]<<19)>>19;
                                voff=((int)lines[line].ys[0]<<19)>>19;
                                ma=((int)lines[line].m7a<<16)>>16;
                                mb=((int)lines[line].m7b<<16)>>16;
                                mc=((int)lines[line].m7c<<16)>>16;
                                md=((int)lines[line].m7d<<16)>>16;
//                                if (!line) printf("line %03i ma %i mb %i mc %i md %i cx %i cy %i hoff %i voff %i\n",line,ma,mb,mc,md,cx,cy,hoff,voff);
                                y=line;
                                y+=(voff-cy);
                                bb=(mb*y)+(cx<<8);
                                dd=(md*y)+(cy<<8);
                                x=hoff-cx;
                                aa=(ma*x);
                                cc=(mc*x);
//                                if (!line) printf("Line 0 - %04i %04i\n",((aa+bb)>>8)&1023,((cc+dd)>>8)&1023);
                                for (x=0;x<256;x++)
                                {
//                                        xx=(-(lines[line].xs[0]&1023)+((aa+bb)>>8))&1023;
//                                        yy=(-(lines[line].ys[0]&1023)+((cc+dd)>>8))&1023;
//                                        xxx=((((lines[line].xs[0]+x)&1023)-x)&1023)+((aa+bb)>>8);
//                                        yyy=((((lines[line].ys[0]+x)&1023)-x)&1023)+((cc+dd)>>8);
                                        xx=((aa+bb)>>8);//&1023;
                                        yy=((cc+dd)>>8);//&1023;
                                        if ((xx|yy)&0xFFFFFC00)
                                        {
                                                switch (lines[line].m7sel>>6)
                                                {
                                                        case 0: case 1: getm7pixel((xx&1023),(yy&1023)); break;
                                                        case 2: col=0; break;
                                                        case 3: col=ppu.vram[(((yy&7)<<4)+((xx&7)<<1)+1)&0xFFFF]; break;
                                                }
                                        }
                                        else
                                        {
                                                getm7pixel(xx,yy);
                                        }
                                        if (col) *pb=col;
                                        aa+=ma;
                                        cc+=mc;
                                        pb++;
                                }
//                                bb+=((signed short)m7bb);
//                                dd+=((signed short)m7dd);
                                break;
//#endif

/*                                case 7:
                                baddr=(line>>3)<<8;
                                for (xx=0;xx<32;xx++)
                                {
                                        tile=ppu.vram[baddr]; baddr+=2;
                                        tile<<=6;
                                        tile+=((line&7)<<3);
                                        xx<<=3;
                                        tile<<=1;
                                        tile++;
                                        lines[line].mask=1;
                                        if (lines[line].mask)
                                        {
                                                if (ppu.vram[tile]) ppu.b->line[line+16][xx+16]  =ppu.vram[tile]; tile+=2;
                                                if (ppu.vram[tile])ppu.b->line[line+16][xx+1+16]=ppu.vram[tile]; tile+=2;
                                                if (ppu.vram[tile])ppu.b->line[line+16][xx+2+16]=ppu.vram[tile]; tile+=2;
                                                if (ppu.vram[tile])ppu.b->line[line+16][xx+3+16]=ppu.vram[tile]; tile+=2;
                                                if (ppu.vram[tile])ppu.b->line[line+16][xx+4+16]=ppu.vram[tile]; tile+=2;
                                                if (ppu.vram[tile])ppu.b->line[line+16][xx+5+16]=ppu.vram[tile]; tile+=2;
                                                if (ppu.vram[tile])ppu.b->line[line+16][xx+6+16]=ppu.vram[tile]; tile+=2;
                                                if (ppu.vram[tile])ppu.b->line[line+16][xx+7+16]=ppu.vram[tile]; tile+=2;
                                        }
                                        else
                                        {
                                                ppu.b->line[line][xx]  =ppu.vram[tile]; tile+=2;
                                                ppu.b->line[line][xx+1]=ppu.vram[tile]; tile+=2;
                                                ppu.b->line[line][xx+2]=ppu.vram[tile]; tile+=2;
                                                ppu.b->line[line][xx+3]=ppu.vram[tile]; tile+=2;
                                                ppu.b->line[line][xx+4]=ppu.vram[tile]; tile+=2;
                                                ppu.b->line[line][xx+5]=ppu.vram[tile]; tile+=2;
                                                ppu.b->line[line][xx+6]=ppu.vram[tile]; tile+=2;
                                                ppu.b->line[line][xx+7]=ppu.vram[tile]; tile+=2;
                                        }
                                        xx>>=3;
                                }
                                break;*/
                                case 8:
                                for (xx=0;xx<33;xx++)
                                {
                                        tile=ppu.vramw[baddr+xlookup[lines[line].xsize[bg]][x&63]];
                                        if ((tile&0x2000)==pri && !(!(tile&0x3FF) && lines[line].mask))
                                        {
                                                if (tile&0x8000) temp=((tile&1023)<<5)+lines[line].chr[bg]+(y^7);
                                                else             temp=((tile&1023)<<5)+lines[line].chr[bg]+y;
                                                data.w.a=ppu.vramw[temp];
                                                data.w.b=ppu.vramw[temp+8];
                                                data.w.c=ppu.vramw[temp+16];
                                                data.w.d=ppu.vramw[temp+24];
                                                datml=data.l.a|data.l.b;
                                                hflip=(tile&0x4000)?1:0;
                                                if (lines[line].mask && datml)
                                                {
                                                        p[(xx<<1)+hflip]&=   ~ppu.masktable[hflip][datm>>4];
                                                        p[(xx<<1)+hflip]|=   ppu.bittable[hflip][data.b.a>>4]|(ppu.bittable[hflip][data.b.b>>4]<<1)|(ppu.bittable[hflip][data.b.c>>4]<<2)|(ppu.bittable[hflip][data.b.d>>4]<<3)|(ppu.bittable[hflip][data.b.e>>4]<<4)|(ppu.bittable[hflip][data.b.f>>4]<<5)|(ppu.bittable[hflip][data.b.g>>4]<<6)|(ppu.bittable[hflip][data.b.h>>4]<<7);
                                                        p[(xx<<1)+(1^hflip)]&=~ppu.masktable[hflip][datm&0xF];
                                                        p[(xx<<1)+(1^hflip)]|=ppu.bittable[hflip][data.b.a&0xF]|(ppu.bittable[hflip][data.b.b&0xF]<<1)|(ppu.bittable[hflip][data.b.c&0xF]<<2)|(ppu.bittable[hflip][data.b.d&0xF]<<3)|(ppu.bittable[hflip][data.b.e&0xF]<<4)|(ppu.bittable[hflip][data.b.f&0xF]<<5)|(ppu.bittable[hflip][data.b.g&0xF]<<6)|(ppu.bittable[hflip][data.b.h&0xF]<<7);
                                                }
                                                if (!lines[line].mask)
                                                {
                                                        p[(xx<<1)+hflip]=    ppu.bittable[hflip][data.b.a>>4]|(ppu.bittable[hflip][data.b.b>>4]<<1)|(ppu.bittable[hflip][data.b.c>>4]<<2)|(ppu.bittable[hflip][data.b.d>>4]<<3)|(ppu.bittable[hflip][data.b.e>>4]<<4)|(ppu.bittable[hflip][data.b.f>>4]<<5)|(ppu.bittable[hflip][data.b.g>>4]<<6)|(ppu.bittable[hflip][data.b.h>>4]<<7);
                                                        p[(xx<<1)+(1^hflip)]=ppu.bittable[hflip][data.b.a&0xF]|(ppu.bittable[hflip][data.b.b&0xF]<<1)|(ppu.bittable[hflip][data.b.c&0xF]<<2)|(ppu.bittable[hflip][data.b.d&0xF]<<3)|(ppu.bittable[hflip][data.b.e&0xF]<<4)|(ppu.bittable[hflip][data.b.f&0xF]<<5)|(ppu.bittable[hflip][data.b.g&0xF]<<6)|(ppu.bittable[hflip][data.b.h&0xF]<<7);
                                                }
                                        }
                                        x++;
                                }
                                break;

                                case 0x14:
                                pb=(unsigned char *)(((ppu.b->line[line+16]))+16);
                                hmos=-1;
                                for (xx=0;xx<66;xx+=2)
                                {
//                                        printf("B %i\n",hmos);
//                                        printf("Line %03i xx %02i hmos %02i mosaic %i\n",line,xx,hmos,lines[line].mosaic);
                                        if (hmos>=7) /*This next tile is entirely pre-fetched data*/
                                        {
//                                                printf("hmos %i xx %i big\n",hmos,xx<<2);
                                                if (mosmsk)
                                                   p[xx]=p[xx+1]=mosdatl; /*Fill tile with 1 colour*/
                                                hmos-=8;
                                                if (hmos==-1) hmos=lines[line].mosaic;
                                        }
#if 0
                                        else if (hmos>4) /*One data change occurs in this tile*/
                                        {
//                                                printf("hmos %i xx %i med\n",hmos,xx<<2);
                                                if (mosmsk) /*Fill in first part of tile*/
                                                {
                                                        p[xx]=mosdatl;
                                                        pb[(xx<<2)+4]=mosdat;
                                                        if (hmos>5) pb[(xx<<2)+5]=mosdat;
                                                        if (hmos>6) pb[(xx<<2)+6]=mosdat;
                                                }
                                                tile=ppu.vramw[baddr+xlk[x&63]]; /*Fetch new tile data*/
//                                                printf("%04X %04X\n",tile&0x2000,pri);
                                                if ((tile&0x2000)==pri)
                                                {
//                                                        printf("New tile data %i  ",hmos);
                                                        col=((tile>>10)&7)<<4;
                                                        temptile=((tile&1023)+(lines[line].chr[bg]>>4))<<1;
                                                        hflip=(tile&0x4000)?1:0;
                                                        if (tile&0x8000) y^=7;
                                                        tilep=tiless[temptile][hflip][y];
                                                        tilebp=(unsigned char *)tilep;
                                                        maskp=tilemask[temptile][hflip][y];
                                                        maskbp=(unsigned char *)maskp;
                                                        mosdat=tilebp[hmos]|(tilebp[hmos+128]<<2)|col;
                                                        mosmsk=tilebp[hmos]|tilebp[hmos+128];
//                                                        printf("%02X %02X %02X\n",mosdat,col,tilebp[hmos]);
//                                                        mosmsk=maskbp[hmos]|maskbp[hmos+128];
                                                        mosdatl=hmostable[mosdat];
//                                                        printf("  mask %i dat %02X\n",mosmsk,mosdat);
                                                }
                                                else
                                                   mosmsk=0;
                                                hmos-=8;
//                                                if (mosmsk) /*Fill in second part of tile*/
//                                                {
//                                                        printf("second - hmos = %i\n",hmos);
                                                        if (hmos<=-3) pb[(xx<<2)+5]=mosdat;
                                                        if (hmos<=-2) pb[(xx<<2)+6]=mosdat;
                                                        if (hmos<=-1) pb[(xx<<2)+7]=mosdat;
//                                                }
//                                                printf("hmos now %i %i ",hmos,lines[line].mosaic);
                                                hmos+=lines[line].mosaic+1;
//                                                printf("%i\n",hmos);
                                        }
#endif
                                        else /*Multiple data changes in this tile*/
                                        {
                                                tile=ppu.vramw[baddr+xlk[x&63]]; /*Fetch tile*/
                                                if ((tile&0x2000)==pri)
                                                {
                                                        col=((tile>>10)&7)<<4;
                                                        temptile=((tile&1023)+(lines[line].chr[bg]>>4))<<1;
                                                        hflip=(tile&0x4000)?1:0;
                                                        if (tile&0x8000) y^=7;
                                                        tilep=tiless[temptile][hflip][y];
                                                        tilebp=(unsigned char *)tilep;
                                                        maskp=tilemask[temptile][hflip][y];
                                                        maskbp=(unsigned char *)maskp;
//                                                        printf("hmos %i xx %i sm\n",hmos,xx<<2);
                                                        for (x2=0;x2<8;x2++) /*Cycle through each pixel*/
                                                        {
                                                                if (hmos==-1)
                                                                {
                                                                        mosdat=tilebp[x2]|(tilebp[x2+128]<<2)|col;
                                                                        mosmsk=tilebp[hmos]|tilebp[hmos+128];
//                                                                        mosmsk=maskbp[x2]|maskbp[x2+128];
                                                                        mosdatl=hmostable[mosdat];
//                                                                        printf("mask %i\n",mosmsk);
//                                                                        printf("%i %02X %02X %02X\n",x2,mosdat,col,tilebp[x2]);
                                                                        mosdatl=hmostable[mosdat];
                                                                        hmos=lines[line].mosaic;
                                                                }
                                                                hmos--;
                                                                if (mosmsk) pb[(xx<<2)+x2]=mosdat;
                                                        }
                                                }
                                        }
                                        x++;
                                }
                                break;
                        }
                        }
                        lines[line].mask=1;
                }
                skipdraw:
        }
}

void renderscreen()
{
        unsigned int line,c,d,s,br=0;
        PALETTE temppal;
        unsigned short baddr,tempw,tempw2;
        int r,g,b,clip,clipm,halfcol;
        for (c=0;c<4;c++)
        {
                if (rescan[c])
                {
                        rescan[c]=0;
                        switch (bgdat[c])
                        {
                                case 0: s=1024; break;
                                case 1: case 2: s=2048; break;
                                case 3: s=4096; break;
                        }
                        baddr=ppu.bg[c]>>1;
                        prioritybuffer[c][0]=prioritybuffer[c][1]=0;
                        for (d=0;d<s;d++)
                        {
                                if (ppu.vramw[baddr]&0x2000) prioritybuffer[c][1]=1;
                                else                         prioritybuffer[c][0]=1;
                                if (prioritybuffer[c][0] && prioritybuffer[c][1]) d=s;
                                baddr++;
                        }
                }
        }
//        printf("VBL\n");
//        decodesprites();
        updatetiles();
        for (line=0;line<224;line++)
        {
                if (lines[line].mode==7) lines[line].mask=1;
                else                     lines[line].mask=0;
                if (!bit16)                    hline(ppu.b,16,line+16,272,0);
                else if (lines[line].cgwsel&2) { hline(ppu.s,16,line+16,272,0x4000); lines[line].mask=1; }
                else                           hline(ppu.s,16,line+16,272,0);
        }
        if (prioritybuffer[3][0]) drawline(3,0,0,1);
        if (prioritybuffer[2][0]) drawline(2,0,0,1);
        dosprites(0,1);
        if (soundupdate && spcemu)
        {
                soundupdate=0;
                updatesound();
        }
        if (prioritybuffer[3][1]) drawline(3,1,0,1);
        if (prioritybuffer[2][1]) drawline(2,1,0,1);
        dosprites(1,1);
        if (soundupdate && spcemu)
        {
                soundupdate=0;
                updatesound();
        }
        if (prioritybuffer[1][0]) drawline(1,0,0,1);
        if (prioritybuffer[0][0]) drawline(0,0,0,1);
        dosprites(2,1);
        if (soundupdate && spcemu)
        {
                soundupdate=0;
                updatesound();
        }
        if (prioritybuffer[1][1]) drawline(1,1,0,1);
        if (prioritybuffer[0][1]) drawline(0,1,0,1);
        dosprites(3,1);
        if (soundupdate && spcemu)
        {
                soundupdate=0;
                updatesound();
        }
        for (line=0;line<224;line++) lines[line].mask=1;
        drawline(2,1,1,1);
        if (bit16)
        {
                for (line=0;line<224;line++)
                {
                        if (lines[line].mode==7) lines[line].mask=1;
                        else                     lines[line].mask=0;
                        if (bit16 && (lines[line].cgadsub&0x20)) { hline(ppu.b,16,line+16,272,0x8080); lines[line].mask=1; }
                        else                                     hline(ppu.b,16,line+16,272,0);
                }
        }
        if (prioritybuffer[3][0]) drawline(3,0,0,0);
        if (prioritybuffer[2][0]) drawline(2,0,0,0);
        dosprites(0,0);
        if (soundupdate && spcemu)
        {
                soundupdate=0;
                updatesound();
        }
        if (prioritybuffer[3][1]) drawline(3,1,0,0);
        if (prioritybuffer[2][1]) drawline(2,1,0,0);
        dosprites(1,0);
        if (soundupdate && spcemu)
        {
                soundupdate=0;
                updatesound();
        }
        if (prioritybuffer[1][0]) drawline(1,0,0,0);
        if (prioritybuffer[0][0]) drawline(0,0,0,0);
        dosprites(2,0);
        if (soundupdate && spcemu)
        {
                soundupdate=0;
                updatesound();
        }
        if (prioritybuffer[1][1]) drawline(1,1,0,0);
        if (prioritybuffer[0][1]) drawline(0,1,0,0);
        dosprites(3,0);
        if (soundupdate && spcemu)
        {
                soundupdate=0;
                updatesound();
        }
        for (line=0;line<224;line++) lines[line].mask=1;
        drawline(2,1,1,0);
        if (bit16)
        {
//                printf("CGWSEL %02X clipm %i %i %i\n",lines[0].cgwsel,clipm,window[2][0],window[2][8]);
                for (d=16;d<240;d++)
                {
                        if (lines[d-16].wchg)
                        {
                                for (c=0;c<256;c++)
                                {
                                        if (lines[d-16].wobjsel&0x20)
                                        {
                                                if (c>=lines[d-16].w1l && c<=lines[d-16].w1r) window[d-16][c]=(!(lines[d-16].wobjsel&0x10))?0:1;
                                                else                                          window[d-16][c]=((lines[d-16].wobjsel&0x10))?0:1;
                                        }
                                        else
                                           window[d-16][c]=0;
                                        if (lines[d-16].wobjsel&0x80)
                                        {
                                                if (c>=lines[d-16].w2l && c<=lines[d-16].w2r) window[d-16][c]=(!(lines[d-16].wobjsel&0x40))?0:1;
                                                else                                          window[d-16][c]=((lines[d-16].wobjsel&0x40))?0:1;
                                        }
                                        else
                                           window[1][c]=0;
                                        switch ((wobjlog>>2)&3)
                                        {
                                                case 0: window[2][c]=window[0][c]|window[1][c]; break; /*OR*/
                                                case 1: window[2][c]=window[0][c]&window[1][c]; break; /*AND*/
                                                case 2: window[2][c]=window[0][c]^window[1][c]; break; /*XOR*/
                                                case 3: window[2][c]=!(window[0][c]^window[1][c]); break; /*XNOR*/
                                        }
                                }
                        }
                        clip=clipm=0;
                        if ((lines[d-16].cgwsel&0x30)==0x10) clip=2;
                        if ((lines[d-16].cgwsel&0x30)==0x20) clip=1;
                        if ((lines[d-16].cgwsel&0xC0)==0x40) clipm=2;
                        if ((lines[d-16].cgwsel&0xC0)==0x80) clipm=1;
                        for (c=16;c<272;c++)
                        {
                                if ((((unsigned short *)ppu.b->line[d])[c]&0x8000))
                                {
                                        halfcol=1;
                                        tempw=cgramw[((unsigned short *)ppu.b->line[d])[c]&255];
                                        if (lines[d-16].cgwsel&2 && !(((unsigned short *)ppu.s->line[d])[c]&0x4000)) { tempw2=((unsigned short *)ppu.s->line[d])[c]=cgramw[(((unsigned short *)ppu.s->line[d])[c])&0xFF]; }
                                        else                                                                         { tempw2=lines[d-16].fixedcol; halfcol=0; }
                                        if (clip)
                                        {
                                                if (window[2][c-16]==(clip-1)) tempw2=0;
                                        }
                                        if (clipm)
                                        {
                                                if (window[2][c-16]==(clipm-1))
                                                {
                                                        tempw=0;
                                                }
                                        }
                                        if ((lines[d-16].cgadsub&0x40) && halfcol)
                                        {
                                                if (lines[d-16].cgadsub&0x80)
                                                {
                                                        r=((tempw&31)>>1)-((tempw2&31)>>1); if (r<0) r=0;
                                                        g=(((tempw>>6)&31)>>1)-(((tempw2>>6)&31)>>1); if (g<0) g=0;
                                                        b=(((tempw>>11)&31)>>1)-(((tempw2>>11)&31)>>1); if (b<0) b=0;
                                                }
                                                else
                                                {
                                                        r=((tempw&31)>>1)+((tempw2&31)>>1);
                                                        g=(((tempw>>6)&31)>>1)+(((tempw2>>6)&31)>>1);
                                                        b=(((tempw>>11)&31)>>1)+(((tempw2>>11)&31)>>1);
                                                }
                                                tempw=r|(g<<6)|(b<<11);
                                                ((unsigned short *)ppu.b->line[d])[c]=tempw;
                                        }
                                        else
                                        {
                                                if (lines[d-16].cgadsub&0x80)
                                                {
                                                        r=(tempw&31)-(tempw2&31); if (r<0) r=0;
                                                        g=((tempw>>6)&31)-((tempw2>>6)&31); if (g<0) g=0;
                                                        b=((tempw>>11)&31)-((tempw2>>11)&31); if (b<0) b=0;
                                                }
                                                else
                                                {
                                                        r=(tempw&31)+(tempw2&31); if (r>31) r=31;
                                                        g=((tempw>>6)&31)+((tempw2>>6)&31); if (g>31) g=31;
                                                        b=((tempw>>11)&31)+((tempw2>>11)&31); if (b>31) b=31;
                                                }
                                                tempw=r|(g<<6)|(b<<11);
                                                ((unsigned short *)ppu.b->line[d])[c]=tempw;
                                        }
                                }
                                else
                                {
                                        if (clipm && (window[2][c-16]==(clipm-1))) ((unsigned short *)ppu.b->line[d])[c]=0;
                                        else                                       ((unsigned short *)ppu.b->line[d])[c]=cgramw[(((unsigned short *)ppu.b->line[d])[c])&0xFF];
                                }
                        }
                }
        }
        if (!bit16)
        {
//                textprintf(ppu.b,font,16,16,makecol(255,255,255),"%i %02X",fpsc,ppu.cgwsel);
                blit(ppu.b,screen,16,16,72,38,256,224);
        }
        else if (subscreenon)
        {
//                textprintf(ppu.b,font,16,16,0xFFFFFFFF,"%i %02X",fpsc,ppu.cgwsel);
                blit(ppu.b,screen,16,16,72,38,256,224);
        }
        else
        {
//                textprintf(ppu.s,font,16,16,0xFFFFFFFF,"%i",fpsc);
                blit(ppu.s,screen,16,16,72,38,256,224);
        }
        br=0;
        for (c=0;c<224;c++)
        {
                if (br<lines[c].bright)
                {
                        br=lines[c].bright;
//                        printf("BR now equal %02X at line %i\n",br,line);
                }
        }
//        if (sblankchk && (ppu.sdr&0x80)) { br=0xF; }
//        printf("BR=%i\n",br);
//        br=15;
        if (!bit16)
        {
                for (c=0;c<256;c++)
                {
                        temppal[c].r=((unsigned int)ppu.pal[c].r*(br&0xF))>>4;
                        temppal[c].g=((unsigned int)ppu.pal[c].g*(br&0xF))>>4;
                        temppal[c].b=((unsigned int)ppu.pal[c].b*(br&0xF))>>4;
                }
                for (c=0;c<256;c++)
                {
                        set_color(c,&temppal[c]);
                }
        }
//        set_palette(temppal);
        if (soundupdate && spcemu)
        {
                soundupdate=0;
                updatesound();
        }
//        set_palette(desktop_palette);
/*        for (line=0;line<256;line++)
        {
                if (ppu.paldirty[line]) set_color(line,&ppu.pal[line]);
                ppu.paldirty[line]=0;
        }*/
}


void drawchar(int tile, int x, int y, int col)
{
        unsigned char dat,dat1,dat2,dat3,dat4;
        unsigned short addr=tile<<5;
        int yy,xx;
        if (!x) textprintf(dasbuffer,font,128,y,makecol(255,255,255),"%04X",addr);
        for (yy=0;yy<8;yy++)
        {
                dat1=ppu.vram[addr];
                dat2=ppu.vram[addr+1];
                dat3=ppu.vram[addr+16];
                dat4=ppu.vram[addr+17];
                addr+=2;
                for (xx=7;xx>-1;xx--)
                {
                        dat=(dat1&1);
                        dat|=((dat2&1)<<1);
                        dat|=((dat3&1)<<2);
                        dat|=((dat4&1)<<3);
                        dat|=(col<<4);
                        putpixel(dasbuffer,x+xx,y+yy,dat);
                        dat1>>=1;
                        dat2>>=1;
                        dat3>>=1;
                        dat4>>=1;
                }
        }
}

void dumpchar()
{
        int page=0,col=0;
        int c;
        PALETTE temppal;
        int tile,x,y;
        while (key[KEY_F1]) yield_timeslice();
        clear(screen);
        while (!key[KEY_F10])
        {
                if (key[KEY_UP])
                {
                        while (key[KEY_UP]) yield_timeslice();
                        page++;
                        page&=3;
                }
                if (key[KEY_DOWN])
                {
                        while (key[KEY_DOWN]) yield_timeslice();
                        page--;
                        page&=3;
                }
                if (key[KEY_LEFT])
                {
                        while (key[KEY_LEFT]) yield_timeslice();
                        col++;
                        col&=15;
                }
                if (key[KEY_RIGHT])
                {
                        while (key[KEY_RIGHT]) yield_timeslice();
                        col--;
                        col&=15;
                }
                if (key[KEY_D])
                {
                        while (key[KEY_D]) yield_timeslice();
                        desktop_palette[0].r=desktop_palette[0].g=desktop_palette[0].b=0;
                        desktop_palette[15].r=desktop_palette[15].g=desktop_palette[15].b=63;
                        set_palette(desktop_palette);
                }
                if (key[KEY_F])
                {
                        while (key[KEY_F]) yield_timeslice();
                        set_palette(ppu.pal);
                }
                tile=page<<9;
                ppu.vram[0xf200]=ppu.vram[0xf201]=ppu.vram[0xf210]=ppu.vram[0xf211]=0xFF;
                for (y=0;y<32;y++)
                {
                        for (x=0;x<16;x++)
                        {
                                drawchar(tile++,x<<3,y<<3,col);
                        }
                }
                textprintf(dasbuffer,font,128,0,makecol(255,255,255),"Page %i",page);
                textprintf(dasbuffer,font,128,8,makecol(255,255,255),"Col  %X",col);
                blit(dasbuffer,screen,0,0,0,0,256,256);
        }
        clear(screen);
//        printf("%01X\n",ppu.sdr&0xF);
}
