#ifndef EF_PLUGIN_MANAGER_HPP
#define EF_PLUGIN_MANAGER_HPP

#include "EFPlatform.hpp"
#include "EFSingleton.hpp"
#include <windows.h>

namespace EFramework
{
	/// Loads and manages a set of plugins and information about them.
	class EF_EXPORT EFPluginManager : public EFSingleton< EFPluginManager >
	{
	public:
		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Destructors

		/** The default destructor.
		  */
		~EFPluginManager();

		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Plugin Loading Functions

		/** Loads all the .dll files found in the specified directory.
		  */
		void LoadPlugins(const EFString& directory);
		/** Loads a single .dll file with the specified location.
		  */
		void LoadPlugin(const EFString& directory, const EFString& file);
		/** Removes all of the plugins loaded into memory from memory.
		  */
		void UnloadPlugins();

		///////////////////////////////////////////////////////////////////////////////////////////////////
		// DLL Information Functions

		/** Returns the name of plugin file for the plugin at the specified index.
		  */
		EFString GetPluginFileName(ulong index) const;
		/** Returns the number of plugin files that were loaded.
		  */
		ulong GetNumberOfPlugins() const;
		/** Returns the specified procedure within the specified DLL.
		  */
		void* GetProcedure(const EFString& plugin, const EFString& procedureName);
	protected:
		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Constructors

		/** The default constructor.
		  */
		EFPluginManager();

		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Private Functions

		/** Places the names of all the files in a specific directory into a vector.
		  */
		void GetFileNames(const EFString& directory, std::vector< EFString >& fileNames);

		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Structures

		/// Defines a plugin and the information about it.
		typedef struct PluginData
		{
			EFString FileName;
			HMODULE  DllHandle;
		};

		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Variables

		std::vector< PluginData > mLoadedPlugins; ///< A vector containing all of the plugins which have been loaded.
		friend class EFSingleton;
	};
} // Namespace EFramework

#endif // EF_PLUGIN_MANAGER_HPP