#include "PSXAboutDialog.hpp"

namespace NeoPSX
{
	PSXAboutDialog::PSXAboutDialog(EFVersionInfo NeoPSXV, EFVersionInfo EFrameworkV)
	: mV1(NeoPSXV),
	  mV2(EFrameworkV)
	{
		//INT      ColorChangeItems[2] = { COLOR_INFOTEXT, COLOR_INFOBK };
		//COLORREF ColorItems[2]       = { RGB(0, 0, 0)  , RGB(224, 231, 248) };

		//SetSysColors(2, ColorChangeItems, ColorItems);
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	LRESULT PSXAboutDialog::OnInitDialog(UINT, WPARAM, LPARAM, BOOL)
	{
		//===============================================================
		// Center the window and set the tooltip size.
		//===============================================================
		CenterWindow();
		TTSize(400);

		//===============================================================
		// Make the static text in our dialog a link to the website.
		//===============================================================
		mWebsiteLink.SubclassWindow(GetDlgItem(IDC_ABOUT_LINK));
		mWebsiteLink.SetHyperLink( _T("http://www.zenogais.net") );

		//===============================================================
		// Create our versioning string object.
		//===============================================================
		EFString VersionString;

		//===============================================================
		// Format our NeoPSX version string and set static text.
		//===============================================================
		VersionString = "v" + EFString(mV1.GetString());
		SetDlgItemText(IDC_NEOPSX_VERSION    , (LPCTSTR)VersionString.c_str());

		//===============================================================
		// Format our EFramework version string and set static text.
		//===============================================================
		VersionString = "v" + EFString(mV2.GetString());
		SetDlgItemText(IDC_EFRAMEWORK_VERSION, (LPCTSTR)VersionString.c_str());

		return 0;
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	LRESULT PSXAboutDialog::OnCloseDialog(UINT, WPARAM, LPARAM, BOOL)
	{
		OnCloseCmd(NULL, 0, NULL, NULL);
		return 0;
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	LRESULT PSXAboutDialog::OnCloseCmd(WORD, WORD wID, HWND, BOOL)
	{
		EndDialog( wID );
		return IDOK;
	}
} // Namespace NeoPSX