#include "PSXR3000Debugger.hpp"
#include <atlctrls.h>

namespace NeoPSX
{
	static DWORD R3KRegisterItems[32] =
	{
		IDC_R3K_ZR, IDC_R3K_AT, IDC_R3K_V0, IDC_R3K_V1, IDC_R3K_A0, IDC_R3K_A1, IDC_R3K_A2, IDC_R3K_A3,
		IDC_R3K_T0, IDC_R3K_T1, IDC_R3K_T2, IDC_R3K_T3, IDC_R3K_T4, IDC_R3K_T5, IDC_R3K_T6, IDC_R3K_T7,
		IDC_R3K_S0, IDC_R3K_S1, IDC_R3K_S2, IDC_R3K_S3, IDC_R3K_S4, IDC_R3K_S5, IDC_R3K_S6, IDC_R3K_S7,
		IDC_R3K_T8, IDC_R3K_T9, IDC_R3K_K0, IDC_R3K_K1, IDC_R3K_GP, IDC_R3K_SP, IDC_R3K_FP, IDC_R3K_RA
	};

	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	PSXR3000Debugger::PSXR3000Debugger(TR3000Context* context)
	: mContext( context )
	{
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	LRESULT PSXR3000Debugger::OnInitDialog(UINT, WPARAM, LPARAM, BOOL&)
	{
		CEditT<CWindow> edit;
		for(int i = 0; i < 32; i++)
		{
			edit = GetDlgItem(R3KRegisterItems[i]);
			edit.LimitText( 9 );
		}

		edit = GetDlgItem(IDC_R3K_PC);
		edit.LimitText( 9 );
		edit = GetDlgItem(IDC_R3K_HI);
		edit.LimitText( 9 );
		edit = GetDlgItem(IDC_R3K_LO);
		edit.LimitText( 9 );

		Update();

		return TRUE;
	}

	void PSXR3000Debugger::Update()
	{
		///////////////////////////////////////////////////////////////////////
		// Declare our static hex string.
		///////////////////////////////////////////////////////////////////////
		static char Hex[1024];

		///////////////////////////////////////////////////////////////////////
		// Create our edit control to save heap space.
		///////////////////////////////////////////////////////////////////////
		CEditT<CWindow> edit;

		///////////////////////////////////////////////////////////////////////
		// Loop through and update all the register values.
		///////////////////////////////////////////////////////////////////////
		for(int i = 0; i < 32; i++)
		{
			edit = GetDlgItem(R3KRegisterItems[i]);
			
			_snprintf(Hex, 1024, "%04X %04X", (mContext->Reg[i]>>16), mContext->Reg[i]&0xFFFF);
			edit.Clear();
			edit.SetWindowText((LPCTSTR)Hex);
		}

		///////////////////////////////////////////////////////////////////////
		// Update program counter value and Hi/Lo.
		///////////////////////////////////////////////////////////////////////
		edit = GetDlgItem(IDC_R3K_PC);
		_snprintf(Hex, 1024, "%04X %04X", (mContext->Pc)>>16, (mContext->Pc)&0xFFFF);
		edit.Clear();
		edit.SetWindowText((LPCTSTR)Hex);

		edit = GetDlgItem(IDC_R3K_HI);
		_snprintf(Hex, 1024, "%04X %04X", (mContext->Hi)>>16, (mContext->Hi)&0xFFFF);
		edit.Clear();
		edit.SetWindowText((LPCTSTR)Hex);

		edit = GetDlgItem(IDC_R3K_LO);
		_snprintf(Hex, 1024, "%04X %04X", (mContext->Lo)>>16, (mContext->Lo)&0xFFFF);
		edit.Clear();
		edit.SetWindowText((LPCTSTR)Hex);
	}
} // Namespace NeoPSX