#include "PSXUtility.hpp"
#include "EFramework.hpp"

namespace NeoPSX
{
	//////////////////////////////////////////////////////////////////////////////////////
	//
	//////////////////////////////////////////////////////////////////////////////////////
	void PSXClearMemory(void* Memory, unsigned long Size, char* Message)
	{
		assert(Memory != NULL && Message);
		memset(Memory, 0, Size);
	}

	//////////////////////////////////////////////////////////////////////////////////////
	//
	//////////////////////////////////////////////////////////////////////////////////////
	#ifdef WIN32
		bool Ask(const char* const Question, const char* const Headline, HWND Window)
		{
			return (MessageBox(Window, _T(Question), _T(Headline), MB_YESNO|MB_ICONQUESTION) == IDYES);
		}

		void Message(const char* const Message, const char* const Headline)
		{
			MessageBox(NULL, _T(Message), _T(Headline), MB_OK);
		}

		void Message(const char* const Headline, const char* const Format, ...)
		{
			LPCTSTR MessageBuffer[1024];
			va_list list;

			va_start(list, Format);
			_vsnprintf((char*)MessageBuffer, 1024, Format, list);
			va_end(list);

			MessageBox(NULL, _T((LPCTSTR)MessageBuffer), _T(Headline), MB_OK);
		}
	#endif
} // Namespace NeoPSX