#ifndef EF_FILE_OUTPUT_STREAM_HPP
#define EF_FILE_OUTPUT_STREAM_HPP

#include "EFPlatform.hpp"
#include "EFOutputStream.hpp"

namespace EFramework
{
	/// Defines an output stream to a file containing binary data.
	class EF_EXPORT EFFileOutputStream : public EFOutputStream
	{
	public:
		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Constructors

		/** The default constructor.
		  */
		EFFileOutputStream(const EFString& fileName);

		///////////////////////////////////////////////////////////////////////////////////////////////////
		// File Output Functions

		/** Writes a single character to the file stream.
		  */
		void WriteChar(uchar& value);
		/** Writes a single short integer to the file stream.
		  */
		void WriteShort(ushort& value);
		/** Writes a single integer to the file stream.
		  */
		void WriteInt (uint& value);
		/** Writes a single long integer to the file stream.
		  */
		void WriteLong(ulong& value);
		/** Writes a single boolean value to the file stream.
		  */
		void WriteBool(bool& value);
		/** Writes a group of characters to the file stream.
		  */
		void WriteString(char* value, ulong size);

		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Miscellaneous Functions

		/** Closes the current file output stream.
		  */
		void CloseStream();
	protected:
		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Variables

		std::ofstream mOutputFile; ///< The file to which the data will be output.
	};
} // Namespace EFramework

#endif // EF_FILE_OUTPUT_STREAM_HPP