#ifndef EF_LOG_MANAGER_HPP
#define EF_LOG_MANAGER_HPP

#include "EFLog.hpp"
#include "EFSingleton.hpp"

#pragma warning (disable : 4251)

namespace EFramework
{
	/// A class which creates and manages many log handlers.
	class EF_EXPORT EFLogManager : public EFSingleton< EFLogManager >
	{
	public:
		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Constructors

		/** The default constructor.
		  */
		EFLogManager();

		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Destructors

		/** The default destructor.
		  */
		~EFLogManager();

		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Log Creationg and Retrieval

		/** Creates a new log file and returns a pointer to its handler.
		  */
		EFLog* CreateLog(const EFString& name, bool defaultLog = false);
		/** Retrieves the pointer to a log file handler.
		  */
		EFLog* GetLog(const EFString& name);

		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Default Log Management

		/** Returns a pointer to the default log file handler.
		  */
		EFLog* GetDefaultLog();
		/** Sets the default log file handler.
		  */
		void   SetDefaultLog(EFLog* log);

		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Message Logging

		/** Logs a message to the default log in string form.
		  */
		void LogMessage(const EFString& message, LogMessageLevel level = LML_NORMAL);
		/** Logs a message to the default log in complex form.
		  */
		void LogMessage(LogMessageLevel level, const char* format, ...);
	protected:
		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Variables

		typedef std::map< EFString, EFLog*, std::less<EFString> > LogList;

		EFLog*  mDefault; ///< The default log file handler.
		LogList mLogs;    ///< All the created logs organized in a map.
	};
} // Namespace EFramework

#endif // EF_LOG_MANAGER_HPP