#ifndef EF_SAVE_STATE_HPP
#define EF_SAVE_STATE_HPP

#include "EFInputStream.hpp"
#include "EFOutputStream.hpp"

namespace EFramework
{
	/// Defines the functions all save-state classes will have.
	class EFSaveState
	{
	public:
		/** Saves the current state of this object to the file.
		  */
		virtual void SaveState(EFOutputStream& stream) = 0;
		/** Loads the current state of this object from the file.
		  */
		virtual void LoadState(EFInputStream& stream) = 0;
	};
} // Namespace EFramework

#endif // EF_SAVE_STATE_HPP