#include "EFVersionInfo.hpp"

namespace EFramework
{
	EFVersionInfo::EFVersionInfo(uint Major, uint Minor, uint Patch)
	: vMajor( Major ),
	  vMinor( Minor ),
	  vPatch( Patch )
	{ }

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	char* EFVersionInfo::GetString() const
	{
		static char versionInfo[256];

		sprintf(versionInfo, "%d.%d.%d", vMajor, vMinor, vPatch);
		return versionInfo;
	}

	void EFVersionInfo::SetVersionData(uint Major, uint Minor, uint Patch)
	{
		vMajor = Major;
		vMinor = Minor;
		vPatch = Patch;
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	bool EFVersionInfo::operator < (const EFVersionInfo& right) const
	{
		if(vMajor < right.vMajor)
		{
			return true;
		}
		else if(vMajor == right.vMajor)
		{
			if(vMinor < right.vMinor)
			{
				return true;
			}
			else if(vMinor == right.vMinor)
			{
				if(vPatch < right.vPatch)
				{
					return true;
				}
			}
		}

		return false;
	}

	bool EFVersionInfo::operator == (const EFVersionInfo& right) const
	{
		return (EFString(this->GetString()) == EFString(right.GetString()));
	}

	bool EFVersionInfo::operator > (const EFVersionInfo& right) const
	{
		return !((*this) < right || (*this) == right);
	}
}