#ifndef PSX_EXECUTABLE_LOADER_HPP
#define PSX_EXECUTABLE_LOADER_HPP

#include "PSXMemory.hpp"

namespace NeoPSX
{
	/// Loads a PS-EXE format executable file.
	class PSXExecutableLoader
	{
	public:
		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Constructors

		/** Loads the specified executable file.
		  */
		PSXExecutableLoader();
		
		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Destructors

		/** Performs cleanup of allocated resources 
		  */
		~PSXExecutableLoader();

		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Executable File Loader

		/** Loads the specified file.
		  */
		bool Load(PSXMemory& memory, const EFString& file);
		/** Closes the file that was opened.
		  */
		void Close();

		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Information Retrieval

		/** Returns the program start offset.
		  */
		uint32_t GetPC() const;
		/** Returns the SP register value.
		  */
		uint32_t GetSP() const;
		/** Returns the FP register value.
		  */
		uint32_t GetFP() const;
		/** Returns the GP register value.
		  */
		uint32_t GetGP() const;
		/** Returns the GP0 register value.
		  */
		uint32_t GetGP0() const;
		/** Returns the RA register value.
		  */
		uint32_t GetRA() const;
		/** Returns the K0 register value.
		  */
		uint32_t GetK0() const;
	private:
		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Private Structures 

		/** The Playstation executable file header format. */
		typedef struct TPlaystationExecutableHeader
		{
			// The identification string.
			char Id[8];
			// The text area address (usually NULL)
			uint32_t Text;
			// The data area address (usually NULL)
			uint32_t Data;
			// The program start offset
			uint32_t Pc;
			// The GP register value
			uint32_t Gp;
			// The program load offset and length
			uint32_t TxPtr; uint32_t TxLen;
			// Not Sure...
			uint32_t DaPtr; uint32_t DaLen;
			// Not Sure...
			uint32_t BsPtr; uint32_t BsLen;
			// Not Sure...
			uint32_t SdPtr; uint32_t SdLen;
			// The SP register value
			uint32_t Sp;
			// The FP register value
			uint32_t Fp;
			// The GP0 register value
			uint32_t Gp0;
			// The RA register value
			uint32_t Ra;
			// The K0 register value
			uint32_t K0;
			// The origin of the executable
			char Origin[60];
		};

		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Private Enumerations

		enum ExecutableFileInfo
		{
			EFI_HEADER_SIZE = 2048
		};

		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Private Variables

		TPlaystationExecutableHeader* mHeader; ///< The header for the loaded executable file.
	};
} // Namespace NeoPSX

#endif // PSX_EXECUTABLE_LOADER_HPP