#ifndef PSX_PROCESSOR_DEBUGGER_HPP
#define PSX_PROCESSOR_DEBUGGER_HPP

#include <atlbase.h>
#include <atlwin.h>
#include <atlapp.h>
#include <atldlgs.h>

#include "PSXCOP0Debugger.hpp"
#include "PSXR3000Debugger.hpp"

namespace NeoPSX
{
	/// The processor debugger dialog box.
	class PSXProcessorDebugger : public CPropertySheetImpl<PSXProcessorDebugger>
	{
	public:
		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Message Maps

		BEGIN_MSG_MAP(PSXProcessorDebugger)
			CHAIN_MSG_MAP(CPropertySheetImpl<PSXProcessorDebugger>)
		END_MSG_MAP()

		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Constructors

		/** The default constructor.
		  */
	    PSXProcessorDebugger(TR3000Context* context);

		/////////////////////////////////////////////////////////////////////////////////////////////////
		// The Update Function

		/** Updates the current displayed window.
		  */
		void Update() const;
	private:
		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Private Variables

		std::auto_ptr< PSXR3000Debugger > mPage1; ///< The first property sheet page.
		std::auto_ptr< PSXCOP0Debugger  > mPage2; ///< The second property sheet page.
	};
} // Namespace NeoPSX

#endif // PSX_PROCESSOR_DEBUGGER_HPP