#include <windows.h>
#include <EFramework.hpp>
#include <PSXMainWindow.hpp>

int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
					 LPSTR lpCmdLine, int nCmdShow)
{
	// Setup our highest scope variables.
	INT WindowExitStatus = 0;

	try
	{
		// Ensure that the emulation framework versions are consistent.
		EF_COMPARE_LIBRARY_VERSIONS();

		// Setup our window application.
		EFWindowApplication< NeoPSX::PSXMainWindow > PSXApplication( hInstance );

		// Add the idle time handler.
		PSXApplication.AddIdleHandler( NeoPSX::PSXMainWindow::GetIdleHandler() );

		// Run our window application.
		WindowExitStatus = PSXApplication.Run();
	} 
	catch(EFException& exception) {
		MessageBox(NULL, _T(exception.GetDetailedInformation().c_str()), _T("Exception Caught!"), MB_OK|MB_ICONERROR);
		return 1;
	}
    
	// Return the success of the window execution.
	return WindowExitStatus;
}