#ifndef EF_LOG_HPP
#define EF_LOG_HPP

#include "EFPlatform.hpp"

namespace EFramework
{
	/// Describes the level of detail for log messages.
	enum LogLevel
	{
		LL_LOW    = 1,
		LL_NORMAL = 2,
		LL_BORING = 3
	};

	/// Describes the importance of a message being logged.
	enum LogMessageLevel
	{
		LML_NORMAL   = 1,
		LML_MEDIUM   = 2,
		LML_CRITICAL = 3
	};

	const long LOG_THRESHOLD = 4;

	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	/// Class which creates and manages a single log file.
	class EF_EXPORT EFLog
	{
	public:
		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Constructors

		/** The basic constructor.
		  */
		EFLog(const EFString& name, LogLevel level = LL_NORMAL);

		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Destructors

		/** The default destructor.
		  */
		~EFLog();

		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Log Functions

		/** Log a printf style message to the log file.
		  */
		void LogMessage(LogMessageLevel lml, const char* format, ...);
		/** Logs a message to this log file.
		  */
		void LogMessage(const EFString& message, LogMessageLevel lml = LML_NORMAL);
		/** Sets the message level of this log.
		  */
		void SetLogLevel(LogLevel level);
	protected:
		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Variables
		
		std::ofstream mFile;  ///< The log file handler.
		LogLevel      mLevel; ///< The level of detail of messages in this log file.
	};
} // Namespace EFramework

#endif // EF_LOG_HPP