#ifndef EF_OUTPUT_STREAM_HPP
#define EF_OUTPUT_STREAM_HPP

#include "EFException.hpp"

namespace EFramework
{
	/// Defines the base class for all output streams.
	class EF_EXPORT EFOutputStream
	{
	public:
		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Destructors

		/** The default destructor.
		  */
		virtual ~EFOutputStream();

		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Stream Writing Functions

		/** Writes a single character value to the specified stream.
		  */
		virtual void WriteChar(uchar& value) = 0;
		/** Writes a single short integer to the specified stream.
		  */
		virtual void WriteShort(ushort& value) = 0;
		/** Writes an integer value to the specified stream.
		  */
		virtual void WriteInt(uint& value) = 0;
		/** Writes a long integer value to the specified stream.
		  */
		virtual void WriteLong(ulong& value) = 0;
		/** Writes a boolean variable to the specified stream.
		  */
		virtual void WriteBool(bool& value) = 0;
		/** Writes a string to the specified stream.
		  */
		virtual void WriteString(char* value, ulong size) = 0;

		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Miscellaneous Functions

		/** Closes the current output stream.
		  */
		virtual void CloseStream();
	};
};

#endif // EF_OUTPUT_STREAM_HPP