#ifndef EF_PLATFORM_HPP
#define EF_PLATFORM_HPP

//== Standard C Includes ==//
#include <ctime>
#include <cstdio>
#include <cassert>
#include <cstdlib>
#include <cstdarg>
#include <memory.h>

//== Standard C++ Includes ==//
#include <map>
#include <vector>
#include <memory>
#include <fstream>
#include <iomanip>
#include <sstream>
#include <iostream>

//== Include Basic Types ==//
#include "EFTypes.hpp"

//== Disable Any Annoying Warnings ==//
#pragma warning (disable : 4251)

namespace EFramework
{
	//== DLL Exportation Macros Because I'm Lazy :) ==//
	#if	defined (EFRAMEWORK_CLIENT_BUILD)
			#define EF_EXPORT __declspec( dllexport )
	#else
			#define EF_EXPORT __declspec( dllimport )
	#endif

	//== Utility Macros Which Aid In Deleting Objects ==//
	#define EF_UTIL_DELETE( object ) { \
		if(object != NULL) \
		{ \
			delete object; \
			object = NULL; \
		} \
	}

	#define EF_UTIL_DELETE_ARRAY( array ) { \
		if(array != NULL) \
		{ \
			delete [] array; \
			array = NULL; \
		} \
	}
} // Namespace EFramework

#endif // EF_PLATFORM_HPP