#ifndef EF_ZIP_OUTPUT_STREAM_HPP
#define EF_ZIP_OUTPUT_STREAM_HPP

#include "EFPlatform.hpp"
#include "EFOutputStream.hpp"

//== We Need To Define ZLIB_WINAPI since we're using MSVC++ ==//
#define ZLIB_WINAPI
#include "zlib.h"

namespace EFramework
{
	/// Defines an output stream to a file containing GZIPed data.
	class EF_EXPORT EFZipOutputStream : public EFOutputStream
	{
	public:
		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Constructors

		/** The default constructor.
		  */
		EFZipOutputStream(const EFString& fileName);

		///////////////////////////////////////////////////////////////////////////////////////////////////
		// ZIP File Output Functions

		/** Writes a single character to the compressed stream.
		  */
		void WriteChar(uchar& value);
		/** Writes a single short integer to the compressed stream.
		  */
		void WriteShort(ushort& value);
		/** Writes a single integer to the compressed stream.
		  */
		void WriteInt(uint& value);
		/** Writes a single long integer to the compressed stream.
		  */
		void WriteLong(ulong& value);
		/** Writes a boolean value to the compressed stream.
		  */
		void WriteBool(bool& value);
		/** Writes a group of characters to the compressed stream.
		  */
		void WriteString(char* value, ulong size);

		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Miscellaneous Functions

		/** Close the current compressed file output stream.
		  */
		void CloseStream();
	protected:
		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Variables

		gzFile mCompressedFile; ///< The file to which compressed data will be written.
	};
} // Namespace EFramework

#endif // EF_ZIP_OUTPUT_STREAM_HPP