#include "EFFileInputStream.hpp"

namespace EFramework
{
	EFFileInputStream::EFFileInputStream(const EFString& fileName)
	{
		//=====================================================
		// Attempt to open binary file for reading.
		//=====================================================
		mInputFile.open(fileName.c_str(), std::ios::binary);

		//=====================================================
		// Check if the file was opened successfully.
		//=====================================================
		if(!mInputFile.is_open())
		{
			EF_THROW(EFException::EC_STREAM_ERROR, "Could not open binary file for reading.");
		}
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	uchar EFFileInputStream::ReadChar()
	{
		// Return a character.
		uchar ret;
		mInputFile.read((char*)&ret, sizeof(uchar));
		return ret;
	}

	ushort EFFileInputStream::ReadShort()
	{
		// Return a short integer.
		ushort ret;
		mInputFile.read((char*)&ret, sizeof(ushort));
		return ret;
	}

	uint EFFileInputStream::ReadInt()
	{
		// Return an integer.
		uint ret;
		mInputFile.read((char*)&ret, sizeof(uint));
		return ret;
	}

	ulong EFFileInputStream::ReadLong()
	{
		// Return a long integer.
		ulong ret;
		mInputFile.read((char*)&ret, sizeof(ulong));
		return ret;
	}

	bool EFFileInputStream::ReadBool()
	{
		// Return a boolean.
		bool ret;
		mInputFile.read((char*)&ret, sizeof(bool));
		return ret;
	}

	void EFFileInputStream::ReadString(char* variable, ulong size)
	{
		// Return a group of charcters.
		mInputFile.read(variable, size);
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	void EFFileInputStream::CloseStream()
	{
		if(!mInputFile.is_open())
		{
			mInputFile.close();
		}
		else
		{
			EF_THROW(EFException::EC_STREAM_ERROR, "Attempted to close a binary file that is not open.");
		}
	}
} // Namespace EFramework