#ifndef PSX_COP0_DEBUGGER_HPP
#define PSX_COP0_DEBUGGER_HPP

#include <atlbase.h>
#include <atlwin.h>
#include <atlapp.h>
#include <atldlgs.h>
#include "../resource.h"

#include "PSXInterpreter.hpp"

namespace NeoPSX
{
	/// The playstation CoProcessor zero debugger dialog.
	class PSXCOP0Debugger : public CPropertyPageImpl< PSXCOP0Debugger >
	{
	public:
		/////////////////////////////////////////////////////////////////////////////////////////////////
		// The Message Map

		BEGIN_MSG_MAP(PSXCOP0Debugger)
			MESSAGE_HANDLER(WM_INITDIALOG, OnInitDialog)
			CHAIN_MSG_MAP  (CPropertyPageImpl<PSXCOP0Debugger>)
		END_MSG_MAP()

		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Public Enumerations

		enum { IDD = IDD_PROP_PAGE_COP0 };

		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Constructors
		
		/** The default constructor.
		  */
		PSXCOP0Debugger(TR3000Context* context);

		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Overridden Functions

		LRESULT OnInitDialog(UINT, WPARAM, LPARAM, BOOL&);

		/////////////////////////////////////////////////////////////////////////////////////////////////
		// The Update Functions

		/** Updates all of the register values being displayed.
		  */
		void Update();
	private:
		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Private Variables

		TR3000Context* mContext; ///< The COP0 context data.
	};
} // Namespace NeoPSX

#endif // PSX_COP0_DEBUGGER_HPP