#ifndef PSX_UTILITY_HPP
#define PSX_UTILITY_HPP

#if defined (_MSC_VER) || defined (_WINDOWS) || defined (WIN32)
#include <windows.h>
#endif

#include "EFramework.hpp"

namespace NeoPSX
{
	//////////////////////////////////////////////////////////////////////////////////////
	// Type casting macros
	//////////////////////////////////////////////////////////////////////////////////////
	#define CAST_SIZE(type, object) (*reinterpret_cast<type*>(&(object)))
	#if defined (_MSC_VER) || defined (_WINDOWS) || defined (WIN32)
		#define ALIGN(alignment) __declspec(align(alignment))
	#else
		#define ALIGN(alignment) __aligned__(alignment)
	#endif

	//////////////////////////////////////////////////////////////////////////////////////
	// Some other helper functions
	//////////////////////////////////////////////////////////////////////////////////////
	void PSXClearMemory(void* Memory, unsigned long Size, char* Message = "Pointer is set to invalid address");

	//////////////////////////////////////////////////////////////////////////////////////
	// Templates for address ranges.
	//////////////////////////////////////////////////////////////////////////////////////
	template<uint32_t LowAddr, uint32_t HighAddr>
	class ADDRESSRANGE
	{
	public:
		static bool InRange(uint32_t Address)
		{
			return (Address >= LowAddr && Address <= HighAddr);
		}
	};

	template<class Range1, class Range2>
	class ADDRESSRANGEGROUP
	{
	public:
		static bool InRange(uint32_t Address)
		{
			return (Range1::InRange(Address) || Range2::InRange(Address));
		}
	};

	//////////////////////////////////////////////////////////////////////////////////////
	// Windows specific functions
	//////////////////////////////////////////////////////////////////////////////////////
	#if defined (_MSC_VER) || defined (_WINDOWS) || defined (WIN32)
		bool Ask(const char* const Question, const char* const Headline, HWND Window = NULL);
		void Message(const char* const Message, const char* const Headline);
		void Message(const char* const Headline, const char* const Format, ...);
	#endif
} // Namespace NeoPSX

#endif // PSX_UTILITY_HPP