#include "PSXCOP0Debugger.hpp"
#include <atlctrls.h>

namespace NeoPSX
{
	static DWORD COP0RegisterItems[17] =
	{
		IDC_COP0_INDX  , IDC_COP0_RAND, IDC_COP0_TLBL, IDC_COP0_BPC , IDC_COP0_CTXT, IDC_COP0_BDA  , IDC_COP0_PIDMASK, IDC_COP0_DCIC,
		IDC_COP0_BADV  , IDC_COP0_BDAM, IDC_COP0_TLBH, IDC_COP0_BPCM, IDC_COP0_STAT, IDC_COP0_CAUSE, IDC_COP0_EPC    , IDC_COP0_PRID,
		IDC_COP0_ERRREG
	};

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	PSXCOP0Debugger::PSXCOP0Debugger(TR3000Context* context)
	: mContext( context )
	{ }

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	LRESULT PSXCOP0Debugger::OnInitDialog(UINT, WPARAM, LPARAM, BOOL&)
	{
		CEditT<CWindow> edit;
		for(int i = 0; i < 17; i++)
		{
			edit = GetDlgItem( COP0RegisterItems[i] );
			edit.LimitText( 9 );
		}

		Update();

		return TRUE;
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	void PSXCOP0Debugger::Update()
	{
		///////////////////////////////////////////////////////////////////////
		// Declare our static hex string.
		///////////////////////////////////////////////////////////////////////
		static char Hex[1024];

		///////////////////////////////////////////////////////////////////////
		// Create our edit control to save heap space.
		///////////////////////////////////////////////////////////////////////
		CEditT<CWindow> edit;

		///////////////////////////////////////////////////////////////////////
		// Loop through and update all the register values.
		///////////////////////////////////////////////////////////////////////
		for(int i = 0; i < 17; i++)
		{
			edit = GetDlgItem(COP0RegisterItems[i]);
			
			_snprintf(Hex, 1024, "%04X %04X", (mContext->Cp0[i]>>16)&0xFFFF, mContext->Cp0[i]&0xFFFF);
			edit.Clear();
			edit.SetWindowText((LPCTSTR)Hex);
		}
	}
} // Namespace NeoPSX