#include "PSXRootCounter.hpp"
#include "PSXUtility.hpp"

namespace NeoPSX
{
	PSXRootCounter::PSXRootCounter()
	{
		Reset();
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	void PSXRootCounter::Reset()
	{
		PSXClearMemory(mRootCounter, sizeof(TRootCounter)*4, "Root counters are invalid pointer.");
	}

	void PSXRootCounter::Update(uint16_t counter)
	{
		if(counter > 3) return;

		mRootCounter[counter].Count++;

		if((mRootCounter[counter].Mode&CMM_TARGET_MASK)>>3)
		{
			if(mRootCounter[counter].Count == mRootCounter[counter].Target)
			{
				// Interrupt
				// Reset Count
				mRootCounter[counter].Count = 0;
			}
		}
	}

	void PSXRootCounter::Update()
	{
		for(uint16_t Counter = 0; Counter < 4; Counter++)
		{
			Update(Counter);
		}
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	void PSXRootCounter::WriteByte(uint32_t address, uint8_t value)
	{
		if(InRange(address))
		{
			switch(COUNTER_REGISTER(address))
			{
			case 0:
				(*(uint8_t*)&(_Counter_.Count)) = value;
				break;
			case 1:
				(*(uint8_t*)&(_Counter_.Mode)) = value;
				break;
			case 2:
				(*(uint8_t*)&(_Counter_.Target)) = value;
				break;
			default: break;
			}
		}
	}

	void PSXRootCounter::WriteHword(uint32_t address, uint16_t value)
	{
		if(InRange(address))
		{
			switch(COUNTER_REGISTER(address))
			{
			case 0:
				(*(uint16_t*)&(_Counter_.Count)) = value;
				break;
			case 1:
				(*(uint16_t*)&(_Counter_.Mode)) = value;
				break;
			case 2:
				(*(uint16_t*)&(_Counter_.Target)) = value;
				break;
			default: break;
			}
		}
	}

	void PSXRootCounter::WriteWord(uint32_t address, uint32_t value)
	{
		if(InRange(address))
		{
			switch(COUNTER_REGISTER(address))
			{
			case 0:
				_Counter_.Count = value;
				break;
			case 1:
				_Counter_.Mode = value;
				break;
			case 2:
				_Counter_.Target = value;
				break;
			default: break;
			}
		}
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	uint8_t PSXRootCounter::ReadByte(uint32_t address) const
	{
		switch(COUNTER_REGISTER(address))
		{
			case 0:
				return (uint8_t)_Counter_.Count;
				break;
			case 1:
				return (uint8_t)_Counter_.Mode;
				break;
			case 2:
				return (uint8_t)_Counter_.Target;
				break;
			default: break;
		}

		return NULL;
	}

	uint16_t PSXRootCounter::ReadHword(uint32_t address) const
	{
		switch(COUNTER_REGISTER(address))
		{
			case 0:
				return (uint16_t)_Counter_.Count;
				break;
			case 1:
				return (uint16_t)_Counter_.Mode;
				break;
			case 2:
				return (uint16_t)_Counter_.Target;
				break;
			default: break;
		}

		return NULL;
	}

	uint32_t PSXRootCounter::ReadWord(uint32_t address) const
	{
		switch(COUNTER_REGISTER(address))
		{
			case 0:
				return _Counter_.Count;
				break;
			case 1:
				return _Counter_.Mode;
				break;
			case 2:
				return _Counter_.Target;
				break;
			default: break;
		}

		return NULL;
	}
} // Namespace NeoPSX