#ifndef EF_VERSION_INFO_HPP
#define EF_VERSION_INFO_HPP

#include "EFPlatform.hpp"

namespace EFramework
{
	/// Describes the version of a library.
	class EF_EXPORT EFVersionInfo
	{
	public:
		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Constructors

		/** The default constructor.
		  */
		EFVersionInfo(uint Major = 0, uint Minor = 0, uint Patch = 0);

		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Version Information Functions

		/** Retrieves the version information in a string formatted "major.minor.patch"
		  */
		char* GetString() const;
		/** Sets the version data inside this class.
		  */
		void SetVersionData(uint Major, uint Minor, uint Patch);

		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Overloaded Operators

		/** Compares two version info classes and sees if one is less than the other.
		  */
		bool operator <  (const EFVersionInfo& right) const;
		/** Compares two version info classes and sees if they are equal.
		  */
		bool operator == (const EFVersionInfo& right) const;
		/** Compares two version info classes and see if one is greater than the other.
		  */
		bool operator >  (const EFVersionInfo& right) const;
protected:
		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Variables

		uint vMajor;  ///< The major portion of the version.
		uint vMinor;  ///< The minor portion of the version.
		uint vPatch;  ///< The patch portion of the version.
	};
} // Namespace EFramework

#endif // EF_VERSION_INFO_HPP