#ifndef EF_ZIP_INPUT_STREAM_HPP
#define EF_ZIP_INPUT_STREAM_HPP

#include "EFPlatform.hpp"
#include "EFInputStream.hpp"

//== We Need To Define ZLIB_WINAPI since we're using MSVC++ ==//
#define ZLIB_WINAPI
#include "zlib.h"

namespace EFramework
{
	/// Defines an input stream from a file containing GZIPed data.
	class EF_EXPORT EFZipInputStream : public EFInputStream
	{
	public:
		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Constructors

		/** The default constructor.
		  */
		EFZipInputStream(const EFString& fileName);

		///////////////////////////////////////////////////////////////////////////////////////////////////
		// ZIP File Input Functions

		/** Reads a single character from the compressed stream.
		  */
		uchar ReadChar();
		/** Reads a single short integer from the compressed stream.
		  */
		ushort ReadShort();
		/** Reads a single integer from the compressed stream.
		  */
		uint ReadInt();
		/** Reads a single long integer from the compressed stream.
		  */
		ulong ReadLong();
		/** Reads a boolean value from the compressed stream.
		  */
		bool ReadBool();
		/** Reads a groupt of characters from the compressed stream.
		  */
		void ReadString(char* variable, ulong size);

		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Miscellaneous Functions

		/** Close the current compressed file input stream.
		  */
		void CloseStream();
	protected:
		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Variables

		gzFile mCompressedFile; ///< The compressed file from which we are reading.
	};
} // Namespace EFramework

#endif // EF_ZIP_INPUT_STREAM_HPP