#include "EFException.hpp"

namespace EFramework
{
	EFException::EFException(int code, const EFString& message, const EFString& file, const EFString& function, long line)
	: mCode( code ),
	  mLine( line ),
	  mFile( file ),
	  mMessage( message ),
	  mFunction( function )
	{ }

	EFException EFException::operator = (EFException& right)
	{
		//==================================================
		// Copy all of the exception information.
		//==================================================
		mCode     = right.mCode;
		mLine     = right.mLine;
		mFile     = right.mFile;
		mMessage  = right.mMessage;
		mFunction = right.mFunction;

		return *this;
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	int EFException::GetExceptionCode() throw()
	{
		return mCode;
	}

	EFString EFException::GetDetailedInformation() throw()
	{
		//==================================================
		// Return detailed exception information.
		//==================================================
		static char sBuffer[20];

		std::string mDetailed = "Exception Has Been Caught!\r\n";
		mDetailed += EFString("---------------------------------------\r\nException Details:\r\n---------------------------------------\r\n");

		mDetailed += "Code    : " + GetExceptionCodeStr() + "\r\n";

		_snprintf(sBuffer, 20, "%d", mLine);
		mDetailed += "Line    : " + EFString( sBuffer )  + "\r\n";

		mDetailed += "Function: " + mFunction + "\r\n";

		mDetailed += "File    : " + mFile + "\r\n";

		mDetailed += "Message : " + mMessage;

		return mDetailed;
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	EFString EFException::GetExceptionCodeStr() throw()
	{
		switch( mCode )
		{
		case EC_FATAL_ERROR       : return "EC_FATAL_ERROR";
		case EC_GENERAL_ERROR     : return "EC_GENERAL_ERROR";
		case EC_INVALID_PARAMETERS: return "EC_INVALID_PARAMETERS";
		case EC_ILLEGAL_ADDRESS   : return "EC_ILLEGAL_ADDRESS";
		case EC_ILLEGAL_OPCODE    : return "EC_ILLEGAL_OPCODE";
		case EC_ILLEGAL_PACKET    : return "EC_ILLEGAL_PACKET";
		case EC_PLUGIN_ERROR      : return "EC_PLUGIN_ERROR";
		case EC_STREAM_ERROR      : return "EC_STREAM_ERROR";
		case EC_GUI_ERROR         : return "EC_GUI_ERROR";
		default                   : return "UNKNOWN CODE";
		}
	}
} // Namespace EFramework