#include "EFLog.hpp"
#include "EFException.hpp"

namespace EFramework
{
	EFLog::EFLog(const EFString& name, LogLevel level)
	: mLevel( level )
	{
		//==================================================
		// Attempt to open the specified log file.
		//==================================================
		mFile.open( name.c_str() );

		//==================================================
		// If opening the file failed then throw an error.
		//==================================================
		if(!mFile.is_open())
		{
			EF_THROW(EFException::EC_FATAL_ERROR, EFString("Could not create the log file \'" + name + "\'"));
		}
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	EFLog::~EFLog()
	{
		mFile.close();
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	void EFLog::LogMessage(LogMessageLevel lml, const char* format, ...)
	{
		static char LogMessageBuffer[4096];

		va_list list;
		va_start(list, format);
		_vsnprintf(LogMessageBuffer, 4096, format, list);

		LogMessage(EFString( LogMessageBuffer ), lml);

		va_end  (list);
	}

	void EFLog::LogMessage(const EFString& message, LogMessageLevel level)
	{
		//==================================================
		// If the threshold is met then log message + time.
		//==================================================
		if((mLevel + level) >= LOG_THRESHOLD)
		{
			struct tm *pTime;
            time_t ctTime; time(&ctTime);
            pTime = localtime( &ctTime );
            mFile << "[" << std::setw(2) << std::setfill('0') << pTime->tm_hour
                  << ":" << std::setw(2) << std::setfill('0') << pTime->tm_min
                  << ":" << std::setw(2) << std::setfill('0') << pTime->tm_sec << "] : " << message << std::endl;
			mFile.flush();
		}
	}

	void EFLog::SetLogLevel(LogLevel level)
	{
		mLevel = level;
	}
} // Namespace EFramework