#ifndef PSX_ABOUT_DIALOG_HPP
#define PSX_ABOUT_DIALOG_HPP

#include <atlbase.h>
#include <atlwin.h>
#include <atlapp.h>
#include <atlctrls.h>
#include <atlctrlx.h>
#include <ToolTipDialog.h>
#include "EFramework.hpp"
#include "../resource.h"

namespace NeoPSX
{
	/// The about dialog definition.
	class PSXAboutDialog : public CDialogImpl< PSXAboutDialog >, public CToolTipDialog< PSXAboutDialog >
	{
	public:
		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Message Maps

		BEGIN_MSG_MAP( PSXAboutDialog )
			CHAIN_MSG_MAP( CToolTipDialog< PSXAboutDialog > )
			MESSAGE_HANDLER(WM_INITDIALOG, OnInitDialog)
			MESSAGE_HANDLER(WM_CLOSE, OnCloseDialog)
			COMMAND_ID_HANDLER(ID_ABOUT_OK, OnCloseCmd)
		END_MSG_MAP()

		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Enumerations

		enum { IDD = IDD_NEOPSX_ABOUT };

		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Constructors

		/** The default constructor.
		  */
		PSXAboutDialog(EFVersionInfo NeoPSXV, EFVersionInfo EFrameworkV);

		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Message Handler Functions

		/** Handle the initialization of this dialog box.
		  */
		LRESULT OnInitDialog(UINT, WPARAM, LPARAM, BOOL);
		/** Handles closing of the dialog by the X button.
		  */
		LRESULT OnCloseDialog(UINT, WPARAM, LPARAM, BOOL);
		/** Handle the cleanup and destruction of this dialog box.
		  */
		LRESULT OnCloseCmd  (WORD, WORD wID, HWND, BOOL);
	private:
		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Private Variables

		CHyperLink    mWebsiteLink; ///< Hyperlink to the official NeoPSX website.
		CEdit         mEdit;        ///< An edit control class.
		EFVersionInfo mV1, mV2;     ///< V1 = NeoPSX version - V2 = EFramework version
	};

} // Namespace NeoPSX

#endif // PSX_ABOUT_DIALOG_HPP