#ifndef PSX_HARDWARE_MANAGER_HPP
#define PSX_HARDWARE_MANAGER_HPP

#include <list>
#include "EFramework.hpp"

#include "PSXRootCounter.hpp"

namespace NeoPSX
{
	/// The interface through which all Playstation hardware device interactions are managed.
	class PSXHardwareManager
	{
	public:
		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Constructors

		/** The default constructor.
		  */
		PSXHardwareManager();

		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Destructors

		/** The default destructor.
		  */
		~PSXHardwareManager();

		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Basic Interface Functions

		/** Resets all of the Playstation hardware devices.
		  */
		void Reset();

		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Hardware Area Writes

		/** Writes a byte of data to the specified hardware device.
		  */
		void WriteByte(uint32_t address, uint8_t data);
		/** Writes a half-word of data to the specified hardware device.
		  */
		void WriteHword(uint32_t address, uint16_t data);
		/** Writes a word of data to the specified hardware device.
		  */
		void WriteWord(uint32_t address, uint32_t data);

		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Hardware Area Reads

		/** Reads a byte of data from the specified hardware device.
		  */
		uint8_t ReadByte(uint32_t address);
		/** Reads a half-word of data from the specified hardware device.
		  */
		uint16_t ReadHword(uint32_t address);
		/** Reads a word of data from the specified hardware device.
		  */
		uint32_t ReadWord(uint32_t address);
	private:
		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Private Variables

		PSXRootCounter mRootCounters; ///< The root counter hardware device.
	};
} // Namespace NeoPSX

#endif // PSX_HARDWARE_MANAGER_HPP