#ifndef PSX_R3000_DEBUGGER_HPP
#define PSX_R3000_DEBUGGER_HPP

#include <atlbase.h>
#include <atlwin.h>
#include <atlapp.h>
#include <atldlgs.h>
#include "../resource.h"

#include "PSXInterpreter.hpp"

namespace NeoPSX
{
	/// The playstation R3K cpu debugger dialog.
	class PSXR3000Debugger : public CPropertyPageImpl< PSXR3000Debugger >
	{
	public:
		/////////////////////////////////////////////////////////////////////////////////////////////////
		// The Message Map

		BEGIN_MSG_MAP(PSXR3000Debugger)
			MESSAGE_HANDLER(WM_INITDIALOG, OnInitDialog)
			CHAIN_MSG_MAP  (CPropertyPageImpl<PSXR3000Debugger>)
		END_MSG_MAP()

		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Public Enumerations

		enum { IDD = IDD_PROP_PAGE_R3K };

		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Constructors

		/** The default constructor.
		  */
		PSXR3000Debugger(TR3000Context* context);

		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Overridden Functions

		LRESULT OnInitDialog(UINT, WPARAM, LPARAM, BOOL&);

		/////////////////////////////////////////////////////////////////////////////////////////////////
		// The Update Functions

		/** Updates all of the register values being displayed.
		  */
		void Update();
	private:
		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Private Variables

		TR3000Context* mContext; ///< The private R3000 context structure.
	};
} // Namespace NeoPSX

#endif // PSX_R3000_DEBUGGER_HPP