#include "PSXEmulationDialog.hpp"
#include "EFramework.hpp"

namespace NeoPSX
{
	#define REGKEY_CPU_EMULATION "CpuEmulationMode"

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	LRESULT PSXEmulationDialog::OnInitDialog(UINT, WPARAM, LPARAM, BOOL)
	{
		//===============================================================
		// Center the window and set the tooltip size.
		//===============================================================
		CenterWindow();
		TTSize( 400 );

		//===============================================================
		// Read out our emulation mode setting from the registry.
		//===============================================================
		try
		{
			EFRegistryKey Registry("NeoPSX");
			mInterpreterOff = Registry.ReadInteger(REGKEY_CPU_EMULATION, TRUE);
		} catch(EFException& error) {
			AtlMessageBox(NULL, (LPCTSTR)error.GetDetailedInformation().c_str());
		}

		//=================================================================
		// Check the appropriate radio button based on the emulation mode.
		//=================================================================
		CheckRadioButton(IDC_INTERPRET_RADIO, IDC_DYNAREC_RADIO, mInterpreterOff ? IDC_DYNAREC_RADIO : IDC_INTERPRET_RADIO);

		return 0;
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	LRESULT PSXEmulationDialog::OnOK(WORD, WORD wID, HWND, BOOL)
	{
		//===============================================================
		// Save the emulation mode to the registry.
		//===============================================================
		try
		{
			EFRegistryKey Registry("NeoPSX");
			Registry.WriteInteger(REGKEY_CPU_EMULATION, mInterpreterOff);
		} catch(EFException& error) {
			AtlMessageBox(NULL, (LPCTSTR)error.GetDetailedInformation().c_str());
		}

		EndDialog( wID );
		return 0;
	}

	LRESULT PSXEmulationDialog::OnCancel(WORD, WORD wID, HWND, BOOL)
	{
		EndDialog( wID );
		return 0;
	}

	LRESULT PSXEmulationDialog::OnEmulationMethodChange(WORD wNotifyCode, WORD, HWND, BOOL)
	{
		//===============================================================
		// Only had messages where a button was clicked.
		//===============================================================
		if(wNotifyCode == BN_CLICKED)
		{
			//===============================================================
			// Ensure that our dynarec radio button is enabled.
			//===============================================================
			if(!GetDlgItem(IDC_DYNAREC_RADIO).IsWindowEnabled())
				return 0;

			//===============================================================
			// Toggle our mode value.
			//===============================================================
			mInterpreterOff = !(mInterpreterOff);

			//===============================================================
			// Check and uncheck the appropriate buttons.
			//===============================================================
			if(mInterpreterOff == 1)
			{
				CheckRadioButton(IDC_DYNAREC_RADIO, IDC_DYNAREC_RADIO, IDC_DYNAREC_RADIO);
				CheckDlgButton(IDC_INTERPRET_RADIO, BST_UNCHECKED);
			}
			if(mInterpreterOff == 0)
			{
				CheckRadioButton(IDC_INTERPRET_RADIO, IDC_INTERPRET_RADIO, IDC_INTERPRET_RADIO);
				CheckDlgButton(IDC_DYNAREC_RADIO, BST_UNCHECKED);
			}
		}

		return 0;
	}
} // Namespace NeoPSX