#include "PSXMachine.hpp"
#include "PSXExecutableLoader.hpp"

namespace NeoPSX
{
	PSXMachine::PSXMachine()
	: mProcessor(NULL)
	{
		mProcessor.reset( new PSXInterpreter() );
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	PSXMachine::~PSXMachine()
	{
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	void PSXMachine::Execute()
	{
		mProcessor->Execute();
	}

	void PSXMachine::Reset()
	{
		mProcessor->Reset();
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	const bool PSXMachine::LoadExecutable(const EFString& fileName)
	{
		//===============================================================
		// Reset all the emulated devices.
		//===============================================================
		Reset();

		//===============================================================
		// Declare our executable loader instance.
		//===============================================================
		PSXExecutableLoader ExecutableLoader;

		//===============================================================
		// If it was loaded successfully then set registers.
		//===============================================================
		if( ExecutableLoader.Load(mProcessor->GetMemory(), fileName) )
		{
			mProcessor->SetPC( ExecutableLoader.GetPC() );
			mProcessor->SetRegisterGPR(26, ExecutableLoader.GetK0());
			mProcessor->SetRegisterGPR(28, ExecutableLoader.GetGP0());
			mProcessor->SetRegisterGPR(29, (ExecutableLoader.GetSP() == 0) ? 0x801FFFF0 : ExecutableLoader.GetSP());
			mProcessor->SetRegisterGPR(30, ExecutableLoader.GetFP());
			mProcessor->SetRegisterGPR(31, ExecutableLoader.GetRA());

			ExecutableLoader.Close();
			return true;
		}
		else
		{
			ExecutableLoader.Close();
			return false;
		}
	}

	TR3000Context* PSXMachine::GetContext() const
	{
		return &(mProcessor->GetContext());
	}
} // Namespace NeoPSX