//----------------------------------------------------------------------------//
// RbPSe - Sony Play Station Emulator                                         //
// Copyright (C) notes:                                                       //
//   Code: RomikB, 2002-2003                                                  //
//        <romikb@mail.ru>                                                    //
//                                                                            //
// This program is free software; you can redistribute it and/or              //
// modify it under the terms of the GNU General Public License                //
// as published by the Free Software Foundation; either version 2             //
// of the License, or (at your option) any later version.                     //
//                                                                            //
// This program is distributed in the hope that it will be useful,            //
// but WITHOUT ANY WARRANTY; without even the implied warranty of             //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              //
// GNU General Public License for more details.                               //
//                                                                            //
// You should have received a copy of the GNU General Public License          //
// along with this program; if not, write to the Free Software                //
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.//
//----------------------------------------------------------------------------//
#include "bios.h"

#include "dyn.h"
#include "irq.h"

#include "defs.h"

#include <stdio.h>
/******************************************************************************/
register long *psxregs __asm__("esi");
/******************************************************************************/
static void *__A0Table[0xc0];
static void *__B0Table[0x60];
static void *__C0Table[0x20];
/******************************************************************************/
static void DefC0Func(void)
{
	printf("[  HLE  ]Warning: UnHooked HLE Function [ c0 : %lx ]\n", psxregs[ REG_T1 ]);
}
static void DefB0Func(void)
{
	printf("[  HLE  ]Warning: UnHooked HLE Function [ b0 : %lx ]\n", psxregs[ REG_T1 ]);
}
static void DefA0Func(void)
{
	printf("[  HLE  ]Warning: UnHooked HLE Function [ a0 : %lx ]\n", psxregs[ REG_T1 ]);
	fflush(0);
}
/******************************************************************************/
static void C0Function(void){ goto *__C0Table[ psxregs[ REG_T1 ] ]; }
static void B0Function(void){ goto *__B0Table[ psxregs[ REG_T1 ] ]; }
static void A0Function(void){ goto *__A0Table[ psxregs[ REG_T1 ] ]; }
/******************************************************************************/
void	cpuHookBIOSC0(void *func, long pos){ __C0Table[ pos ] = func; }
void	cpuHookBIOSB0(void *func, long pos){ __B0Table[ pos ] = func; }
void	cpuHookBIOSA0(void *func, long pos){ __A0Table[ pos ] = func; }
/******************************************************************************/
/* System Call 3 */
static void SysCall3(void)
{
	printf("SYSCALL 3\n");
}
/* System Call 2 *//* Exit Critical Section */
static void SysCall2(void)
{
	hleExitCriticalSection();
}
/* System Call 1 *//* Enter Critical Section */
static void SysCall1(void)
{
	psxregs[ REG_V0 ] = hleEnterCriticalSection();
}
/* System Call 0 */
static void SysCall0(void)
{
	printf("SYSCALL 0\n");
}
/* System Call Functions */
static void *SystemCallFunctions[4] = { SysCall0 , SysCall1 , SysCall2 , SysCall3 };
/* System Call Function */
void	cpuSystemCall(void){ goto *SystemCallFunctions[ psxregs[ REG_A0 ] ]; }
/******************************************************************************/

long biosOpen()
{
	long i;
	for( i = 0 ; i < 0xc0 ; i++ ) __A0Table[i] = DefA0Func;
	for( i = 0 ; i < 0x60 ; i++ ) __B0Table[i] = DefB0Func;
	for( i = 0 ; i < 0x20 ; i++ ) __C0Table[i] = DefC0Func;
	cpuHookAddr(A0Function, 0x000000a0);
	cpuHookAddr(B0Function, 0x000000b0);
	cpuHookAddr(C0Function, 0x000000c0);
	return 0;
}
