#ifndef _HLECORE_H_
#define _HLECORE_H_

//--defs

#define	DescEV				0xf1000000

#define	EvMdINTR			0x1000
#define	EvMdNOINTR			0x2000

#define	EvStUNUSED			0x0000
#define	EvStWAIT			0x1000
#define	EvStACTIVE			0x2000
#define	EvStALREADY			0x4000

//--structs

struct ToT {
	unsigned long *head;
	long size;
};

struct EvCB {
	unsigned long desc;
	long status;
	long spec;
	long mode;
	long (*FHandler)();
	long system[2];/* reserved by system */
};
/* RbPSe Self */
struct IntRPentry {
	struct IntRPentry *next;
	void (*func2)(long);
	long (*func1)(void);
	long system;/* reserved by system */
};
/* RbPSe Self More */
struct IntRP {
	struct IntRPentry *entry;
	long system;/* reserved by system */
};

//--funcs

void	hleSysEnqIntRP(long index, struct IntRPentry *queue);

//--plugins

long	hlecoreOpen();

//--globals

extern struct ToT SysToT[32];

#endif//_HLECORE_H_
