//----------------------------------------------------------------------------//
// RbPSe - Sony Play Station Emulator                                         //
// Copyright (C) notes:                                                       //
//   Code: RomikB, 2002-2003                                                  //
//        <romikb@mail.ru>                                                    //
//                                                                            //
// This program is free software; you can redistribute it and/or              //
// modify it under the terms of the GNU General Public License                //
// as published by the Free Software Foundation; either version 2             //
// of the License, or (at your option) any later version.                     //
//                                                                            //
// This program is distributed in the hope that it will be useful,            //
// but WITHOUT ANY WARRANTY; without even the implied warranty of             //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              //
// GNU General Public License for more details.                               //
//                                                                            //
// You should have received a copy of the GNU General Public License          //
// along with this program; if not, write to the Free Software                //
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.//
//----------------------------------------------------------------------------//
#include "irq.h"

#include "hardware.h"
#include "bios.h"
#include "event.h"
#include "dyn.h"
#include "jmp.h"

#include "defs.h"

#include "emulator.h"

#include <stdio.h>
//#include <stdlib.h>
//#include <string.h>
#include <setjmp.h>
/******************************************************************************/
extern	RbPSe_Emulator	*Emulator;
/******************************************************************************/
register unsigned long *psxregs		__asm__("esi");
register unsigned char *psxmemory	__asm__("edi");
/******************************************************************************/
//HWWriteWordType HWWriteWord;
//HWReadWordType HWReadWord;
//static MemoryWriteDataType		MemoryWriteData;
//static CPUExecType				CPUExec;
/******************************************************************************/
//struct TCBH SysTCBH;
//struct TCB SysTCB[4];
//struct EvCB SysEvCB[16];
/******************************************************************************/
static long isCritical = 1;
static long isWait;
/******************************************************************************/
/* System Call 0 */
/* System Call 1 */
long hleEnterCriticalSection(void)
{
	isCritical = 1;
	printf("[ hle ](--->>>)EnterCriticalSection(--->>>)\n");
	return 1;
}
/* System Call 2 */
void hleExitCriticalSection(void)
{
	isCritical = 0;
	printf("[ hle ](<<<---)ExitCriticalSection(<<<---)\n");
}
/* System Call 3 */
/******************************************************************************/
/* Exception handling */
/* Jump buffer for Exception */
//static long entry_int_enable;

static void *entry_int;
static jmp_buf int_ret;

/* Exception */
static void cpuIrqExecute(void)//Not Optimize
{
	long *psxregs_old = psxregs;
	((long*)Emulator -> Storage2)[ REG_GP ] = ((long*)Emulator -> Storage)[ REG_GP ];
	psxregs = Emulator -> Storage2;
	psxregs[ REG_RA ] = 0x00000090;//find correct place and value
	psxregs[ REG_SP ] = 0x000085d8;//find correct place and value
/*	struct TCB *currentTCB;
	long *regs, func_1_ret_value;
*/
//
	if( ! setjmp( int_ret ) )
	{
		long func_1_ret_value;
		struct IntRP *currentIntRP, *maxIntRP;
		struct IntRPentry *currentIntRPentry;
		long (*func1)(void);
		void (*func2)(long);
///		printf("Enter Interrupt\n");
///		fflush(0);
//
//	interrupt_status = 0;	EnterCriticalSection
/*		currentTCB = (( struct TCBH* )( SysToT[1].head )) -> entry;
		regs = currentTCB -> reg;
		regs[R_AT] = psxregs[REG_AT];
		regs[R_V0] = psxregs[REG_V0];
		regs[R_V1] = psxregs[REG_V1];
		regs[R_RA] = psxregs[REG_RA];
//	Some unneeded code
//	regs[R_EPC] = ...
		regs[R_A0] = psxregs[REG_A0];
		regs[R_A1] = psxregs[REG_A1];
		regs[R_A2] = psxregs[REG_A2];
		regs[R_A3] = psxregs[REG_A3];
//	regs[R_SR] = ...
//	regs[R_CAUSE] = ...
//	regs[R_K1] = ...
		regs[R_S0] = psxregs[REG_S0];
		regs[R_S1] = psxregs[REG_S1];
		regs[R_S2] = psxregs[REG_S2];
		regs[R_S3] = psxregs[REG_S3];
		regs[R_S4] = psxregs[REG_S4];
		regs[R_S5] = psxregs[REG_S5];
		regs[R_S6] = psxregs[REG_S6];
		regs[R_S7] = psxregs[REG_S7];
		regs[R_T0] = psxregs[REG_T0];
		regs[R_T1] = psxregs[REG_T1];
		regs[R_T2] = psxregs[REG_T2];
		regs[R_T3] = psxregs[REG_T3];
		regs[R_T4] = psxregs[REG_T4];
		regs[R_T5] = psxregs[REG_T5];
		regs[R_T6] = psxregs[REG_T6];
		regs[R_T7] = psxregs[REG_T7];
		regs[R_T8] = psxregs[REG_T8];
		regs[R_T9] = psxregs[REG_T9];
		regs[R_GP] = psxregs[REG_GP];
		regs[R_SP] = psxregs[REG_SP];
		regs[R_FP] = psxregs[REG_FP];
		regs[R_MDHI] = psxregs[REG_HI];
		regs[R_MDLO] = psxregs[REG_LO];
//	psxregs[REG_SP] = 0x000085d8;// MEM[6cf0]
////	psxregs[REG_GP] = 0x0000f450;
////	psxregs[REG_FP] = psxregs[REG_SP];
/////---///	psxregs[REG_RA] = 0x90;
*/
		currentIntRP = ( struct IntRP* )( SysToT[0].head );
		maxIntRP = currentIntRP + 4;
		while ( currentIntRP < maxIntRP )
		{
			if (( currentIntRPentry = currentIntRP -> entry ))
			{
				if(( func1 = currentIntRPentry -> func1 ))
				{
					if(( func_1_ret_value = func1() ))
					{
						if(( func2 = currentIntRPentry -> func2 ))
						{
							func2( func_1_ret_value );
						}
					}
				}
				currentIntRPentry = currentIntRPentry -> next;
			}
			currentIntRP++;
		}
		printf("before before entry int( %lx )\n", entry_int );
		if( entry_int )
		{
			printf("before entry int\n");
			fflush(0);
			hlelongjmp( entry_int, 1 );
		}
	}
	psxregs = psxregs_old;
	printf("Exit Interrupt\n");
	fflush(0);
}
/******************************************************************************/
/******************************************************************************/
/******************************************************************************/
/******************************************************************************/
static union { unsigned long word; unsigned short half; } irq_register , irq_mask ;
/******************************************************************************/
void cpuIrqMaskDisable(unsigned long mask)
{
	irq_mask.word &= ~mask;
}
void cpuIrqMaskEnable(unsigned long mask)
{
	irq_mask.word |= mask;
}
void cpuIrqDisable(unsigned long mask)
{
	irq_register.word &= ~mask;
}
unsigned long cpuCheckIrqWord(unsigned long mask)
{
	return mask & irq_mask.word & irq_register.word;
}
unsigned short cpuCheckIrqHalf(unsigned short mask)
{
	return mask & irq_mask.half & irq_register.half;
}
void cpuIrqRequest(long mask)
{
	irq_register.word |= mask;
	if( irq_mask.word & mask )
	{
		if(!isCritical)
		{
			cpuIrqExecute();
		}
		else
		{
			isWait++;
		}
	}
}
/******************************************************************************/
void cpuWriteIrqRegisterWord(unsigned long data)
{
	irq_register.word &= irq_mask.word & data;
}
/******************************************************************************/
unsigned long cpuReadIrqRegisterWord(void)
{
	return irq_register.word;
}
/******************************************************************************/
void cpuWriteIrqMaskWord(unsigned long data)
{
//	printf("[irq] Write Word Mask [ %lx ]\n", data );
	if(( irq_mask.word = data ) & irq_register.word)
	{
		if( !isCritical )
		{
			cpuIrqExecute();
		}
		else
		{
			isWait++;
		}
	}
}
/******************************************************************************/
unsigned long cpuReadIrqMaskWord(void)
{
	return irq_mask.word;
}
/******************************************************************************/
void cpuWriteIrqRegisterHalf(unsigned short data)
{
	irq_register.half &= irq_mask.half & data;
}
/******************************************************************************/
unsigned short cpuReadIrqRegisterHalf(void)
{
	return irq_register.half;
}
/******************************************************************************/
void cpuWriteIrqMaskHalf(unsigned short data)
{
//	printf("[irq] Write Half Mask [ %lx ]\n", data );
	if(( irq_mask.half = data ) & irq_register.half)
	{
		if( !isCritical )
		{
			cpuIrqExecute();
		}
		else
		{
			isWait++;
		}
	}
}
/******************************************************************************/
unsigned short cpuReadIrqMaskHalf(void)
{
	return irq_mask.half;
}
/******************************************************************************/
/******************************************************************************/
/* EXTRA HLE functions */
/* hook entry int function */
void hleHookEntryInt( hlejmp_buf env )
{
	env[ HLEJB_ESI ] = (long)( Emulator->Storage2 );
	entry_int = env;
	printf("[ hle ] HookEntryInt( %lx )\n", entry_int );
	fflush(0);
}
/* reset entry int function */
void hleResetEntryInt(void)
{
	entry_int = 0;
	printf("[ hle ] ResetEntryInt()\n");
	fflush(0);
}
void hleReturnFromException(void)
{
	printf("[ hle ] ReturnFromException()\n");
	fflush(0);
	longjmp( int_ret, 1 );
}
/******************************************************************************/
//void psx
void psxResetEntryInt(void)
{
	hleResetEntryInt();
}
/*
static void SysEnqIntRP(long index, struct IntRPentry *queue)
{
	struct IntRP *intrp;
	printf("[ OSHLE ] SysEnqIntRP( %lx , %lx )\n", index, queue);
	intrp = (struct IntRP*)(SysToT[0].head) + index;
	queue -> next = intrp -> entry;
	intrp -> entry = queue;
}
*/
/*static struct IntRPentry *SysDeqIntRP(int index, struct IntRPentry *queue)
{
	struct IntRPentry *entry;
	struct IntRP *intrp = (struct IntRP*)(SysToT[0].head) + index;
	if(!(entry = intrp -> entry)) return 0;
	while( entry )
	{
		if( entry == queue )
		{
			entry
		}
		entry = entry -> next;
	}
//	printf("[ OSHLE ] SysDeqIntRP( ... , ... )\n");
}*/
/******************************************************************************/
/* EVENT EXTRA HLE functions */
/* Deliver Event //libapi// */
/*
static void DeliverEvent(unsigned long ev1, long ev2)//b0_07
{
	struct EvCB *curEvCB, *maxEvCB;
	curEvCB = SysToT[4].head;
	maxEvCB = (struct EvCB*)( (char*)curEvCB + SysToT[4].size );
	do
	{
		if((curEvCB->status == EvStACTIVE)&&(curEvCB->desc == ev1)&&(curEvCB->spec == ev2))
		{
			if(curEvCB -> mode == EvMdNOINTR) curEvCB -> status = EvStALREADY;
			else (curEvCB -> FHandler)();
		}
		curEvCB++;
	}
	while( curEvCB < maxEvCB );
}
*/
/*** Event Functions **********************************************************/
/* get_free_EvCB_slot */
/*
static long get_free_EvCB_slot()
{
	struct EvCB *curEvCB, *maxEvCB;
	curEvCB = SysToT[4].head;
    maxEvCB = (struct EvCB*)( (char*)curEvCB + SysToT[4].size );
	do
	{
		if( curEvCB -> status == EvStUNUSED ) return ( curEvCB - (struct EvCB*)SysToT[4].head );
		curEvCB++;
	}
	while( curEvCB < maxEvCB );
	return -1;
}
*/
/* Open Event //libapi// */
static void psxOpenEvent(void)
{
	psxregs[ REG_V0 ] = hleOpenEvent(
		psxregs[ REG_A0 ],
		psxregs[ REG_A1 ],
		psxregs[ REG_A2 ],
		( long (*)() ) cpuDynAddrGet( psxregs[ REG_A3 ] ) );
//		( long (*)() )( psxmemory + ( psxregs[ REG_A3 ] & 0x001fffff )) );
	printf("||| %lx |||\n", psxregs[ REG_V0 ] );
}
/* Enable Event //libapi// */
static void psxEnableEvent(void)
{
	psxregs[ REG_V0 ] = hleEnableEvent(
    	psxregs[ REG_A0 ] );
	printf("||| %lx |||\n", psxregs[ REG_V0 ] );
}
/******************************************************************************/
/* _ROOT_1_ interrupt queue functions */
static long __root__1__func__1__(void)//17f4
{
//	printf("Yo\n");
//	fflush(0);
	if( cpuCheckIrqHalf( 0x00000020 ) )
	{
		hleDeliverEvent( 0xf2000001, 0x00000002 );
		return 1;
	}
	return 0;
}
static void __root__1__func__2__(long value)//1958
{
//	printf("Yo2\n");
//	fflush(0);
	cpuIrqDisable( 0x00000020 );
}
static struct IntRPentry __root__1__handler__ = { 0 , __root__1__func__2__ , __root__1__func__1__ , 0 };
/******************************************************************************/
//static long hleopen(char *devname, int flag)//bfc0d890
//{//partial
//	printf("open(%s,%x)\n",devname,flag);
//	switch( flag )
//	{
//	case O_RDONLY:
//		return (long)fopen( devname , "rb" ) ? : -1;
//    }
//	return -1;
//}
//static long hleclose(long fd)//bfc0d8a0
//{
//	printf("close(%lx)\n",fd);
//	return fclose( (FILE*)fd );
//}
//static long hleread(long fd, void *buf, long n)//bfc0d8b0
//{
//	printf("read(%lx,%lx,%lx)\n", fd , (long)buf , n );
//	return fread( buf , 1 , n , (FILE*)fd );
//}
/******************************************************************************/
//static long ___LoadHeader( long hfile , struct EXEC *exec)//bfc03c90
//{
//	char buf[0x800];
//	if( hleread( hfile , buf , 0x00000800 ) < 0x00000800 ) return 0;
//	memcpy( exec , buf + 0x10 , 0x0000003c );//at bfc02b50
//	return 1;
//}
/******************************************************************************/
//A0:41//LoadTest//bfc039b0
//static long hleLoad(char *name, struct EXEC *exec)//A0:42//Load//bfc03a18
//{
//	long hfile;
//	char *buf;
//	hfile = hleopen( name , O_RDONLY );//at bfc0d890
//	if( hfile < 0 ) return 0;
//	if( !___LoadHeader( hfile , exec ) )//at bfc03c90
//	{
//		hleclose( hfile );//at bfc0d8a0
//		return 0;
//	}
//	buf = malloc( exec -> t_size );
//	hleread( hfile , buf , exec -> t_size );//at bfc0d8b0
//	MemoryWriteData( exec -> t_addr , buf , exec -> t_size );
//	free( buf );
//	hleclose( hfile );//at bfc0d8a0;
//	FlushCashe();//at bfc01920
//	return 1;
//}
//A0:51//LoadExec//bfc03aa4
//static long hleExec(struct EXEC *exec, long argc, char *argv[])//A0:43//Exec//bfc03cf0
//{
//	CPUExec( exec -> pc0 );
//	return 1;
//}
/******************************************************************************/
//static void ___boot___(void)//A0:A0//_boot//bfc06ca4
//{
/*
	int i;
//--	booting
	hle_interrupt_mask.word = 0x00000001;
//--	tables
	SysToT[1].head = &SysTCBH;
	SysToT[2].head = SysTCB;
	SysTCBH.entry = SysTCB;
//	for( i = 0 ; i < 4 ; i++ )
	for( i = 0 ; i < 16 ; i++ ) SysEvCB[i].status = 0;
	isCritical = 0;
//--	int handlers
	ResetEntryInt();
*/
//}
/******************************************************************************/

long irqOpen()
{
	cpuHookBIOSB0( psxResetEntryInt , 0x18 );
	cpuHookBIOSB0( psxOpenEvent, 0x08 );
	cpuHookBIOSB0( psxEnableEvent, 0x0c );
	cpuHookPortWord( cpuWriteIrqRegisterWord, cpuReadIrqRegisterWord, 0x00001070 );
	cpuHookPortWord( cpuWriteIrqMaskWord, cpuReadIrqMaskWord, 0x00001074 );
	cpuHookPortHalf( cpuWriteIrqRegisterHalf, cpuReadIrqRegisterHalf, 0x00001070 );
	cpuHookPortHalf( cpuWriteIrqMaskHalf, cpuReadIrqMaskHalf, 0x00001074 );
	hleSysEnqIntRP( 2, &__root__1__handler__ );
	return 0;
}
