#include "libetc_hle_main.h"
#include "irq.h"
#include "jmp.h"
#include "dyn.h"

#include <stdio.h>

/******************************************************************************/
register unsigned long *psxregs		__asm__("esi");
register unsigned char *psxmemory	__asm__("edi");
/******************************************************************************/
intrDataStruct intrData = { 0 };
intrCBStruct _intrCB_ = {
	"$Id: libetc_hle.c,v 1.00 2004/03/08 11:00:00 romikb Exp $",
	0,
	setIntr,
	startIntr,
	stopIntr,
	0,
	resetIntr
};
intrCBStruct*	intrCB = &_intrCB_;
/******************************************************************************/
void	(*cbIntrVSync[8])();
uint32	Vcount;
void	(*cbIntrDMA[8])();
/******************************************************************************/
void	trapIntrVSync()
{
	int i;
	Vcount++;
	printf("[[[VSync]]]\n");
	fflush(0);
	for( i = 0 ; i < 8 ; i++ )
		if( cbIntrVSync[i] )
		{
			__asm__("pusha");
			cbIntrVSync[i]();
			__asm__("popa");
		}
	printf("]]]VSync[[[\n");
	fflush(0);
}
/******************************************************************************/
void	trapIntrDMA()
{
//	int i;
//	u_long mask;
//	while(mask = (*dicr >> 24) & 0x7f)
//	{
//		i = 0;
//		while(mask && i<7)
//		{
//			if(mask & 1)
//			{
//				*dicr &= (1 << (24 + i)) | 0xffffff;
//				if(cbIntrDMA[i]) cbIntrDMA[i]();
//			}
//			i++;
//			mask >>= 1;
//		}
//	}
//	if(((*dicr & 0xff000000) == 0x80000000) || (*dicr & 0x8000))
//	{
//		printf("DMA bus error: code=%08x\n", *dicr);
//		for(i=0; i<7; i++) printf("MADR[%d]=%08x\n", i, dma[i].madr);
//	}
}
/******************************************************************************/
void	trapIntr()
{
	uint16 intr;
	long i;

	if( !intrData.started )
	{
		printf("unexpected interrupt(%04x)\n", cpuReadIrqRegisterHalf() );
		hleReturnFromException();
	}

	intrData.trapped = 1;

	intr = cpuCheckIrqHalf( intrData.mask );

	for( i = 0 ; intr ; i++ , intr >>= 1 )
	{
		if(i >= 11) break;
		if(intr & 1)
		{
			cpuWriteIrqRegisterHalf( ~(1 << i) );
			if( intrData.cbIntr[i] ) intrData.cbIntr[i]();
		}
	}
/*
    if(*int_reg & *int_mask)
    {
        if(timeout++ > 2048)
        {
            printf("intr timeout(%.04x:%04x)\n", *int_reg, *int_mask);
            timeout = 0;
            *int_reg = 0;
        }
    } else timeout = 0;
*/
	intrData.trapped = 0;

	hleReturnFromException();
}
/******************************************************************************/
void*	startIntr()
{
	if( intrData.started ) return 0;
//        *int_reg = *int_mask = 0;
//        *dpcr = 0x33333333;
	memclr( (void*)&intrData, sizeof(intrData) / 4 );
	if( hlesetjmp(intrData.trap) ) trapIntr();
	(void*)intrData.trap[HLEJB_ESP] = &intrData.stack[0xfb0];
	hleHookEntryInt(intrData.trap);
	intrData.started = 1;
	intrCB->setIntrVSync = startIntrVSync();
	intrCB->setIntrDMA = startIntrDMA();
//        _96_remove();
	hleExitCriticalSection();
	return &intrData;
}
/******************************************************************************/
void	memclr( uint32 *ptr, int32 n ){ while(n--) *ptr++ = 0; }
/******************************************************************************/
